function [rmin,rmax,hmin,hmax] = approximateBounds_NR(restr,phi,opt)
% Approximate bounds of the identified set for different parameters
% via simulation.
% Inputs:
% - restr: structure containing information about restrictions
% - phi: structure containing reduced-form VAR parameters
% - opt: structure containing model information and options

H = opt.H;
ivar = opt.ivar;
Qdraws = opt.Qdraws;
vma = phi.vma;

%% Compute identified sets for responses to standard-deviation shock.

% Obtain draws from space of orthonormal matrices satisfying restrictions.
Q0 = drawQs_NR(restr,phi,opt);
q0 = squeeze(Q0(:,opt.jshock,:)); % Extract relevant column of Q for computing impulses

rDraw = zeros(H+1,length(ivar),Qdraws);

for hh = 1:H+1 % For each horizon

    % Extract required rows of horizon-h VMA coefficient matrix.
    Cphi = vma(ivar,:,hh);
    % Multiply by column of Q (for each draw) to obtain impulse responses.
    rDraw(hh,:,:) = Cphi*q0;

end

% Compute minimum and maximum impulse response over draws of Q.
rmin = min(rDraw,[],3);
rmax = max(rDraw,[],3);

%% Compute identified set for impulse responses to unit shock.
% For each draw of Q, divide impulse responses by impact response of first
% variable. Resulting impulse resposes are with respect to a unit shock to
% the first variable.
hDraw = rDraw./rDraw(1,1,:);

% Compute minimum and maximum over draws of Q.
hmin = min(hDraw,[],3);
hmax = max(hDraw,[],3);

end

