# Load and clean 742 data ####

## Load in aggregate raw data ####
df_742 <- read_csv(file = paste0(input_path, "df_742_raw.csv")) 

## Clean 742 data ####

df_742 <- df_742 %>% 
  mutate(smallbus_credit = pmax(ARF_742_0A_BSAO28606, ARF_742_0B_BSAO28606, na.rm = TRUE), 
         mediumbus_credit = pmax(ARF_742_0A_BSAO28627, ARF_742_0B_BSAO28627, na.rm = TRUE),
         SME_credit = pmax(smallbus_credit, 0, na.rm = TRUE) + pmax(mediumbus_credit, 0, na.rm = TRUE),
         largebus_credit = pmax(ARF_742_0A_BSAO28643, ARF_742_0B_BSAO28643, na.rm = TRUE))

df_742 <- df_742 %>%
  select(period, institution_code, smallbus_credit, mediumbus_credit, SME_credit, largebus_credit)

df_742 <- df_742 %>%
  arrange(institution_code, period) %>%
  group_by(institution_code) %>%
  mutate(smallbus_credit_3mma = rollmean(smallbus_credit, 3, fill = NA, align = "right")) %>%
  mutate(mediumbus_credit_3mma = rollmean(mediumbus_credit, 3, fill = NA, align = "right")) %>%
  mutate(SME_credit_3mma = rollmean(SME_credit, 3, fill = NA, align = "right")) %>%
  mutate(largebus_credit_3mma = rollmean(largebus_credit, 3, fill = NA, align = "right")) %>%
  ungroup()

df_742_base <- df_742 %>%
  filter(period == "2020-01-31") %>%
  rename(smallbus_credit_base = smallbus_credit_3mma, mediumbus_credit_base = mediumbus_credit_3mma,
         SME_credit_base = SME_credit_3mma, largebus_credit_base = largebus_credit_3mma) %>%
  select(institution_code, smallbus_credit_base, mediumbus_credit_base, SME_credit_base, largebus_credit_base)


df_742 <- left_join(df_742, df_742_base, by = c("institution_code"))

df_742 <- df_742 %>%
  arrange(institution_code, period) %>%
  mutate(smallbus_credit_growth_cum_3mma = (smallbus_credit_3mma / smallbus_credit_base) * 100 - 100) %>%
  mutate(mediumbus_credit_growth_cum_3mma = (mediumbus_credit_3mma / mediumbus_credit_base) * 100 - 100) %>%
  mutate(SME_credit_growth_cum_3mma = (SME_credit_3mma / SME_credit_base) * 100 - 100) %>%
  mutate(largebus_credit_growth_cum_3mma = (largebus_credit_3mma / largebus_credit_base) * 100 - 100) %>%
  mutate(smallbus_credit_growth_cum = (smallbus_credit / smallbus_credit_base) * 100 - 100) %>%
  mutate(mediumbus_credit_growth_cum = (mediumbus_credit / mediumbus_credit_base) * 100 - 100) %>%
  mutate(SME_credit_growth_cum = (SME_credit / SME_credit_base) * 100 - 100) %>%
  mutate(largebus_credit_growth_cum = (largebus_credit / largebus_credit_base) * 100 - 100)

df_742$smallbus_credit_growth_cum_3mma[is.nan(df_742$smallbus_credit_growth_cum_3mma)] <- NA
df_742$mediumbus_credit_growth_cum_3mma[is.nan(df_742$mediumbus_credit_growth_cum_3mma)] <- NA
df_742$SME_credit_growth_cum_3mma[is.nan(df_742$SME_credit_growth_cum_3mma)] <- NA
df_742$largebus_credit_growth_cum_3mma[is.nan(df_742$largebus_credit_growth_cum_3mma)] <- NA
df_742$smallbus_credit_growth_cum[is.nan(df_742$smallbus_credit_growth_cum)] <- NA
df_742$mediumbus_credit_growth_cum[is.nan(df_742$mediumbus_credit_growth_cum)] <- NA
df_742$SME_credit_growth_cum[is.nan(df_742$SME_credit_growth_cum)] <- NA
df_742$largebus_credit_growth_cum[is.nan(df_742$largebus_credit_growth_cum)] <- NA

## Placebo test - Small and Medium credit ####

smallbus_credit <- df_742 %>%
  mutate(business_credit = smallbus_credit) %>%
  mutate(business_credit_3mma = smallbus_credit_3mma) %>%
  mutate(business_credit_base = smallbus_credit_base) %>%
  mutate(credit_growth_cum_3mma = smallbus_credit_growth_cum_3mma) %>%
  mutate(credit_growth_cum = smallbus_credit_growth_cum) %>%
  mutate(small_bus_dummy = 1) %>%
  mutate(borrower_type = "small")

mediumbus_credit <- df_742 %>%
  mutate(business_credit = mediumbus_credit) %>%
  mutate(business_credit_3mma = mediumbus_credit_3mma) %>%
  mutate(business_credit_base = mediumbus_credit_base) %>%
  mutate(credit_growth_cum_3mma = mediumbus_credit_growth_cum_3mma) %>%
  mutate(credit_growth_cum = mediumbus_credit_growth_cum) %>%
  mutate(small_bus_dummy = 0) %>%
  mutate(borrower_type = "medium")

# Placebo test data

business_lending_placebo <- bind_rows(smallbus_credit, mediumbus_credit) %>%
  arrange(institution_code) %>% 
  mutate(time_dummy = ifelse(period >= "2020-03-31", 1, 0)) %>%
  mutate(time_small_bus_dummy = time_dummy * small_bus_dummy)

business_lending_placebo <- business_lending_placebo %>%
  filter(institution_code != "Outlier 1") %>%
  filter(institution_code != "Outlier 2") %>%
  filter(period >= first_month & period <= last_month)

placebo_regression <- business_lending_placebo %>%
  filter(period == "2021-03-31")

# Clean environment

rm(mediumbus_credit, smallbus_credit, df_742_base)
