# Load other data ####

## Institution details ####

bank_names <- read_csv(paste0(input_path, "master_individual_institution_current_period.csv")) 

bank_names <- bank_names %>%
  select(institution_name, institution_code, findur_code, funding_allowance_rounded) %>%
  mutate(institution_type = "ADI") %>%
  mutate(eligible_bank = ifelse(findur_code != "#N/A" & funding_allowance_rounded > 0, 1, 0))

## Bank characteristics ####
# We use pre-defined data 

df_bank_characteristics <- read.csv(paste0(input_path, "df_bank_characteristics.csv"))

## TFF usage by bank ####

tff_usage <- read_csv(paste0(input_path, "usage_by_selfsecs.csv")) %>%
  mutate(accessed_tff = ifelse(settlement_amount == 0, 0, 1))

tff_usage_assets <- read_csv(paste0(input_path,"allowances_usage_assets_ADI.csv")) %>%
  select(institution_name, drawdown_assets, drawdown) %>%
  rename(drawdown_final_millions = drawdown)

tff_usage <- left_join(tff_usage, tff_usage_assets, by = c("institution_name"))

## SME and large base data ####

source("load_clean_SME_base.R")

## Load 742 data ####

source("load_742_data.R")

## Load fixed-term lending data ####

source("load_fixed_term_data.R")

## Load 742 data for bank_non-bank lending  ####

source("load_742_institution_type_data.R")

## Sector lending data ####

source("load_sector_data.R")

## Load 720.1 data ####

source("load_720_1_data.R")

## Clean environment

rm(tff_usage_assets, adhoc_credit, adhoc_reporters, 
   arf742, arf742_base, arf742_raw, bank_names,
   business_lending_prebind, df_720_1_base, 
   df_720_1, df_742, df_raw_720_1, industry, 
   large_business_lending, missing_data_720_1, 
   reporting_institutions_720_1, required_720_1, 
   sector, sector_base, tff_usage_forjoining, 
   to_check_720_1)


