# Load and clean 720.1 data ####

## Banks who accessed the TFF ####

accessed_tff <- tff_usage %>%
  select(institution_name, institution_code, settlement_amount, accessed_tff, drawdown_assets)

## Load in raw 720.1 data ####

df_raw_720_1 <- read_xlsx(paste0(input_path, "Raw 720.1 data.xlsx"),
                          sheet = 2) 

## Clean 720.1 data

df_720_1 <- df_raw_720_1 %>%
  mutate(totalbus_credit = pmax(ARF_720_1A__BSAO27582 + ARF_720_1A__BSAO27585 + ARF_720_1A__BSAO27612, 
                                ARF_720_1B__BSAO27582 + ARF_720_1B__BSAO27585 + ARF_720_1B__BSAO27612)) %>%
  select(period = `Reporting Period`, institution_code = `Institution Identifier`, totalbus_credit) %>%
  arrange(institution_code, period) %>%
  group_by(institution_code) %>%
  mutate(totalbus_credit_3mma = rollmean(totalbus_credit, 3, fill = NA, align = "right")) %>% 
  mutate(period = as.Date(period))

df_720_1_base <- df_720_1 %>%
  filter(period == "2020-01-31") %>%
  rename(totalbus_credit_base = totalbus_credit_3mma) %>%
  select(institution_code, totalbus_credit_base)

df_720_1 <- left_join(df_720_1, df_720_1_base, by = c("institution_code")) %>%
  left_join(bank_names, by = c("institution_code")) %>%
  mutate(totalbus_credit_growth_cum = (totalbus_credit / totalbus_credit_base) * 100 - 100) %>%
  mutate(institution_type = ifelse(is.na(institution_type), "non-ADI", "ADI")) %>%
  mutate(institution_type_dummy = ifelse(institution_type == "ADI", 1, 0))

df_720_1$totalbus_credit_growth_cum [is.na(df_720_1$totalbus_credit_growth_cum)] <- NA
df_720_1$totalbus_credit_growth_cum [is.nan(df_720_1$totalbus_credit_growth_cum)] <- NA
df_720_1$totalbus_credit_growth_cum [is.infinite(df_720_1$totalbus_credit_growth_cum)] <- NA


## Load in self-securitised assets ####

self_secs <- read_csv(paste0(input_path, "self_securitised.csv"))

self_secs <- self_secs %>%
  rename(self_sec_collateral_value = "Self sec Collateral Value", total_allowance_may20 = TFFallowance, 
         self_sec_adequacy = "Self sec adequacy", findur_code = short_name) %>%
  mutate(self_sec_dummy = ifelse(!is.na(self_sec_collateral_value), 1, 0)) %>%
  left_join(bank_names, by = c("findur_code")) %>%
  select(findur_code, self_sec_collateral_value, total_allowance_may20, 
         self_sec_adequacy, self_sec_dummy, institution_code, institution_name)

## Banks who accessed the TFF ####

# Merge datasets

business_lending_usage_ADIs <- left_join(df_720_1, accessed_tff, by = c("institution_name", "institution_code")) %>%
  mutate(time_dummy = ifelse(period >= "2020-03-31", 1, 0)) %>%
  mutate(accessed_tff_time = accessed_tff * time_dummy) %>%
  left_join(self_secs, by = c("institution_name", "institution_code", "findur_code")) %>%
  left_join(bank_names, by = c("institution_name", "institution_code", "findur_code", "institution_type")) %>% 
  left_join(tff_usage %>% 
              select(institution_code, drawdown_final_millions)) %>% 
  select(-eligible_bank.y) %>% 
  rename(eligible_bank = eligible_bank.x) %>% 
  filter(eligible_bank == 1)

business_lending_usage_ADIs$self_sec_adequacy[is.na(business_lending_usage_ADIs$self_sec_adequacy)] <- 0
business_lending_usage_ADIs$self_sec_dummy[is.na(business_lending_usage_ADIs$self_sec_dummy)] <- 0

business_lending_usage_ADIs <- business_lending_usage_ADIs %>%
  filter(period >= first_month & period <= last_month)


## Eligible institutions ####

reporting_months <- c(ceiling_date(seq(as.Date(first_month), as.Date(last_month), by = "month"), "month") - 1)

reporting_institutions_720_1 <- df_720_1 %>% 
  select(institution_code) %>% 
  unique()

required_720_1 <- expand_grid(reporting_months, reporting_institutions_720_1) 

required_720_1$reporting_months <- as.character(required_720_1$reporting_months)

required_720_1 <- required_720_1 %>% 
  unite("required", reporting_months, institution_code)

to_check_720_1 <- df_720_1 %>% 
  filter(period >= first_month & period <= last_month) %>%
  select(period, institution_code) %>% 
  unite("to_check", period, institution_code)

missing_data_720_1 <- required_720_1[!(required_720_1$required %in% to_check_720_1$to_check), ] %>%
  separate(required, c("reporting_months", "institution_code"), sep = "_") %>%
  select(institution_code) %>% 
  unique()

df_720_1_balanced <- df_720_1 %>%
  filter(!institution_code %in% missing_data_720_1$institution_code) %>%
  filter(period >= first_month & period <= last_month)
