# Load and clean 742 lending data for bank v non-bank regressions ####

## Load raw data - using 742 ####

arf742_raw <- read_excel(paste0(input_path, "arf_742_by_institution.xlsx"))

## Clean data ####

arf742 <- arf742_raw %>%
  select(reporting_period, institution_code, name, reporter_type,
         BSAO28606, BSAO28627, BSAO28643, BSAO28600) %>%
  rename(smallbus_credit = BSAO28606, 
         mediumbus_credit = BSAO28627, 
         largebus_credit = BSAO28643, 
         totalbus_credit = BSAO28600, 
         period = reporting_period,
         institution_name = name) %>%
  mutate(smallbus_credit = smallbus_credit * 1e9, 
         mediumbus_credit = mediumbus_credit * 1e9, 
         largebus_credit = largebus_credit * 1e9, 
         totalbus_credit = totalbus_credit * 1e9) %>%
  mutate(SME_credit = smallbus_credit + mediumbus_credit) %>%
  mutate(institution_type = ifelse(reporter_type == "Non-ADIs", "Non-ADI", "ADI")) %>%
  mutate(institution_type_dummy = ifelse(institution_type == "ADI", 1, 0)) %>%
  mutate(time_dummy = ifelse(period >= "2020-03-31", 1, 0)) %>%
  mutate(time_institution_dummy = time_dummy * institution_type_dummy) %>%
  mutate(period = as_date((ymd(period))))

arf742 <- arf742 %>%
  arrange(institution_code, period) %>%
  group_by(institution_code) %>%
  mutate(smallbus_credit_3mma = rollmean(smallbus_credit, 3, fill = NA, align = "right")) %>%
  mutate(mediumbus_credit_3mma = rollmean(mediumbus_credit, 3, fill = NA, align = "right")) %>%
  mutate(SME_credit_3mma = rollmean(SME_credit, 3, fill = NA, align = "right")) %>%
  mutate(largebus_credit_3mma = rollmean(largebus_credit, 3, fill = NA, align = "right")) %>%
  mutate(totalbus_credit_3mma = rollmean(totalbus_credit, 3, fill = NA, align = "right")) %>%
  ungroup()

arf742_base <- arf742 %>%
  arrange(institution_code, period) %>%
  group_by(institution_code) %>%
  mutate(smallbus_credit_base = rollmean(smallbus_credit, 3, fill = NA, align = "right")) %>%
  mutate(mediumbus_credit_base = rollmean(mediumbus_credit, 3, fill = NA, align = "right")) %>%
  mutate(SME_credit_base = rollmean(SME_credit, 3, fill = NA, align = "right")) %>%
  mutate(largebus_credit_base = rollmean(largebus_credit, 3, fill = NA, align = "right")) %>%
  mutate(totalbus_credit_base = rollmean(totalbus_credit, 3, fill = NA, align = "right")) %>%
  filter(period == "2020-01-31") %>%
  select(institution_code, smallbus_credit_base, mediumbus_credit_base, 
         SME_credit_base, largebus_credit_base, totalbus_credit_base)

arf742 <- left_join(arf742, arf742_base, by = c("institution_code"))

arf742 <- arf742 %>%
  arrange(institution_code, period) %>%
  mutate(SME_credit_growth_cum = (SME_credit / SME_credit_base) * 100 - 100) %>%
  mutate(largebus_credit_growth_cum = (largebus_credit / largebus_credit_base) * 100 - 100) %>%
  mutate(totalbus_credit_growth_cum = (totalbus_credit / totalbus_credit_base) * 100 - 100) %>%
  mutate(SME_credit_growth_cum_3mma = (SME_credit_3mma / SME_credit_base) * 100 - 100) %>%
  mutate(largebus_credit_growth_cum_3mma = (largebus_credit_3mma / largebus_credit_base) * 100 - 100) %>%
  mutate(totalbus_credit_growth_cum_3mma = (totalbus_credit_3mma / totalbus_credit_base) * 100 - 100)


## Drop outliers, drop duplicate reporters and load ad hoc

arf742 <- arf742 %>%
  filter(!(institution_code %in% c("Bank 1", "Bank 2", "Outlier 1", "Outlier 3"))) 

adhoc_credit <- business_lending_prebind %>%
  filter(adhoc_submitter == 1) %>%
  mutate(institution_type = "ADI") %>%
  mutate(institution_type_dummy = 1) %>%
  mutate(time_dummy = ifelse(period >= "2020-03-31", 1, 0)) %>%
  mutate(time_institution_dummy = time_dummy * institution_type_dummy)

ARF742_bank_non_bank <- bind_rows(arf742, adhoc_credit) %>%
  filter(period >= first_month & period <= last_month)
