# Bank v non-bank lending ####

## Pre-trends ####

pre_trends_720_1_balanced <- df_720_1_balanced %>%
  filter(!is.na(totalbus_credit_growth_cum)) %>%
  group_by(period, institution_type) %>%
  summarise(totalbus_credit_growth_cum = mean(totalbus_credit_growth_cum, na.rm = TRUE), n = n())

write_csv(pre_trends_720_1_balanced, file = paste0(output_path, "pre_trends_720_1_balanced.csv"), na = "")

write_csv(df_720_1_balanced, file = paste0(output_path, "df_720_1_balanced.csv"), na = "")

rm(pre_trends_720_1_balanced)

# Add bank characteristics

df_720_1_balanced <- left_join(df_720_1_balanced, df_bank_characteristics, 
                              by = c("institution_code", "institution_name", "findur_code", "institution_type"))

write_csv(df_720_1, file = paste0(output_path, "df_720_1.csv"), na = "")


## Run regression - Bank v non-bank lending - Total ####

cm_tablea6 <- c("institution_type_dummy" = "Bank", "(Intercept)" = "Constant")

inst_type_base <- feols(totalbus_credit_growth_cum ~ institution_type_dummy, data = df_720_1_balanced, 
                       split = "period", cluster = "institution_code", se = "cluster")

modelsummary(inst_type_base, paste0(regression_output, "Table_C13.html"), coef_map = cm_tablea6, stars = TRUE, 
             title = "Business credit growth for banks relative to non-banks", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(inst_type_base)

## Run regression - Bank v non-bank lending - just fixed-term lending ####

eligible_lenders <- fixed_lending %>% 
  select(period, institution_name, institution_code, institution_type_dummy, totalbus_credit_growth_cum, totalbus_fixed_growth_cum,
         fixed_total_base) %>% 
  unique()

eligible_lenders$institution_type_dummy[is.na(eligible_lenders$institution_type_dummy)] <- 0

inst_type_ft <-feols(totalbus_fixed_growth_cum ~ institution_type_dummy, data = eligible_lenders, split = "period", 
                     cluster = "institution_name", se = "cluster")

modelsummary(inst_type_ft, paste0(regression_output, "Table_C16.html"), stars = TRUE, 
             title = "Fixed-term business credit growth for banks relative to non-banks", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(inst_type_ft)

## Run regression - Bank v non-bank lending - just SME lending ####

institution_type_SME <- feols(SME_credit_growth_cum ~ institution_type_dummy, 
                             data = subset(ARF742_bank_non_bank, period > "2019-09-30"), 
                             split = "period", cluster = "institution_name", se = "cluster")

modelsummary(institution_type_SME, output = paste0(regression_output, "Table_C14.html"), stars = TRUE, 
             title = "SME credit growth for banks relative to non-banks", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(institution_type_SME)

## Run regression - Bank v non-bank lending - just large business lending ####

institution_type_large <- feols(largebus_credit_growth_cum ~ institution_type_dummy, 
                               data = subset(ARF742_bank_non_bank, period > "2019-09-30"), 
                               split = "period", cluster = "institution_name", se = "cluster")

modelsummary(institution_type_large, output = paste0(regression_output, "Table_C15.html"), stars = TRUE, 
             title = "Large business credit growth for banks relative to non-banks", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(institution_type_large)

## Weighted regression ####

# Bank v non-bank weighted

inst_type_weighted <- feols(totalbus_credit_growth_cum ~ institution_type_dummy, 
                            data = df_720_1_balanced, weights = df_720_1_balanced$totalbus_credit_base, 
                            split = "period", cluster = "institution_code", se = "cluster")

modelsummary(inst_type_weighted, output = paste0(regression_output, "Table_C17.html"), coef_map = cm_tablea6, stars = TRUE, 
             title = "Weighted regression - business credit growth for banks relative to non-banks", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(inst_type_weighted)

# Fixed-term bank v non-bank weighted

inst_type_fixed_term_weighted <- feols(totalbus_fixed_growth_cum ~ institution_type_dummy, 
                                      data = eligible_lenders, weight = eligible_lenders$fixed_total_base, 
                                      split = "period", cluster = "institution_name", se = "cluster")

modelsummary(inst_type_fixed_term_weighted, paste0(regression_output, "Table_C18.html"), coef_map = cm_tablea6, stars = TRUE,
             title = "Weighted regression - fixed-term business credit growth for banks relative to non-banks", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(inst_type_fixed_term_weighted)
