# Test of prior trends ####

## SME Baseline ####

data_prior_period_sme <- business_lending %>% 
  filter(period <= "2020-04-01") %>% 
  mutate(period_linear = if_else(period == "2019-10-31", 1,
                                 if_else(period == "2019-11-30", 2,
                                         if_else(period == "2019-12-31", 3,
                                                 if_else(period == "2020-01-31", 4,
                                                         if_else(period == "2020-02-29", 5,
                                                                 if_else(period == "2020-03-31", 6, 0))))))) %>% 
  mutate(bus_credit_log = log(business_credit))

feols_prior_period_sme <- feols(bus_credit_log ~ SME_borrower + period_linear + SME_borrower * period_linear, 
                                data = data_prior_period_sme) 

modelsummary(feols_prior_period_sme, output = paste0(regression_output, "/Prior_trends_SME.html"), 
               stars = TRUE, title = "Test of Prior Trends - SME Baseline Regression",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(data_prior_period_sme, feols_prior_period_sme)

## Eligible institutions ####

data_prior_period_institutions <- df_720_1_balanced %>% 
  filter(period <= "2020-04-01") %>% 
  mutate(period_linear = if_else(period == "2019-10-31", 1,
                                 if_else(period == "2019-11-30", 2,
                                         if_else(period == "2019-12-31", 3,
                                                 if_else(period == "2020-01-31", 4,
                                                         if_else(period == "2020-02-29", 5,
                                                                 if_else(period == "2020-03-31", 6, 0))))))) %>% 
  select(institution_code, period_linear, period, totalbus_credit, totalbus_credit_growth_cum, institution_type_dummy) %>% 
  mutate(bus_credit_log = log(totalbus_credit))

feols_prior_period_bank <- feols(bus_credit_log ~ institution_type_dummy + period_linear + institution_type_dummy * period_linear, 
                                 data = data_prior_period_institutions)

modelsummary(feols_prior_period_bank, output = paste0(regression_output, "/Prior_trends_bank_non_bank.html"), 
               stars = TRUE, title = "Test of Prior Trends - Bank v Non-bank Baseline Regression",
               statistic = c("t = {statistic}",
                             "se = {std.error}",
                             "conf.int"))

rm(data_prior_period_institutions, feols_prior_period_bank)

## Accessed TFF ####

data_prior_period_access <- business_lending_usage_ADIs %>% 
  filter(period <= "2020-04-01") %>% 
  mutate(period_linear = if_else(period == "2019-10-31", 1,
                                 if_else(period == "2019-11-30", 2,
                                         if_else(period == "2019-12-31", 3,
                                                 if_else(period == "2020-01-31", 4,
                                                         if_else(period == "2020-02-29", 5,
                                                                 if_else(period == "2020-03-31", 6, 0))))))) %>% 
  select(institution_code, period_linear, period, totalbus_credit, totalbus_credit_growth_cum, accessed_tff) %>% 
  mutate(bus_credit_log = log(totalbus_credit))

feols_prior_period_access <- feols(bus_credit_log ~ accessed_tff + period_linear + accessed_tff * period_linear, 
                                   data = data_prior_period_access)

modelsummary(feols_prior_period_access, output = paste0(regression_output, "/Test_prior_access_basic.html"), 
              stars = TRUE, title = "Test of Prior Trends - Accessed TFF Regression",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(data_prior_period_access, feols_prior_period_access)

