*Compares confidence intervals using diffferent BS and Binomial methods

/*
- Take series 
- do bootstrap and binomial
- report confidence intervals)
now the row is the type of confidence interval 
*/

drop _all 
use data/intermediate/FZdata_drop1.dta
*drops variables but keeps graphs
graph drop _all

qui do code/main_programs.do


*Enter the series for comparison and corresponding row names
capture drop rownames
generate rownames= "normal" if _n==1
*local row1= "normal"
replace rownames= "percentile" if _n==2
*local row2= "percentile"
replace rownames= "bc" if _n==3
*local row3= "bc"
replace rownames= "Binomial" if _n==4

gen_variables 3

local trim=2

local bvar="ln_wtp1_ar"
local tvar= "ln_wtp2_ar"

	trim_level `bvar' `tvar' `trim'

	remove_zeros_self `bvar'_T`trim' `tvar'_T`trim'

	range_bstrap `bvar'_T`trim'_Ex0 `tvar'_T`trim'_Ex0 1000 0
	binomialSE `bvar'_T`trim'_Ex0 `tvar'_T`trim'_Ex0  
	
	local temp_row=rownames[1]
	matrix meanmat=e(b)
	matrix cimat= e(ci_`temp_row')
	matrix list cimat
	bstrap2variables meanmat cimat rownames  rownames[1]
 
		local temp_row=rownames[2]
	matrix cimat= e(ci_`temp_row')
	matrix list cimat
	bstrap2variables meanmat cimat rownames  rownames[2]
	
		local temp_row=rownames[3]
	matrix cimat= e(ci_`temp_row')
	matrix list cimat
	bstrap2variables meanmat cimat rownames   rownames[3]
	
	 replace mean1=estres if rownames=="Binomial"
	 replace ll1=loCI if rownames=="Binomial"
	 replace ul1=hiCI if rownames=="Binomial"
	 
	 capture drop temp_changeFZ
	 gen temp_changeFZ=`tvar'_T`trim'_Ex0 -`bvar'_T`trim'_Ex0 
	 ci means temp_changeFZ
	 
	  replace mean2=r(mean) if rownames=="Binomial"
	 replace ll2=r(lb) if rownames=="Binomial"
	 replace ul2=r(ub) if rownames=="Binomial"
	 

	
	/*
	forvalues i = 2/3{
		matrix meanmat=e(b)
		local confidence=rownames[`i']
		di "`confidence'"
		matrix list e(ci_`confidence')
		matrix cimat=e(ci_`confidence')
		
			bstrap2variables meanmat cimat rownames  "`confidence'"
	}
	*/
	browse mean1 mean2 ll1 ul1 rownames
	
	
generate CImethod=rownames


    replace rownames = "Bootstrap (normal)" if  CImethod== "normal"
	replace rownames = "Bootstrap (bias corrected)" if  CImethod== "bc"
	replace rownames = "Bootstrap (percentile)" if  CImethod== "percentile"
	





	
	
	
	encode rownames, gen(nrownames)
	
	
	
*	twoway (rcap ll1 ul1  nrownames)  (scatter mean1 nrownames, msymbol(d)) (rcap ll2 ul2  nrownames)  (scatter mean2 nrownames, msymbol(d)) if !missing(nrownames), xlabel(1/4, valuelabel angle(v)) title(Various Confidence Interval Calculation Methods  ) name(CI_comp)
	
*	graph export output/fig_CI_comp.pdf, as(pdf) replace name(CI_comp)
	
	
	
	*	twoway (rcap ll1 ul1  nrownames)  (scatter mean1 nrownames, msymbol(d)) (rcap ll2 ul2  nrownames)  (scatter mean2 nrownames, msymbol(d)) (rcap ll3 ul3  nrownames)  (scatter mean3 nrownames, msymbol(d)) if !missing(nrownames), xlabel(1/4, valuelabel angle(v))
	
	local type="_comp"
	
	twoway    (rcap ll1 ul1  nrownames,horizontal color(gs12) msize(large)  ) (rcap ll2 ul2  nrownames, horizontal color(gs12) msize(small) )  (scatter nrownames mean1 , msymbol(d))   (scatter nrownames  mean2 , msymbol(d))  if !missing(nrownames), ylabel(1/4, valuelabel angle(h)) name(CI`type') ytitle("") xtitle("Log change")



	*lstyle(  p7boxmark )
	

	addplot CI`type':,  title("Sensitivity of Confidence Intervals") subtitle("To calculation method") legend(off) xlabel(,nogrid)  ylabel(,nogrid)
	addplot CI`type':, text( 3.7 .1 "Change in marginal buyer", color(`.__SCHEME.color.p3')) ///
	text( 2.5 .14  "95% confidence intervals", color(gs12)) ///
	text( 3.3 .18 "Change in average  (FZ method)", color(`.__SCHEME.color.p4')) 

	*legend(order(1 "Baseline (20% DP)" 2 "Relax DP to 5% min"))
	
	graph export output/fig_CI`type'.pdf, as(pdf) replace name(CI`type')
	
	
	 export excel  rownames	mean1	ll1	ul1	mean2  ll2 ul2 using "Graphs/raw/CIresults.xlsx" ,  replace  firstrow(variables)
	 
	 
		
	