*Generates main results in a table
drop _all 
use data/intermediate/FZdata_drop1.dta
*drops variables but keeps graphs
graph drop _all

qui do code/main_programs.do

local dropsuffix ="_Ex0or"

*Enter the series for comparison and corresponding row names
capture drop rownames
generate rownames= "Down payment" if _n==1
local pair1= "ln_wtp1_ar ln_wtp2_ar"

replace rownames= "Rate cut" if _n==2
*local pair2= "ln_wtp2_ar ln_wtp3_ar"
local pair2= "ln_WTPhighR_ar ln_WTPlowR_ar"

replace rownames= "Inheritance" if _n==3
local pair3= "ln_wtp3_ar ln_wtp4_ar"


local format="9.2f"


cap: file close table
file open table using "output/Table1_MainResults.tex", write replace
*file write table "\begin{tabularx}{\textwidth}{l|c|c|c}"_n"\hline "_n 
file write table " Experiment & Change in average WTP & Change in marginal WTP & Difference \\"_n"\hline" 

*local bvar="ln_wtp1_ar"
*local tvar="ln_wtp2_ar"

scalar row_counter=0
capture program drop main_table_row

program main_table_row
	args bvar tvar dpformat dropsuffix secondrow
	local trim=5
	*trim_level `bvar' `tvar' 5
	trim_level `bvar' `tvar' `trim'

	*remove_zeros_self `bvar'_T5 `tvar'_T5
	remove_zeros_multi `bvar'_T`trim' `tvar'_T`trim'
	
	
	range_bstrap `bvar'_T`trim'`dropsuffix' `tvar'_T`trim'`dropsuffix' 1000 0


*local dpformat="9.3f"


	scalar row_counter=row_counter+1


	local temp_rowname=rownames[row_counter]
	local temp_MargCentral=string(e(b)[1,1],"%`dpformat'")
	local temp_fzCentral=string(e(b)[1,2],"%`dpformat'")
	local temp_DiDCentral=string(e(b)[1,3],"%`dpformat'")

	local temp_MargLL=string(e(ci_bc)[1,1],"%`dpformat'")
	local temp_fzLL=string(e(ci_bc)[1,2],"%`dpformat'")
	local temp_DiDLL=string(e(ci_bc)[1,3],"%`dpformat'")

	local temp_MargUL=string(e(ci_bc)[2,1],"%`dpformat'")
	local temp_fzUL=string(e(ci_bc)[2,2],"%`dpformat'")
	local temp_DiDUL=string(e(ci_bc)[2,3],"%`dpformat'")
	di `temp_DiDUL'
	di "`temp_rowname'"

matrix list e(ci_bc)

	file write table _n "  `temp_rowname' & `temp_fzCentral'& `temp_MargCentral'  & `temp_DiDCentral' \\" 
	 file write table _n " `secondrow'  & (`temp_fzLL'  -- `temp_fzUL') & (`temp_MargLL'   -- `temp_MargUL')& (`temp_DiDLL' -- `temp_DiDUL')\\"_n"\hline"
	
	
	*if `temp_rowname'== "Down payment"{ 
	*   file write table _n " reduction  & (`temp_fzLL'  -- `temp_fzUL') & (`temp_MargLL'   -- `temp_MargUL')& (`temp_DiDLL' -- `temp_DiDUL')\\"_n"\hline"
    
	*}
		
* di `temp_rowname'
end

*main_table_row ln_wtp1_ar ln_wtp2_ar `format'
main_table_row `pair1' `format' `dropsuffix' "reduction"
main_table_row  `pair2' `format' `dropsuffix'
main_table_row `pair3'  `format' `dropsuffix'



*file write table _n "\end{tabularx}" 
file close table


