clear all

use data/intermediate/FZdata_drop1.dta

*1. Calculate means for DP stuff

*Constructing trims of top and bottom 5, which seem to be FZ's preferred/quoted number




 fsum  hypo_q2_q1_logchg hypo_q2_q1_logchg_T5  hypo_q2_q1_logchg_R hypo_q2_q1_logchg_R_T5   hypo_q2_q1_logchg_O hypo_q2_q1_logchg_O_T5 , stats( mean se  lci uci n ) uselabel
 
 fsum hypo_logchange_rateup hypo_logchange_rateup_T5   hypo_logchange_rateup_R hypo_logchange_rateup_R_T5  hypo_logchange_rateup_O hypo_logchange_rateup_O_T5  , stats( mean se  lci uci n ) uselabel
 
 fsum hypo_logchange_inher hypo_logchange_inher_T5   hypo_logchange_inher_R hypo_logchange_inher_R_T5   hypo_logchange_inher_O hypo_logchange_inher_O_T5, stats( mean se  lci uci n ) uselabel


*2. Plots of all the trim values showing skew. (Graphs need formatting)
set graphics off
 trimplot hypo_q2_q1_logchg ,over(renter) percent   legend(position(1) ring(0) cols(1)) connect(l) msymbol(none) name(PlogQ1Q2_trim_R) 
 
trimplot hypo_q2_q1_logchg , percent connect(l) msymbol(none) name(PlogQ1Q2_trim)

trimplot hypo_logchange_rateup ,over(renter) percent   legend(position(1) ring(0) cols(1)) connect(l) msymbol(none) name(PlogRateup_trim_R) 
trimplot hypo_logchange_rateup , percent connect(l) msymbol(none) name(PlogRateup_trim)

trimplot hypo_logchange_inher ,over(renter) percent   legend(position(1) ring(0) cols(1)) connect(l) msymbol(none) name(PlogInher_trim_R) 
trimplot hypo_logchange_inher , percent connect(l) msymbol(none) name(PlogInher_trim)

set graphics on
graph combine PlogRateup_trim PlogRateup_trim_R, ycommon name(PtrimbothRateup)
graph combine PlogInher_trim PlogInher_trim_R, ycommon name(PtrimbothInher)
graph combine PlogQ1Q2_trim PlogQ1Q2_trim_R, ycommon name(PtrimbothDP)


*graph close PlogQ1Q2_trim_R PlogQ1Q2_trim PlogRateup_trim PlogRateup_trim_R PlogInher_trim_R PlogInher_trim



graph export output/fig_PtrimbothRateup.pdf, as(pdf) replace name(PtrimbothRateup)
graph export output/fig_PtrimbothInher.pdf, as(pdf) replace name(PtrimbothInher)
graph export output/fig_PtrimbothDP.pdf, as(pdf) replace name(PtrimbothDP)





/* Offcuts
qui trimmean  hypo_q2_q1_logchg , percent(5) generate(trim5_DP)
qui trimmean  hypo_logchange_rateup , percent(5) generate(trim5_rate)
qui trimmean  hypo_logchange_inher , percent(5) generate(trim5_inher)

generate hypo_q2_q1_logchg_T5=hypo_q2_q1_logchg if trim5_DP==1
generate hypo_logchange_rateup_T5=hypo_logchange_rateup if trim5_rate==1
generate hypo_logchange_inher_T5=hypo_logchange_inher if trim5_inher==1


*table  tenure_concalc if winsorized25==0, contents(  mean hypo_q2_q1_logchg semean hypo_q2_q1_logchg    freq   )center format(%9.2f)
*tabstat hypo_q2_q1_logchg hypo_q2_q1_logchg_T5 hypo_logchange_rateup hypo_logchange_rateup_T5 hypo_logchange_inher hypo_logchange_inher_T5, stat(mean semean n) longstub labelwidth(32) varwidth(20) columns(statistics)

*/

