

*set directory to file location e.g. 
cd "C:\User\RDP_Replication\"

*************** 2003/04 *************** 


*NO OFFSET ACCOUNTS

use "SIH03BH.dta" , clear

rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 

rename WKRENTCH rent_weekly
rename STATEHBC state


g dinc = DISPCH 
g dinc_prev = DISPPH

g year = 2003

g children = NUMU15BC
g persons = PERSHBC
g adults = persons - children

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)

g tenure = TENURECF 
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30


*Wealth variables - to define HtM

g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VTRTCH


g dep = VFINCH
g off = 0
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH

g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g car = VVEHICH 

keep state rent_weekly ABSHID hwt year ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone INCTOTCH
save "liq2003.dta", replace




******************* 2005/06 ******************* 


*NO OFFSET ACCOUNTS

use Sih05bh.dta , clear


rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 
rename WKRENTCH rent_weekly
rename STATEHBC state

g year = 2005

g dinc = DISPCH
g dinc_prev = DISPPH

g adults = NOMEMHBC
g children = NUMU15BC + NONDEPBC

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)


g tenure = TENURECF
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 15 if agehh == 1
replace age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30


*Wealth variables - to define HtM

g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VTRTCH


g dep = VFINCH
g off = 0
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH

g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g car = VVEHICH 

keep state rent_weekly ABSHID hwt year ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone INCTOTCH
save "liq2005.dta", replace




******************* 2009/10 ******************* 


*NO OFFSET ACCOUNTS

use sih10bh.dta , clear


rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 
rename WKRENTCH rent_weekly
rename STATEHBC state

g year = 2009
g dinc = DISPSCH8
g dinc_prev = DISPPH8

g tenure = TENURECF

g adults = NOMEMHBC
g children = NUMU15BC + NONDEPBC

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)


g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 15 if agehh == 1
replace age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30

*Wealth variables - to define HtM

g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VPUTCH+VPRTCH+VSIPCH


g dep = VFINCH
g off = 0
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH

g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 


g car = VVEHICH 


keep state rent_weekly ABSHID hwt year ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone INCTSCH8
save "liq2009.dta", replace






******************* 2011/12 ******************* 
use sih11bh.dta , clear

rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 
rename WKRENTCH rent_weekly
rename STATEHBC state

g tenure = TENURECF

g year = 2011
g dinc = DISPSCH8
g dinc_prev = DISPPH8


g adults = NOMEMHBC
g children = NUMU15BC + NONDEPBC

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)



g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 15 if agehh == 1
replace age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30


*Wealth variables - to define HtM

g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VPUTCH+VPRTCH+VSIPCH


g dep = VFINCH
g off = VOFTCH
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH


g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 


g car = VVEHICH 

keep state rent_weekly ABSHID hwt year ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone INCTSCH8
save "liq2011.dta", replace




******************* 2013/14 ******************* 

use sih13bh.dta , clear

rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 
rename WKRENTCH rent_weekly
rename STATEHBC state

g year = 2013
g dinc = DISPSCH8
g dinc_prev = DISPPH8

g tenure = TENURECF

g adults = NOMEMHBC
g children = NUMU15BC + NONDEPBC

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)



g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 15 if agehh == 1
replace age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30


*Wealth variables - to define HtM

g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VPUTCH+VPRTCH+VSIPCH


g dep = VFINCH
g off = VOFTCH
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH


g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g car = VVEHICH 


keep state rent_weekly ABSHID hwt year ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone INCTSCH8 
save "liq2013.dta", replace


*What about business and personal debt? And other assets?



******************* 2015/16 ******************* 

use sih15bh.dta , clear

rename sihhhwt hwt
rename agerhec age
rename wealthh nwealth 
rename isuperch superinc 
rename lfsrh lfstatus 
rename wkrentch rent_weekly
rename statehec state

g year = 2015
g dinc = dispsch8 
g dinc_prev = dispph8 

g adults = nomemhbc 
g persons = pershbc
g children = persons-adults


rename dcomp DCOMP 
g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)



g tenure = tenurecf 
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (fsthhcf == 1)

*Wealth variables - to define HtM

g hvalue = hvaluech 
g otherprop = vrprch  
g resassets = hvalue+otherprop

g gsuper = vsupgch 
g psuper = vsupnch  
g super = gsuper+psuper

g trusts = vputch+vprtch+vsipch  


g dep = vfinch  
g off = voftch 
g bank = dep+off

g bonds = vdebch  
g shares = vsharch  

g liqassets = bank + shares + bonds 


g hdebt_purch = towe1ch 
g hdebt_alts = towe2ch  
g hdebt_other = towe3ach
g hdebt_unsec = towe4ch 

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = liaccch 
g pdebt = liavech+liainvch+liaotch 


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 


g liqnw = liqassets - liq_debt

g car = vvehich  

rename inctsch8 INCTSCH8
rename abshid ABSHID 
keep state rent_weekly ABSHID hwt year ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone INCTSCH8
save "liq2015.dta", replace


******************* 2017/18 ******************* 

use "\SIH17BP.dta" , clear 

keep abshid supbalp supbalnp vsuptot
rename abshid ABSHID 
rename vsuptot super 
*Balance of super paying regular income
rename supbalp super_reginc
*Balance of super paying no regular income
rename supbalnp super_noreginc

collapse(sum) super*, by(ABSHID)
save "supertemp.dta", replace


use sih17bh.dta , clear

rename sihhhwt hwt
rename agerhec age
rename wealthh nwealth 

rename isuperch superinc 
rename lfsrh lfstatus 

g year = 2017
g dinc = dispsch8 
*g dinc_prev = dispph8 

g tenure = tenurecf 
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (fsthhcf == 1)

g adults = nomemhbc 
g persons = pershbc
g children = persons-adults

rename dcomp DCOMP 
g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)


*Wealth variables - to define HtM

g hvalue = hvaluech
g otherprop = vrprch
g resassets = hvalue+otherprop

*They seem to have left out the super wealth data (VSUP)

g trusts = vputch+vprtch+vsipch 

*Includes offset accounts (but not redraw)
g dep = vfinch  
g off = voftch
g bank = dep+off

g bonds = vdebch 
g shares = vsharch 

g liqassets = bank + shares + bonds 


g hdebt_purch = towe1ch 
g hdebt_alts = towe2ch 
*g hdebt_other = towe3ch 
g hdebt_other = towe3ach
g hdebt_unsec = towe4ch 

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = liaccch 
g pdebt = liavech+liainvch+liaotch 


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g liqnw = liqassets - liq_debt

g car = vvehich 

*Merge in super data 
rename abshid ABSHID
merge 1:1 ABSHID using "supertemp.dta", nogen keep(match master)

*Have to manually merge in super 

*ASSETS = bank deposits + offset + shares + trusts + silent partner + bonds + incorp business + super + loans to persons not in HH + other fin invest + home dwelling + other res + non-res + unincorp business + contents + car + nec assets 

g assets = vfinch + voftch + vsharch + vtottch + vsipch + vdebch + vibusch + vplnch + vinvotch + hvaluech  + vrprch + vnrprch + vubusch + vcontch + vvehich + votassch + super 

*DEBTS = loans for selected dwelling + loans for other property +rental property loans + car loans + investment loans + other loans 

g debts = liasdch + liaopch + liarpch + liavech + liainvch + liaotch + liahecch + liasfsch + liaccch 

*CHECKS OUT!
g nworth = assets-debts
su nw*
rename wkrentch rent_weekly
rename statehec state

generate INCTSCH8=inctsch8

keep state rent_weekly ABSHID hwt year ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone assets debts INCTSCH8

save "liq2017.dta", replace





********2019/20

use "SIH19BP.dta" , clear 

 keep ABSHID SUPBALP  SUPBALNP VSUPTOT
*rename abshid ABSHID 
rename VSUPTOT super 
*Balance of super paying regular income
rename SUPBALP super_reginc
*Balance of super paying no regular income
rename SUPBALNP super_noreginc

collapse(sum) super*, by(ABSHID)
save "supertemp19.dta", replace



use sih19bh.dta , clear

rename  	SIHHHWT hwt
rename AGERHEC  age
rename WEALTHH  nwealth 

rename ISUPERCH superinc 
rename  LFSRH lfstatus 

g year = 2019
g dinc =   DISPSCH8
*g dinc_prev = dispph8 

g tenure =  TENURECF
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)

g adults =   NOMEMHBC
g persons =  PERSHBC
g children = persons-adults


g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)


*Wealth variables - to define HtM

g hvalue =  HVALUECH
g otherprop =  VRPRCH
g resassets = hvalue+otherprop

*They seem to have left out the super wealth data (VSUP)


g trusts = VPUTCH + VPRTCH + VSIPCH

*Includes offset accounts (but not redraw)
g dep =   VFINCH
g off =  VOFTCH
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH 

g liqassets = bank + shares + bonds 


g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH 
*g hdebt_other = towe3ch 
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH 

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH

g pdebt = LIAVECH+LIAINVCH+LIAOTCH

g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g liqnw = liqassets - liq_debt

g car = VVEHICH 

*Merge in super data 
*rename abshid ABSHID
merge 1:1 ABSHID using "supertemp19.dta", nogen keep(match master)

*Have to manually merge in super 


rename  WKRENTCH rent_weekly
rename  STATEHEC state


keep state rent_weekly ABSHID hwt year ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone   INCTSCH8

save "liq2019.dta", replace











************** APPENDING DATASETS ************** 

clear
append using "liq2003.dta"
append using "liq2005.dta"
append using "liq2009.dta"
append using "liq2011.dta"
append using "liq2013.dta"
append using "liq2015.dta"
append using "liq2017.dta"
append using "liq2019.dta"

save "liq_2003_2019.dta", replace


/*

10. Assets	
	101. Value of accounts held with financial institutions (excl offset accounts)
	102. Value of shares (excl own incorporated business)
	103. Value of public unit trust
	104. Value of private trusts
	105. Value of silent partnerships
	106. Value of debentures and bonds
	107. Value of own incorporated business (net of liabilities)
	108. Balance of all superannuation accounts
	110. Value of loans to persons not in the same household
	111. Value of children's assets (no longer available)
	112. Value of other financial investments
	113. Value of owner occupied dwelling
	114. Value of residential property excl selected dwelling
	115. Value of non-residential property
	116. Value of own unincorporated business (net of liabilities)
	117. Value of contents of dwelling
	118. Value of vehicles
	119. Value of offset accounts
	120. Value of assets nec

	20. Liabilities	
	201. Principal outstanding on loans for owner occupied dwelling
	202. Principal outstanding on loans for other property (excl business and investment loans)
	203. Principal outstanding on rental property loans
	204. Amount of HECS liability
	205. Amount of Student Financial Supplement liability
	206. Amount owing on credit cards
	207. Principal outstanding on loans for vehicle purchases (excl business and investment loans)
	208. Principal outstanding on investment loans (excl business and rental property loans)
	209. Principal outstanding on loans for other purposes (excl business and investment loans)

	