* Code takes household surveys from different countries and transforms into the same variables:
* IVS_relcalc_eq IVS_relcalc_eq_net  age age2 age3   IVS_relinc owner  


cd ""
qui do code/programsFZ.do



*********************************************************
*Swiss data
*I:\HES\TomC\FZ_project\data\raw\Swiss\Data_STATA\SHP-Data-W1-W21-STATA\W15_2013

*data file shp13_h_user.dta
*i13htyn yearly HH income net
* h13h37 total monthly expenses for accom renters and owners
* h13h29 tenant or owner

*2012 
*

use "shp12_h_user.dta", clear

*


gen idhous = idhous12
*rename idhous12 idhous
recast double idhous
 
*codebook   idhous idhous12 h12h29	h12i111d	i12dispy	h12h36	h12h37	h12i110a	h12i111a	i12htyg	h12i111c
keep   idhous idhous12  h12h29  i12htyn h12h36

codebook idhous

merge 1:1 idhous using "imputed_wealth_hh_2012_2016.dta", keepusing(wealth12hi wealth12oti ) 

drop if missing(idhous12)
rename _merge _merge1
merge 1:m idhous12 using "shp12_p_user.dta", keepusing(age12 relarp12 idpers ) 
keep if relarp12==1

scalar rental_yield=4.2
gen owner = 0 if h12h29  ==1
replace owner=1 if h12h29==2
gen rent_monthly=h12h36
gen income= i12htyn

gen available_equity= wealth12hi +wealth12oti 

gen home_value=rent_monthly*12/(rental_yield/100) if owner==0
replace home_value=wealth12hi if owner==1

gen rel_equity=available_equity/home_value
gen relinc=income/home_value
drop if home_value<=0

gen IVS_relcalc_eq   =asinh(100*rel_equity)
  gen IVS_relinc=asinh(100*relinc)

  
gen age=age12
gen age2=age^2
gen age3=age^3



save data/intermediate/SWI12.dta, replace

********************************************************
*Spanish data 

use data/raw/other_sections_2014_imp1.dta,clear

*p1_2d_1 reference person age
*p2_1 ownership status of main residence
* p2_5 current value of your home
*p2_12_1 + p2_12_2 + p2_12_3 + p2_12_4 is total mortgage unpaid

* p2_8 current payments outstanfing on your home

*p2_31 current rent monthly payment 


* p4_15 market value of shares
* p4_28a total value of mutual fund portfolio
*p4_35 value of fixed-income sercurities
*p4_43 other assets (looks like a  mop-up for liquidish assets)

scalar rental_yield=6

recode p2_12_1  p2_12_2  p2_12_3  p2_12_4 p4_15 p4_28a p4_35 p4_43 (missing = 0) , prefix(new_)


generate house_debt=new_p2_12_1 + new_p2_12_2 + new_p2_12_3 + new_p2_12_4

generate owner=p2_1-1

generate home_value= p2_31*12/(rental_yield/100) if owner==0
replace home_value= p2_5 if owner==1

generate liquid_savings=  new_p4_15 + new_p4_28a +new_p4_35 +new_p4_43
generate equity_available=liquid_savings+home_value*owner-house_debt

generate rel_equity=equity_available/home_value
generate IVS_relcalc_eq=asinh(100*rel_equity)

generate age=p1_2d_1
generate age2=age^2
generate age3=age^3

keep if owner==1|owner==0
keep h_2014 IVS_relcalc_eq rel_equity home_value owner age age2 age3 liquid_savings house_debt new_p2_12_1  new_p2_12_2  new_p2_12_3  new_p2_12_4  new_p4_15  new_p4_28a new_p4_35 new_p4_43
sort h_2014


 


merge using data/raw/databol1.dta, keep(h_2014 renthog13_eur14)

generate relinc=renthog13_eur14/home_value

generate IVS_relinc=asinh(100*relinc)


save data/intermediate/ESP14.dta, replace





*********************************************************************************
*FZ data 

use data/intermediate/FZdata_drop1.dta,clear

local bvar="ln_wtp1_ar"
local tvar="ln_wtp2_ar"
local trim=5

trim_level `bvar' `tvar' `trim'

*drop if missing(`bvar'_T`trim')


generate housingdebtstatus =0 if house_debt<= liquid_savings & owner==1
replace  housingdebtstatus = 1 if house_debt> liquid_savings & owner==1
replace housingdebtstatus=2 if renter==1


* FZ style regressions and fitted values
gen age2=age^2
gen age3=age^3



gen calc_equity=equity_value*1000+liquid_savings
gen calc_equity_net=equity_value*1000+liquid_savings-non_house_debt

gen relcalc_eq=calc_equity/homevalue
gen relcalc_eq_net=calc_equity_net/homevalue

gen IVS_relcalc_eq=asinh(100*relcalc_eq)
gen IVS_relcalc_eq_net=asinh(100*relcalc_eq_net)


gen IVS_calc_eq=asinh(100*calc_equity)
gen IVS_inc=asinh(100*inc_cont)
gen relinc=(inc_cont/homevalue)
gen IVS_relinc=asinh(100*inc_cont/homevalue)


gen pos_eq=0
replace pos_eq=1 if calc_equity>0

save data/intermediate/SCE13.dta, replace



****************************************************************************************
*SCF data in 2013/2019 NB need to delete implicates


		
foreach file in 04 13 19  {
               use "data/raw/rscfp20`file'.dta",clear 
			   *}

	*	use data/raw/rscfp2013.dta,clear

	collapse liq nmmf  stocks homeeq houses debt housecl age rent networth income, by(yy1)
	
		gen age2=age^2
		gen age3=age^3

		scalar rental_yield=4.0
		 
	
		 
		 generate calc_available=liq+nmmf+ stocks+homeeq
		  
		 generate calc_available_net=liq+nmmf+ stocks+houses-debt 
		 *net of all debt
		  
		 generate rental_housevalue=(12*rent)/(rental_yield/100) if housecl==2
		 
		 generate home_value=houses if  housecl==1
		 replace home_value=rental_housevalue if  housecl==2
		 
		* hist home_value if home_value<2000000 , by(housecl)
		 
		 generate relcalc_eq=calc_available/home_value
		 generate relcalc_eq_net=calc_available_net/home_value
		 *hist  relcalc_eq if rel_equity<2 & rel_equity>-.2,by(housecl) percent
		  
		 gen IVS_relcalc_eq=asinh(100*relcalc_eq)
		 gen IVS_relcalc_eq_net=asinh(100*relcalc_eq_net)

		gen relinc=income/home_value
		gen IVS_relinc=asinh(100*income/home_value)
		 
		 gen rel_networth=networth/home_value
		 
		 generate owner=-(housecl-2)
		  
		 
		 drop if home_value<0
		 
		 keep IVS_relcalc_eq IVS_relcalc_eq_net  age age2 age3   IVS_relinc owner 
		 
		 save "data/intermediate/SCF`file'.dta", replace
		 
		 }