*Generates main results in a table
drop _all 
use data/intermediate/FZdata_drop1.dta
*drops variables but keeps graphs
graph drop _all

qui do code/main_programs.do

capture program drop trim_boot
program trim_boot
	args bvar tvar trim_percentage
	
	trim_level `bvar' `tvar' `trim_percentage'
	remove_zeros_self `bvar'_T`trim_percentage' `tvar'_T`trim_percentage'
	margchangeBS `bvar'_T`trim_percentage'_Ex0 `tvar'_T`trim_percentage'_Ex0 0
	
	
end

capture program drop range_trim_bstrap
program range_trim_bstrap, rclass
	args bvar tvar  reps trim_percentage 
		preserve
		keep  if !missing(`bvar')| !missing(`tvar')
		bootstrap r(marg_change) r(FZchange) r(FZlessMarg), dots(0) nowarn reps(`reps'): trim_boot `bvar' `tvar' `trim_percentage'
		restore
		
end


  
local bvar="ln_wtp3_ar"
local tvar="ln_wtp4_ar"

gen_variables 3

gen mean1_zero_trim=.
gen mean2_zero_trim=.

remove_zeros_self `bvar' `tvar'

gen trim_depth=.
local counter=1
foreach i in 0 2 5 10  20 30 40 45  {
*forvalues i=0/45 {
	
replace trim_depth=`i' if `counter'==_n

			trim_level_complex `bvar'_Ex0 `tvar'_Ex0 `i' `bvar' `tvar'
				range_bstrap `bvar'_Ex0_T`i' `tvar'_Ex0_T`i' 100 0
				
			matrix meanmat=e(b)
			matrix cimat=e(ci_bc)
			
				bstrap2variables meanmat cimat trim_depth  `i'
				replace mean1_zero_trim=mean1 if trim_depth==`i'
				replace mean2_zero_trim=mean2 if trim_depth==`i'
				
			
			range_trim_bstrap `bvar' `tvar' 1000 `i'
			
			*estat bootstrap, all
			matrix meanmat=e(b)
			matrix cimat=e(ci_bc)
		*	matrix cimat=e(ci_percentile)
	
			/*
			           forvalues j=1/3{
                             replace mean`j'=meanmat[1,`j'] if trim_depth==`i'
						   *  replace mean`j'=meanmat[1,`j'] if `counter'==_n
                              replace ll`j'=cimat[1,`j'] if trim_depth==`i'
                                replace ul`j'=cimat[2,`j'] if trim_depth==`i'
                                }
								*/
								
								bstrap2variables meanmat cimat trim_depth  `i'
			
			
			
			
			local counter=`counter'+1

}



*twoway (rcap ll1 ul1  trim_depth1)  (scatter mean1 trim_depth1, msymbol(d)) (rcap ll2 ul2  trim_depth2)  (scatter mean2 trim_depth2, msymbol(d)) if !missing(trim_depth)

/*  inside  bootstrap procedure
- resample
- trim
- remove zeros
-calculate marg

*/
set graphics on

twoway(rarea ll1 ul1 trim_depth,fcolor(gs14)  lwidth(none)) (rarea ll2 ul2 trim_depth,color(gs12%80) lwidth(none)) (connected mean2 trim_depth, msymbol(none)) (connected mean1 trim_depth, msymbol(none)), title("Comparison of trim depths across methods") name(trim_comp)

addplot  trim_comp: , ytitle("Log change in WTP") legend(order(4 "Marginal buyer" 3 "Mean WTP" ))

twoway(rarea ll1 ul1 trim_depth,fcolor(gs14)  lwidth(none)) (rarea ll2 ul2 trim_depth,color(gs12%80) lwidth(none)) (connected mean2 trim_depth, msymbol(none)) (connected mean1 trim_depth, msymbol(none)) (connected mean1_zero_trim trim_depth, msymbol(none)) (connected mean2_zero_trim trim_depth, msymbol(none)) , name(g2)

twoway(rarea ll1 ul1 trim_depth,fcolor(gs14)  lwidth(none)) (connected mean1 trim_depth, msymbol(none)) (connected mean1_zero_trim trim_depth, msymbol(none)),name(g3)


twoway(rarea ll2 ul2 trim_depth,fcolor(gs14)  lwidth(none)) (connected mean2 trim_depth, msymbol(none)) (connected mean2_zero_trim trim_depth, msymbol(none)),name(g4)


graph export output/fig_trim_compI.pdf, as(pdf) replace name(trim_comp)

export excel trim_depth  mean1 ll1 ul1 trim_depth  mean2 ll2 ul2  using "Graphs/raw/Trim_Inher.xlsx" ,  replace  firstrow(variables)