*clear all


qui do code/main_programs.do

do code/set_scalar_params.do
*scalar rate=rateLow
local phigrid=30
local betagrid=30

local phistart=-.5
local phiend=1
local phiincrement=(`phiend'-`phistart')/(`phigrid'-1)

local betastart=.5
local betaend=1
*-rate*(1-margtax)
local betaincrement=(`betaend'-`betastart')/(`betagrid'-1)
local gridsize=`phigrid'*`betagrid'

if `gridsize' > `=_N' {
	set obs `gridsize'
}

capture drop  beta_contour
capture drop   phi_contour

gen beta_contour=.
gen phi_contour=.

capture drop hypo_first_ratecopy
gen  hypo_first_ratecopy=hypo_first_rate
replace hypo_first_rate=rate*100

local obscounter=1

forvalue bcounter=1/`betagrid'{
   
		forvalue pcounter=1/`phigrid'{
		    replace beta_contour= `betastart'+(`bcounter'-1)*`betaincrement' if _n==`obscounter'
		    replace phi_contour= `phistart'+ (`pcounter'-1)*`phiincrement' if _n==`obscounter'
			local obscounter=`obscounter'+1
		}
		    
				
}


capture drop  rho_contour
gen rho_contour=1/beta_contour-1

capture drop  WTP1_fit_contour 
capture drop WTP2_fit_contour 
capture drop  ln_WTP1_fit_contour 
capture drop ln_WTP2_fit_contour 

local suffix="contour"
	genWTP rho_`suffix' phi_`suffix' 2 `suffix'
	genWTP rho_`suffix' phi_`suffix' 1 `suffix'
	

capture drop dlogfit21_`suffix'	
gen dlogfit21_`suffix'=ln_WTP2_fit_`suffix'-ln_WTP1_fit_`suffix'


replace hypo_first_rate=hypo_first_ratecopy
	

	*clegend(off)
	*twoway (contour WTP1_fit_contour  phi_contour beta_contour , levels(15) zlabel(#5) xtitle("")), name(level)
*twoway (contour WTP1_fit_contour   beta_contour phi_contour , levels(15) zlabel(#5) xtitle("")), name(levelcheck)
	
	*(scatter beta_contour phi_contour,msize(vtiny))
	*twoway contour dlogfit21_contour beta_contour phi_contour,name(change)
	
	*twoway connected  dlogfit21_contour beta_contour,sort msymbol(none) legend(on) legend(position(3) lab(1 "Change") stack) name(connbeta)
	*twoway connected   beta_contour dlogfit21_contour,sort msymbol(none)  name(connbeta)
	
	*graph combine level connbeta,cols(1) name(com1) xcommon ysize(15cm)  xsize(10cm)
	*graph combine  connbeta level,cols(2) name(com2) ysize(10cm)  xsize(20cm)
	
	
	