*Compares different ways of dealing with WTP=appraisal vals


drop _all 
use data/intermediate/FZdata_drop1.dta
*drops variables but keeps graphs
graph drop _all

qui do code/main_programs.do

local bvar="ln_WTPhighR_ar"
local tvar="ln_WTPlowR_ar"
local type = "R"


local trim=5

gen_variables 3

trim_level `bvar' `tvar' `trim'

remove_zeros_multi `bvar'_T`trim' `tvar'_T`trim'

gen rownumber=_n
gen rownames= "initialise" if _n==1
local rowlocal=0

gen maxmarg=.
gen minmarg=.
*stop 
*marker

set graphics off
foreach suffix in "" "_Ex0" "_Ex0or" "_Ex0and" "_Ex0all"{
	local rowlocal=`rowlocal'+1
qui 	replace rownames= "`suffix'" if _n==`rowlocal'
	
	

	qui margchangeBS `bvar'_T`trim'`suffix' `tvar'_T`trim'`suffix' 0
	di "`suffix""'
	return list
	replace maxmarg=r(marg_changeMax) if rownumber ==`rowlocal'
	replace minmarg=r(marg_changeMin) if rownumber ==`rowlocal'
		qui  range_bstrap `bvar'_T`trim'`suffix' `tvar'_T`trim'`suffix' 1000 0
		
		matrix meanmat=e(b)
		matrix cimat=e(ci_normal)
		
		qui bstrap2variables meanmat cimat rownumber `rowlocal'
		CDFgraph  `bvar'_T`trim'`suffix' `tvar'_T`trim'`suffix' .2  -.1 gR`suffix'
	
	
	
	
}
set graphics on
browse mean1 mean2 mean3 ll1 ll2 rownames rownumber


replace rownames="No exclusion" if rownumber==1

generate dropsuffix=rownames


    replace rownames = "By WTP" if  dropsuffix== "_Ex0"
	replace rownames = "Both WTPs " if  dropsuffix== "_Ex0and"
	replace rownames = "Either WTP " if  dropsuffix== "_Ex0or"
	replace rownames = "All four WTPs" if  dropsuffix== "_Ex0all"




encode rownames, gen(nrownames)




*	twoway (scatter minmarg nrownames, msymbol(d))   (scatter maxmarg nrownames, msymbol(d)) (rcap ll1 ul1  nrownames)  (scatter mean1 nrownames, msymbol(d)) (rcap ll2 ul2  nrownames)  (scatter mean2 nrownames, msymbol(d))  if !missing(nrownames), xlabel(1/5, valuelabel angle(h)) name(zero_compInher) ytitle("")

*twoway    (rcap ll1 ul1  nrownames,color(gs12) msize(large) ) (rcap ll2 ul2  nrownames,color(gs12) msize(small))  (scatter mean1 nrownames, msymbol(d))   (scatter mean2 nrownames, msymbol(d))  if !missing(nrownames), xlabel(1/5, valuelabel angle(h)) name(zero_compInher) xtitle("WTP=Appraisal exclusion criteria") ytitle("Log change")

local type="R"
twoway    (rcap ll1 ul1  nrownames,horizontal color(gs12) msize(large)  ) (rcap ll2 ul2  nrownames, horizontal color(gs12) msize(small) )  (scatter nrownames mean1 , msize(large) msymbol(d))   (scatter nrownames  mean2 , msymbol(d))  if !missing(nrownames), ylabel(1/5, valuelabel angle(h)) name(zero_comp`type') ytitle("WTP=Appraisal exclusion criteria") xtitle("Log change")



	*lstyle(  p7boxmark )
	

	addplot zero_comp`type':,  title("Sensitivity of Mortgage Rate Effect") subtitle("To differing exclusions of WTP = appraisal value") legend(off) xlabel(,nogrid)  ylabel(,nogrid)
	addplot zero_comp`type':, text( 4.7 0 "Change in marginal buyer", color(`.__SCHEME.color.p3')) ///
	text( 2.5 .04  "95% confidence intervals", color(gs12)) ///
	text( 4.3 .05 "Change in average  (FZ method)", color(`.__SCHEME.color.p4')) 

	*legend(order(1 "Baseline (20% DP)" 2 "Relax DP to 5% min"))
	
	graph export output/fig_zero_comp`type'.pdf, as(pdf) replace name(zero_comp`type')
	
	
export excel   mean1 ll1 ul1   mean2 ll2 ul2  using "Graphs/raw/Exclusion_Rates.xlsx" ,  replace  firstrow(variables)
	