clear all

use  "liq_2003_2019.dta", clear


merge n:1 state year using "\data\intermediate\yields_long.dta", keep(master match)

generate home_value=hvalue if owner==1

generate rent_annual=rent_weekly/7*365

replace home_value =rent_annual/(rental_yield) if renter==1


generate rel_equity=( bank + shares + bonds+home_value*owner+otherprop*0.8-resdebt)/home_value

generate rel_equityW=(nwealth-super-car-trust)/home_value

replace rel_equity = rel_equityW

gen income= INCTSCH8/7*365
replace income = INCTOTCH/7*365 if missing(INCTSCH8)

generate relinc=income/home_value

* Clean up outliers
drop if owner==1 & hvalue<1000
drop if renter==0 & owner==0
drop if relinc>3

*drop if owner==0 & rent_weekly/7*365<.1*income


generate IVS_relcalc_eq=asinh(100*rel_equityW)
generate IVS_relinc=asinh(100*relinc)
keep if owner==1|renter==1

save "SIH_panelW.dta", replace

graph drop _all
preserve
*collapse owner age rel_equity home_value relinc, by(year)

collapse (mean)  age rel_equityW home_value relinc ///
(median)    med_rel_equityW= rel_equityW  med_home_value=home_value  med_relinc =relinc ///
 (p20) p20_rel_equityW=rel_equityW  p20_home_value=home_value  p20_relinc =relinc ///
(p80) p80_rel_equityW=rel_equityW p80_home_value=home_value  p80_relinc =relinc ///
 , by(year owner)
twoway (scatter rel_equityW year ) (scatter med_rel_equityW year) (scatter p20_rel_equityW year) (scatter p80_rel_equityW year), by(owner) name(releq)

twoway (scatter home_value year ) (scatter med_home_value year) (scatter p20_home_value year) (scatter p80_home_value year), by(owner) name(hv) 

twoway (scatter relinc year ) (scatter med_relinc year) (scatter p20_relinc year) (scatter p80_relinc year), by(owner) name(relinc)


sort  owner year

outsheet * using "FZ_project\output\outputTenure.csv" , comma replace 

restore 

preserve
*collapse owner age rel_equity home_value relinc, by(year)

collapse (mean) owner  age rel_equityW home_value relinc ///
(median)    med_rel_equityW= rel_equityW  med_home_value=home_value  med_relinc =relinc ///
 (p20) p20_rel_equityW=rel_equityW  p20_home_value=home_value  p20_relinc =relinc ///
(p80) p80_rel_equityW=rel_equityW p80_home_value=home_value  p80_relinc =relinc ///
 , by(year )

twoway (scatter owner year ), name(OOshare)

twoway (scatter rel_equityW year ) (scatter med_rel_equityW year) (scatter p20_rel_equityW year) (scatter p80_rel_equityW year),name(AGreleq)

twoway (scatter home_value year ) (scatter med_home_value year) (scatter p20_home_value year) (scatter p80_home_value year),  name(AGhv) 

twoway (scatter relinc year ) (scatter med_relinc year) (scatter p20_relinc year) (scatter p80_relinc year),  name(AGrelinc)

outsheet * using "\output\outputAgg.csv" , comma replace
restore 