*This file creates the programs that are used repeatedly by several of the tables and graph production

capture program drop testp 
program testp
	args v1 v2 v3
	
	if missing(`v3') {
	    gen testser=0
	}



end


/* 1. margchange calculates the change in the WTP of the marginal buyer used for bootstrap
 Inputs: a baseline ln(WTP) variable and a treatment ln(WTP) variable.
 Outputs: change in marginal buyer WTP (also includes min and max in case there are
 flat sections at 0 in the series), the FZ avg diff, and the difference between the 2
 as return() objects: marg_change FZchange FZlessMarg
*/

capture program drop margchangeBS
program margchangeBS, rclass
	args basevar treatvar trim_percentage
	
	 *syntax varlist [if] [in] [, DOF(integer 50) Beta(real 1.0)]
	
		*Step -1. Redo trim for resample 
		
	*	if `trim_percentage'>0 &`trim_percentage'<51  {
		   * if !missing(`trim_percentage'){
	*		trim_level `basevar' `treatvar' `trim_percentage'
		*	replace `basevar' =`basevar'_T`trim_percentage' 
		*	replace `basevar' =`basevar'_T`trim_percentage'
	*	}
		
		
		* Step 0. redo cumul for resample
		capture drop `basevar'_cum
		capture drop `treatvar'_cum
	
		cumul `basevar',gen(`basevar'_cum)
		cumul `treatvar',gen(`treatvar'_cum)
	
	
		*Step 1. Take absolute value of log(WTP1/appraisal) as temp variable
		capture drop temp_absvalbase  
		capture drop temp_pctbase
		capture drop temp_WTPtreat
		capture drop temp_pct_treat_mean
		capture drop temp_pct_treat_min
		capture drop temp_pct_treat_max
		capture drop temp_WTPtreat_mean
		capture drop temp_WTPtreat_min
		capture drop temp_WTPtreat_max

		qui generate temp_absvalbase=abs(`basevar')

		*Step 2. Find the observation(s) that correspond to the minimum abs value
		qui sum temp_absvalbase


		*Step 3. Take the average (could do min/max) percentile of those minimum observation(s), perhaps for bootstrap take a random draw?
		qui gen temp_pctbase=  `basevar'_cum  if temp_absvalbase==r(min)
		qui sum temp_pctbase
		scalar mean_pct_base=r(mean)
		scalar min_pct_base=r(min)
		scalar max_pct_base=r(max)
		
		*Step 3.1 Find WTP1 at this percentile (close to zero but not necessarily)
		
		qui sum  `basevar' if  `basevar'_cum==min_pct_base
		scalar temp_WTP_base=r(mean)

		*Step 4. Find the log(WTP2/appraisal) closest to those observations
		qui gen temp_pct_treat_mean=abs(`treatvar'_cum-mean_pct_base)
		qui gen temp_pct_treat_min=abs(`treatvar'_cum-min_pct_base)
		qui gen temp_pct_treat_max=abs(`treatvar'_cum-max_pct_base)

		qui sum temp_pct_treat_mean
		qui gen temp_WTPtreat_mean=  `treatvar'  if temp_pct_treat_mean == r(min)

		qui sum temp_pct_treat_min
		qui gen temp_WTPtreat_min=  `treatvar'  if temp_pct_treat_min == r(min)

		qui sum temp_pct_treat_max
		qui gen temp_WTPtreat_max=  `treatvar'  if temp_pct_treat_max == r(min)


		*Step 5. Average them to find final log(WTP2/appraisal)
		sum temp_WTPtreat_mean
		return scalar marg_change=r(mean)-temp_WTP_base
		scalar temp_price_change=r(mean)-temp_WTP_base
		
		sum temp_WTPtreat_min
		return scalar marg_changeMin=r(mean)-temp_WTP_base
			
		sum temp_WTPtreat_max
		return scalar marg_changeMax=r(mean)-temp_WTP_base
		
		*return scalar marg_change=r(mean)
	
		*scalar temp_price_change=r(mean)
		sum temp_WTPtreat_min
		sum temp_WTPtreat_max
		
		*Auxilary -- do FZ method for comparison
		capture drop templogdiff
		 gen templogdiff=`treatvar' - `basevar' 
		sum templogdiff
		return scalar  FZchange=r(mean)
		 scalar  temp_FZchange=r(mean)
		return scalar FZlessMarg=temp_FZchange-temp_price_change
		
		
end


/* 2. binomialSE calculates the confidence interval for the marginal change estimate
using the binomial distributio nor percentile rank.
Inputs: baseline and treatment log WTP variables
Outputs: confidence interval bounds as scalars loCI and hiCI (plus other incidental scalars)
*/
capture program drop binomialSE 
program binomialSE, rclass
	args basevar treatvar

	capture drop trank_`basevar'
	capture drop trank_`treatvar'
	capture drop temp_abs
	capture drop rank_distHi
	capture drop rank_distLo
	capture drop rank_distMarg
	
	sum `basevar' 
	scalar n1 =r(N)
	sum `treatvar' 
	scalar n2 =r(N)
	scalar LOS=0.05

	egen trank_`basevar' =rank(`basevar'),unique
	egen trank_`treatvar' =rank(`treatvar' ),unique

	*Find the rank of the marginal buyer in base case mapped to treatment case
	gen temp_abs=abs(`basevar')
	sum temp_abs
	sum trank_`basevar' if temp_abs==r(min)
	scalar marginalRank=r(mean)
	*Calc upper and lower CIs on the rank
	
	scalar rankLo= round((1-invbinomial(n1,n1-marginalRank,(LOS^0.5)/2))*n2)
	scalar rankHi= round(invbinomial(n1,marginalRank,(LOS^0.5)/2)*n2)

	*Find the lower CI from  the lower rank, and upper from upper in the treatment case

	scalar marginalRankTreat=r(mean)/n1*n2
	scalar rankLoTreat=round((1-invbinomial(n2,n2-rankLo,(LOS^0.5)/2))*n2)
	scalar rankHiTreat=round(invbinomial(n2,rankHi,(LOS^0.5)/2)*n2)

	*Find the WTP in treatment group that map to each one
	gen rank_distHi=abs(trank_`treatvar'-rankHiTreat)
	sum rank_distHi
	sum `treatvar'  if rank_distHi==r(min)
	scalar hiCI=r(mean)

	gen rank_distLo=abs(trank_`treatvar' -rankLoTreat)
	sum rank_distLo
	sum `treatvar'  if rank_distLo==r(min)

	scalar loCI=r(mean)

	gen rank_distMarg=abs(trank_`treatvar' -marginalRankTreat)
	sum rank_distMarg
	sum `treatvar'  if rank_distMarg==r(min)

	scalar estres=r(mean)

end


/* 3. range_bstrap runs the bootstrap command 

*/

capture program drop range_bstrap
program range_bstrap, rclass
	args bvar tvar bsreps trim_percentage
	local dots_number=round(`bsreps'/10)
	preserve 
	keep  if !missing(`bvar')| !missing(`tvar')
	
	  bootstrap r(marg_change) r(FZchange) r(FZlessMarg), dots(`dots_number') nowarn reps(`bsreps'): margchangeBS `bvar' `tvar' `trim_percentage'
	restore

end

/* 4. trim_level trim tails of X percent in growth rates, and then construct levels series trimmed in the same way
Input: baseline and treatment variables, and trim depth
Output: trimmed baseline and treatment variable with "_TX" as suffix
*/

capture program drop trim_level
program  trim_level
	args bvar tvar trim_percentage
	capture drop temp_change
	generate temp_change= `tvar'-`bvar'
	
	capture drop temp_trim_indicator
	trimmean temp_change,percent(`trim_percentage') generate(temp_trim_indicator)
	
	
	capture drop `bvar'_T`trim_percentage'
	capture drop `tvar'_T`trim_percentage'
	generate `bvar'_T`trim_percentage'=`bvar' if temp_trim_indicator==1
	generate `tvar'_T`trim_percentage'=`tvar' if temp_trim_indicator==1
	
	drop temp_change
	drop temp_trim_indicator
end
	
	/*4.1 trim_level_complex adds another pair variable to trim based upon.
	Used when you have removed zeros already and want to not lose any observations.
	That is you want to use the trim-on variable if either of the base and treat variables exist
	*/
	capture program drop trim_level_complex
program  trim_level_complex
	args bvar tvar trim_percentage bvar_trim_on tvar_trim_on
	capture drop temp_change
	capture drop temp_change_trim_on
	generate temp_change= `tvar'-`bvar'
	generate temp_change_trim_on= `tvar_trim_on'-`bvar_trim_on' if !missing(`tvar')|!missing(`bvar')
	
	capture drop temp_trim_indicator
	trimmean temp_change_trim_on,percent(`trim_percentage') generate(temp_trim_indicator)
	
	
	capture drop `bvar'_T`trim_percentage'
	capture drop `tvar'_T`trim_percentage'
	generate `bvar'_T`trim_percentage'=`bvar' if temp_trim_indicator==1
	generate `tvar'_T`trim_percentage'=`tvar' if temp_trim_indicator==1
	
	drop temp_change
	drop temp_trim_indicator
end
/* 5. remove_zeros_self deletes any observations where WTP=APP in that series
input: baselne and treatment series
output: series with deletions made, suffix "_Ex0"
*/

capture program drop remove_zeros_self
program  remove_zeros_self
	args bvar tvar
	
	capture drop `bvar'_Ex0
	capture drop `tvar'_Ex0
	
	 generate `bvar'_Ex0 = `bvar' if `bvar'!=0
	 generate `tvar'_Ex0 = `tvar' if `tvar'!=0
	
	*Want to add 1 zero value back into the basevar so it isn't empty for the percentile
	
	capture drop temp_series
	gen temp_series = _n if `bvar'==0
	sum temp_series 
	replace `bvar'_Ex0= `bvar' if _n==r(min)
	
	capture drop temp_series
	gen temp_series = _n if `tvar'==0
	sum temp_series 
	replace `tvar'_Ex0= `tvar' if _n==r(min)
	
	
	
	*generate `bvar'_Ex0 = `bvar' if `bvar'!=0 &`tvar'!=0
	*generate `tvar'_Ex0 = `tvar' if  `bvar'!=0 &`tvar'!=0
end

/* 6. remove_zeros_multi deletes any observations where WTP=APP some series in multiple ways

input: baselne and treatment series
output: 
- series with deletions made iff own series is 0, suffix "_Ex0"
- series with deletions made iff both treatment and baseline series is 0, suffix "_Ex0and"
- series with deletions made iff either treatment or baseline series is 0, suffix "_Ex0or"
- serie with deltions made iff all4 WTPs=Appraisal, suffix "_Ex0all"

*/

capture program drop remove_zeros_multi
program  remove_zeros_multi
	args bvar tvar
	
	capture drop `bvar'_Ex0
	capture drop `tvar'_Ex0
	capture drop `bvar'_Ex0and
	capture drop `tvar'_Ex0and
	capture drop `bvar'_Ex0or
	capture drop `tvar'_Ex0or
	capture drop `bvar'_Ex0all
	capture drop `tvar'_Ex0all
	
	pause
	
	generate `bvar'_Ex0 = `bvar' if `bvar'!=0
	generate `tvar'_Ex0 = `tvar' if `tvar'!=0
	
	generate `bvar'_Ex0and = `bvar' if `bvar'!=0 |`tvar'!=0
	generate `tvar'_Ex0and = `tvar' if `bvar'!=0 |`tvar'!=0
	
	generate `bvar'_Ex0or = `bvar' if `bvar'!=0 &`tvar'!=0
	generate `tvar'_Ex0or = `tvar' if `bvar'!=0 &`tvar'!=0
	
	generate `bvar'_Ex0all = `bvar' if  !(ln_wtp1_ar==0&ln_wtp2_ar==0&ln_wtp3_ar==0&ln_wtp4_ar==0)
	generate `tvar'_Ex0all = `tvar' if  !(ln_wtp1_ar==0&ln_wtp2_ar==0&ln_wtp3_ar==0&ln_wtp4_ar==0)

end

/* 7. segment deletes any observations where a custo condition does not apply
i.e. keeps the market segment only

inputs:
- baselne and treatment series, 
- a series with 1 for the segment and 0 else, 
- an identifier suffix, for the series, e.g. Rent
output: sbaseline and treatment series for the segments with _suffix
*/

capture program drop segment
program  segment
	args bvar tvar conditionvar suffix
	
	capture drop `bvar'_`suffix'
	capture drop `tvar'_`suffix'
	
	gen `bvar'_`suffix'=`bvar' if `conditionvar'==1
	gen `tvar'_`suffix'=`tvar' if `conditionvar'==1
	
end
	
	
	
	*8 Generate WTPs from rho and phi params
	
capture program  drop genWTP
program genWTP
	args rho_series phi_series WTPnumber suffix

	if 	`WTPnumber'==1 {
		local DP=tightDP
		}
		
	if 	`WTPnumber'==2 {
		local DP=looseDP
		
	}
	
	
	capture drop temp_rho_series
	gen temp_rho_series=`rho_series'
	replace temp_rho_series=(1-margtax)*(hypo_first_rate/100) if `rho_series' <(1-margtax)*(hypo_first_rate/100)
	
		gen WTP`WTPnumber'_fit_`suffix' = (1+`phi_series')/(`DP'*temp_rho_series+(1-`DP')*(hypo_first_rate/100)*(1-margtax) + propertytax - growth + growth*(1-`DP')*(1-mobility)*((temp_rho_series-(1-margtax)*(hypo_first_rate/100))/(temp_rho_series+mobility)))/RPratio_full
		
		drop temp_rho_series
		
		gen ln_WTP`WTPnumber'_fit_`suffix'=log(WTP`WTPnumber'_fit_`suffix')
end

	
	
	** OUTPUT HANDLING PROGRAMS
	
	/* gen_variables makes the variables to house the output
	*/

capture program drop gen_variables
program  gen_variables
	args number_of_vars
	
		forvalues varnum=1/`number_of_vars'{
		    capture drop mean`varnum'
			capture drop ll`varnum'
			capture drop ul`varnum'
			
			generate mean`varnum'=.
			generate ll`varnum'=.
			generate ul`varnum'=.
		}
	


end
	
	/* bstrap2variables makes bootstrap matrices into variables 
	*/

				       
capture program drop bstrap2variables
 program  bstrap2variables
	args meanmat cimat condition_variable condition_value
	
	    forvalues j=1/3{
                             replace mean`j'=`meanmat'[1,`j'] if `condition_variable'==`condition_value'
						  
                              replace ll`j'=`cimat'[1,`j'] if `condition_variable'==`condition_value'
                                replace ul`j'=`cimat'[2,`j'] if `condition_variable'==`condition_value'
                                }
 
 
 end

 capture program drop bstrap2variablesN
 program  bstrap2variablesN
	args meanmat cimat condition_variable condition_value num_of_params
	
	    forvalues j=1/`num_of_params'{
                             replace mean`j'=`meanmat'[1,`j'] if `condition_variable'==`condition_value'
						  
                              replace ll`j'=`cimat'[1,`j'] if `condition_variable'==`condition_value'
                                replace ul`j'=`cimat'[2,`j'] if `condition_variable'==`condition_value'
                                }
 
 
 end
 
 /* CDFgraph
 
 */
 
capture  program drop CDFgraph
 
 program CDFgraph
	args  bvar tvar  maxlogratio  minlogratio graph_name
	
	foreach var in `tvar' `bvar'{
		*egen rank_`var'=rank(`var')
		capture drop `var'_cum
		cumul `var',gen(`var'_cum)
		capture drop `var'_cumRev
		gen `var'_cumRev=1-`var'_cum
		
		capture drop w`var'
		gen w`var'=`var' if !missing(`var')
		replace w`var'= `maxlogratio' if `var'>`maxlogratio' & !missing(`var')
		replace w`var'= `minlogratio' if `var'<`minlogratio' & !missing(`var')
	}
	
capture drop MeanChange
capture drop mmarg
		margchangeBS `bvar' `tvar'  0
		gen MeanChange = r(FZchange)
			gen mmarg = r(marg_change)

		local ygraphspot=r(FZchange)+.1
	local xlineval=1-`=scalar(mean_pct_base)'
	local xgraphspot=`xlineval'+.2
		*capture drop mmarg
		*gen mmarg = r(marg_change)
twoway (line w`tvar' `tvar'_cumRev ,sort) (line w`bvar' `bvar'_cumRev ,sort) , ytitle(Log(Price) relative to appraisal, size(medlarge)) xtitle(Quantity (fraction of HHs buying at the price), size(medlarge)) title(Constructed Demand Curves) name(`graph_name') xline(`xlineval') yline(  `=r(marg_change)') xlabel(,nogrid)  nodraw
 
 capture drop supply
 gen supply = `xlineval'
  
  
	

* local inter= r(marg_change)
 * gen mmarg = `inter'
 *di r(marg_change)
 *di mmarg
 
 
 
 preserve
 capture drop `tvar'TempSort
 sort `bvar'
  fixsort `tvar' , gen(`tvar'TempSort)
  
 capture drop difference
 gen difference = `tvar'TempSort -`bvar'
 


 twoway (line difference `bvar'_cumRev ,sort) (line MeanChange `bvar'_cumRev ,sort) , ytitle(Change in demand curve) xtitle(Quantity (fraction of HHs buying at the price),size(medlarge)) title(Change in demand curve across the market) xline(`xlineval') name(`graph_name'diff)  xlabel(,nogrid) ylabel(#4) fysize(40)  text( `ygraphspot' `xgraphspot' "Average", color(`.__SCHEME.color.p2') size(medium))  legend(off) nodraw
 
  twoway (line difference `bvar'_cumRev ,sort) (line MeanChange `bvar'_cumRev ,sort) , ytitle(Change in demand curve) xtitle(Quantity (fraction of HHs buying at the price),size(medlarge)) title(Change in demand curve across the market) xline(`xlineval') name(`graph_name'diffPres)  xlabel(,nogrid) ylabel(#4)   text( `ygraphspot' `xgraphspot' "Average", color(`.__SCHEME.color.p2') size(medium))  legend(off) nodraw

 sort `tvar'_cumRev
 export excel  `tvar'_cumRev w`tvar'   supply   MeanChange mmarg using "G:\Research\CusbertT\FZ\Analysis\Graphs\dcurves\DdataT`graph_name'.xlsx" ,  replace  firstrow(variables)
 sort  `bvar'_cumRev 
 
 
 export excel `bvar'_cumRev w`bvar' supply mmarg MeanChange mmarg using "G:\Research\CusbertT\FZ\Analysis\Graphs\dcurves\DdataB`graph_name'.xlsx" ,  replace  firstrow(variables)
 
 
 
 
 graph combine `graph_name' `graph_name'diff, ycommon cols(1) ysize(5.91) xsize(5.91) name(`graph_name'ComBad) title(combined `bvar')
 addplot:, legend(off) xlabel(,nogrid) 
 
 
 restore
 
 end
 
 *Program to do leave one out regression
 capture program drop press
 program define press, rclass
    syntax varlist(fv) [if] [in]        ///
    [fweight aweight pweight iweight] [, name(string)]
	*, ///
    *[nodots]

    gettoken y x : varlist
    marksample touse
	sort userid
    preserve
    quietly keep if `touse'
    if "`weight'" != "" {
        local wgt "[`weight'`exp']"
    }

    tempvar pred temp prs
    quietly gen double `pred' = .
    if "`dots'" == "" _dots 0, title(Jackknife replications) reps(`=_N')
    forvalues i = 1/`=_N' {
        capture {
            reg `y' `x' `wgt' if _n != `i'
            predict double `temp'
            replace `pred' = `temp' in `i'
            drop `temp'
        }
        if "`dots'" == "" _dots `i' `=_rc > 0'
    }
    quietly gen double `prs' = (`y' - `pred')^2
    sum `prs', meanonly

    if "`dots'" == "" di _n _n
    di as txt "The predicted residual sum of squares is " as result r(sum)
    return scalar press = r(sum)
    

	generate LWOpred_`name'=`pred'
	
	tempfile formerge
	save `formerge', replace
	restore

	 merge userid using `formerge'
	 capture drop _merge
end




