


/*
Break into quintiles
Foreach quintile,  Inside the bootstrap:

	- avg & marginal for LTV
	- avg and marginal for rate cut
	- add together

	Then display avg and marginal with CIs vs Landvoights graph 10 panel B
	
	Coords of Landvoights Q1 to Q5 (mid points of each quintile range)
90.91718610863755, 12.225249772933696
186.01959038290292, 7.974568574023614
265.093499554764, 6.920980926430516
374.0872662511131, 6.303360581289734
617.720391807658, 5.867393278837419



*local bvar="ln_wtp1_ar"
*local tvar="ln_wtp2_ar"
 

local bvar="ln_WTPhighR_ar"
local tvar="ln_WTPlowR_ar"

*/
capture drop landSF
gen  landSF = 12.225249772933696/100 if _n==1
replace  landSF = 7.974568574023614/100 if _n==2
replace  landSF = 6.920980926430516/100 if _n==3
replace  landSF = 6.303360581289734/100 if _n==4
replace  landSF = 5.867393278837419/100 if _n==5



capture drop landSF
gen  landSF = log((12.225249772933696/100+1)^5) if _n==1
replace  landSF = log((7.974568574023614/100+1)^5) if _n==2
replace  landSF =log(( 6.920980926430516/100+1)^5) if _n==3
replace  landSF = log((6.303360581289734/100+1)^5) if _n==4
replace  landSF = log((5.867393278837419/100+1)^5) if _n==5

capture program drop landvoight
program landvoight, rclass
	args quintile_name qunitile_number
	
	preserve 
	
	qui keep if `quintile_name'==`qunitile_number'
		count
	qui	margchangeBS ln_wtp1_ar ln_wtp2_ar 0
		scalar ltvFZ=r(FZchange)
		scalar ltvMB=r(marg_change)
		
	qui	margchangeBS ln_WTPhighR_ar ln_WTPlowR_ar 0
		scalar cutFZ=r(FZchange)
		scalar cutMB=r(marg_change)
		
		return scalar totalFZ=ltvFZ+cutFZ
		return scalar totalMB=ltvMB+cutMB
		return scalar cutFZ=cutFZ
		return scalar cutMB=cutMB
		return scalar ltvFZ=ltvFZ
		return scalar ltvMB=ltvMB
	restore
end
*xtile quintile = homevalue, nq(5) 

qui landvoight quintile 5
return list
qui landvoight quintile 1
return list

forvalues i = 1(1)5 {
    display "quintile" `i'
     landvoight quintile `i'
	return list
}

/* bootstrap r(marg_change) r(FZchange) r(FZlessMarg), dots(`dots_number') nowarn reps(`bsreps'): landvoight `quintile_name' `qunitile_number'

preserve
	keep if quintile== 1
	
	bootstrap r(totalFZ) r(totalMB) r(cutFZ) r(cutMB)  r(ltvFZ) r(ltvMB)        , dots(10)  reps(100): landvoight quintile 1
restore
*/
gen_variables 6

forvalues i = 1(1)5 {
   preserve
	keep if quintile== `i'
	
	bootstrap  r(totalFZ) r(totalMB) r(cutFZ) r(cutMB)  r(ltvFZ) r(ltvMB), dots(10)  reps(2500): landvoight quintile `i'
restore

matrix meanmatQ`i'=e(b)
matrix cimatQ`i'=e(ci_normal)
bstrap2variablesN meanmatQ`i' cimatQ`i' _n `i' 6

}
set graphics off
forvalues i = 1(1)5 {
    
   preserve
		keep if quintile== `i'
		
		CDFgraph  ln_wtp1_ar ln_wtp2_ar 2  -2 gQuin`i'
	addplot gQuin`i':, legend(off)
	restore
}
set graphics on
forvalues i = 1(1)5 {
    
				graph combine  gQuin`i'  gQuin`i'diff,  xcommon cols(1) ysize(7.87) xsize(5.9)   title( "Quintile "+`i') name(CombQuin`i')



}

forvalues i = 1(1)5 {
    
			
scatter ln_wtp1_ar ln_homevalue if quintile==`i', name(scat`i')
reg ln_wtp1_ar ln_homevalue if quintile==`i'



}

 


 *	CDFgraph  `bvar'_T`trim'_`suffix'`dropsuffix' `tvar'_T`trim'_`suffix'`dropsuffix' 2  -2 g`suffix'
*	addplot gyng:, legend(off)
*graph combine  gyng  gyngdiff,  xcommon cols(1) ysize(20cm) xsize(15cm)  title( "Age < 35 (N=184)") name(CombYoung)


graph combine CombQuin1 CombQuin2 CombQuin3 CombQuin4 



gen Quin_graph=_n if _n<6
graph drop _all
twoway(rarea ll1 ul1 Quin_graph,fcolor(gs14)  lwidth(none)) (rarea ll2 ul2 Quin_graph,color(gs12%80) lwidth(none)) (connected mean2 Quin_graph, msymbol(circle)) (connected mean1 Quin_graph, msymbol(circle)) (connected landSF Quin_graph, msymbol(circle)), title("Comparison with Landvoight et al*") subtitle("Combined effect of lower rates and looser collateral constraints") name(LandComp)   legend(off) note("* Both studies lower the interest rate by 200 basis points and loosen the collateral" "constraint from 80% to 95%" "** Shaded areas are 95% bootstrapped confidence intervals"  )

twoway(rarea ll3 ul3 Quin_graph,fcolor(gs14)  lwidth(none)) (rarea ll4 ul4 Quin_graph,color(gs12%80) lwidth(none)) (connected mean4 Quin_graph, msymbol(circle)) (connected mean3 Quin_graph, msymbol(circle)), title("Lower rates (200 basis points)") name(CutComp) legend(off) xlabel(,nogrid) xtitle("Home value quintile") nodraw
 
twoway(rarea ll5 ul5 Quin_graph,fcolor(gs14)  lwidth(none)) (rarea ll6 ul6 Quin_graph,color(gs12%80) lwidth(none)) (connected mean6 Quin_graph, msymbol(circle)) (connected mean5 Quin_graph, msymbol(circle)), title("Looser collateral constraint (15ppts) ") name(LTVComp)  legend(off) xlabel(,nogrid) ytitle("Log change in WTP") xtitle("Home value quintile") text( 0.02 1.8 "Marginal buyer**", color(`.__SCHEME.color.p3')) text( 0.22 3.5 "Average change**", color(`.__SCHEME.color.p4')) nodraw


addplot  LandComp: , xtitle("Home value quintile") ytitle("Log change in WTP") text( 0.05 1.5 "Marginal buyer**", color(`.__SCHEME.color.p3')) text( 0.27 3 "Average change**", color(`.__SCHEME.color.p4')) text( 0.5 3  "Landvoight et al (price change over 5 years)", color(`.__SCHEME.color.p5')) xlabel(,nogrid) legend(off)

graph combine LTVComp CutComp, ycommon title("WTP change by home value quintile") note( "** Shaded areas are 95% bootstrapped confidence intervals"  ) name(CutLTVComp)

export excel mean1	ll1	ul1	landSF	mean2	ll2	ul2	mean3	ll3	ul3	mean4	ll4	ul4	mean5	ll5	ul5	mean6	ll6	ul6 using "Graphs/LanData.xlsx" ,  replace  firstrow(variables)

foreach suffix in "LandComp" "CutLTVComp"  {
	graph export output/fig_`suffix'.pdf, as(pdf) replace name(`suffix')
	
	
}

gen equity_available=100*calc_equity/homevalue
tabstat equity_available constrained renter homevalue ln_wtp1_ar, by(quintile) stat(mean  median ) nototal

gen homevalue000=homevalue/1000
gen renter100=100*renter
gen constrained100=100*constrained
gen WTP20100=exp(ln_wtp1_ar)*100 if exp(ln_wtp1_ar)*100

label  variable quintile  "quintile"

tabout quintile  using output/Table2_Quintiles.tex, ///
c(mean  homevalue000  mean  age mean ln_wtp1_ar mean  equity_available median ln_wtp1_ar median equity_available ) ///
f(0c 0c 2c 0c 2c 0c) ///
clab(Home_Value_(\$000s) Age Normalised_WTP_20 Equity_Available Normalised_WTP_20 Equity_Available) ///
sum npos(tufte) ///
rep ///
style(tex) bt cl2(2-5 6-7) cltr2(.75em 1.5em) ///
topf(top.tex) botf(bot.tex) topstr(\textwidth) botstr(\citet{fuster2021sensitivity})


