********************************************************************************************************************************************
* Define labels
********************************************************************************************************************************************

label var liquid_savings "Liquid Savings"
label var inc_cont "Income"
label var non_house_debt "Non-House Debt"


local catlab = ""
foreach var in inc_cont liquid_savings non_house_debt  {
local varlab `"`:var label `var''"'
levelsof `var', loc(listlevels)
foreach j in `listlevels' {
local catlab `"`catlab' `j'.`var' "`varlab': `j'""'
}
di `"`catlab'"'
}

#delimit ;
local var_lab `" 
	male "Male" startRateLow "Interest Rate Low" endRateLow "Interest Rate Low" res_children_under18_ind "Child(ren) $<18$ living at home" res_children_over18_ind "Child(ren) $\geq 18$ living at home"
	1.risk_aversion "Risk Averse" 2.risk_aversion "Risk Neutral" 3.risk_aversion "Risk Loving" 
	1.owner "Owner" 1.unemployed "Unemployed" ln_homevalue "Log(Appr.)"  
	1.credit_score_v2 "Credit Score Below 680" 2.credit_score_v2 "Credit Score 680-719" 3.credit_score_v2 "Credit Score 720-760" 4.credit_score_v2 "Credit Score Above 760" 
	25000.ls_cat "Liquid Savings of [5K, 30K)" 75000.ls_cat "Liquid Savings of [30K, 100K)" 375000.ls_cat "Liquid Savings of [100K, 500K)" 1000000.ls_cat "Liquid Savings of 500K or more" 
	3500.nh_cat "Non-Housing Debt of [1000, 5000)" 25000.nh_cat "Non-Housing Debt of [5K, 30K)" 100000.nh_cat "Non-Housing Debt of 30K or more"
	67500.i_cat "Income in (40K, 75K]" 125000.i_cat "Income in (75K, 150K]" 200000.i_cat "Income greater than 150K"
	q6cnew "Pr(buy $\vert$ move)" prob_move_3yr "Pr(move over next 3 yrs)" equity_pct "Equity Percent of Appr." 
	50000.eq_cat "Equity in (0, 50K]" 125000.eq_cat "Equity in (50, 125K]" 200000.eq_cat "Equity in (125K, 200K]" 900000.eq_cat "Equity of more than 200K" 
	_cons "Constant" Whh_inc_change "E(Inc. growth, 1 yr)" Wpct_q3a_1yr "E(HP growth, 1 yr)" Wpct_q3a_5yr "E(HP growth, 5 yrs)" zip_good_inv "Property in zip is good investment"
	hypo_dlow "DP Frac. when Rate = 4.5\% (0-1)" Wmargrate_noSS "Marginal income tax rate" property_tax_rate "Property tax rate" Wproperty_tax_rate "Property tax rate"
	0.equity_pct_cat "No or Negative Equity" 25.equity_pct_cat "Equity Pct of Appr. in (0, 25]" 50.equity_pct_cat "Equity Pct in (25, 50]" 100.equity_pct_cat "Equity Pct above 50" 
	1.regiongrp "Midwest" 2.regiongrp "Northeast" 3.regiongrp "South" 4.regiongrp "West"  troughpeak_ratio "Trough-Peak Ratio" inc_cont "Income"
	ln_wtp1_appr_ratio "WTP1 gap" ln_wtp2_appr_ratio "WTP2 gap" ln_wtp3_appr_ratio "WTP3 gap" ln_wtp4_appr_ratio "WTP4 gap"
"';
#delimit cr

global var_lab "`var_lab' `catlab'"


********************************************************************************************************************************************
* Define regressors
********************************************************************************************************************************************

replace  property_tax_rate = 1 if prop_tax_missing==1
replace Wproperty_tax_rate = 1 if prop_tax_missing==1

* Define global regressors
global charact  "i.owner age total_numeracy total_numeracy_missing college q38 male" 
global charact0  "i.owner age total_numeracy total_numeracy_missing college q38 male" 
global charact1  "i.owner age total_numeracy total_numeracy_missing college q38 male Wmargrate_noSS Wproperty_tax_rate prop_tax_missing i.regiongrp  i.homet"
global charact2  "i.owner age total_numeracy total_numeracy_missing college q38 male i.stategrp"
global balsheet "ib(first).eq_cat ib(first).ls_cat ib(first).nh_cat ib(first).credit_score_v2"
global balsheet0 "ib(first).eq_cat ib(first).ls_cat ib(first).nh_cat ib(first).credit_score_v2 ib(first).i_cat"
global balsheet1 "ib(first).eq_cat"
global balsheet2 "ib(first).ls_cat"
global balsheet3 "ib(first).nh_cat"
global balsheet4 "ib(first).credit_score_v2"
global balsheet5 "ib(first).i_cat"
global incempl  "ib(first).i_cat"

global balsheet_cont "equity_value equity_value_2 equity_value_3 equity_value_missing ib(first).liquid_savings ib(first).non_house_debt ib(first).q14"
global balsheet0_cont "equity_value equity_value_2 equity_value_3 ib(first).liquid_savings ib(first).non_house_debt ib(first).q14 ib(first).inc_cont"
global balsheet1_cont "equity_value equity_value_2 equity_value_3"
global balsheet2_cont "ib(first).liquid_savings"
global balsheet3_cont "ib(first).non_house_debt"
global balsheet4_cont "ib(first).q14"
global balsheet5_cont "ib(first).inc_cont"
global incempl_cont  "ib(first).inc_cont"

global pref     "ib2.risk_aversion "
global belief   "Whh_inc_change Whh_inc_change_missing  Wpct_q3a_1yr Wpct_q3a_1yr_missing prob_move_3yr prob_move_3yr_missing q6cnew q6cnew_missing"
global belief0   "zip_good_inv downwt_zip_5yr prob_move_3yr prob_move_3yr_missing q6cnew q6cnew_missing"
global belief1   "Wpct_q3a_1yr Wpct_q3a_1yr_missing downwt_zip_5yr prob_move_3yr prob_move_3yr_missing q6cnew q6cnew_missing"
global belief2   "Wpct_q3a_5yr Wpct_q3a_5yr_missing downwt_zip_5yr prob_move_3yr prob_move_3yr_missing q6cnew q6cnew_missing"
global belief3   "ib(first).quartiles_pct_q3a_1yr quartiles_pct_q3a_1yr_missing downwt_zip_5yr prob_move_3yr prob_move_3yr_missing q6cnew q6cnew_missing"
global belief4   "ib(first).quartiles_pct_q3a_5yr quartiles_pct_q3a_5yr_missing downwt_zip_5yr prob_move_3yr prob_move_3yr_missing q6cnew q6cnew_missing"


sum $charact $pref $belief $balsheet $incempl

estimates clear

******************************************************************************************************************************
*** Winsorization
******************************************************************************************************************************

gen winsorized5 = 0
gen winsorized25 = 0
gen winsorized5_q1 = 0
gen winsorized25_q1 = 0


foreach var in ln_hypo_q1 ln_price_appraisal_ratio hypo_q2_q1_logchg ///
hypo_logchange_rateup hypo_dchange_rateup hypo_logchange_inher hypo_fraction_change_d4_d3 ///
 {
    di "`var'"
	gen W5`var' = `var'
	gen W25`var' = `var' 
	
	_pctile `var', p(2.5 5 95 97.5)
	replace W5`var' = . if `var' < `r(r2)' | `var' > `r(r3)'
	replace W25`var' = . if `var' < `r(r1)' | `var' > `r(r4)'
	if "`var'" != "ln_hypo_q1" {
	replace winsorized5 = 1 if `var' < `r(r2)' | `var' > `r(r3)'
	replace winsorized25 = 1 if `var' < `r(r1)' | `var' > `r(r4)'
	}
	replace winsorized5_q1 = 1 if `var' < `r(r2)' | `var' > `r(r3)'
	replace winsorized25_q1 = 1 if `var' < `r(r1)' | `var' > `r(r4)'
}

foreach var in  ln_wtp1_appr_ratio ln_wtp2_appr_ratio ln_wtp3_appr_ratio ln_wtp4_appr_ratio  {
winsor `var', gen(W5`var') p(.05)
winsor `var', gen(W25`var') p(.025)
}

