% Plot results under different sets of restrictions.

clear variables
close all
clc

oldFolder = pwd;

%% Sign restrictions

cd('Results');
load('MP_sign_results.mat'); % Load results
cd(oldFolder);

cd('Figures');

ylims = zeros(ni,2);

for ii = 1:ni
    
    figure;
    h1 = plot(0:opt.H,meanlb(:,ii),'color','k','LineStyle','--');
    hold on;
    plot(0:opt.H,meanub(:,ii),'color','k','LineStyle','--');
    h2 = plot(0:opt.H,credlb(:,ii),'-k','LineWidth',2);
    plot(0:opt.H,credub(:,ii),'-k','LineWidth',2);
    h3 = plot(0:opt.H,rSinglePriorMean(:,ii),'ko','MarkerFaceColor','k');
    h4 = plot(0:opt.H,hpdlb(:,ii),'--k','LineWidth',2);
    plot(0:opt.H,hpdub(:,ii),'--k','LineWidth',2);

    ylims(ii,:) = ylim;

    if irfUnits(opt.ivar(ii)) == 0
        ylabel('%');
    elseif irfUnits(opt.ivar(ii)) == 1
        ylabel('ppt');
    elseif irfUnits(opt.ivar(ii)) == 2
        ylabel('bps');
    end
    
    title(sprintf('%s',varnames{opt.ivar(ii)}));
    xlabel('Horizon (months)');
    xticks(0:12:60);
    
    for hh = 0:opt.H
        line([hh hh],[meanlb(hh+1,ii) meanub(hh+1,ii)],'color','k');
    end

    line([0 opt.H],[0 0],'color','black','LineStyle',':');
    
    Ax = gca;
    Ax.FontSize = 14;
    
    print(sprintf('%s_sign',varnames{opt.ivar(ii)}),'-depsc');
        print(sprintf('%s_sign',varnames{opt.ivar(ii)}),'-dpng');
    
end

cd(oldFolder);

%% Sign + shock-sign in October 1979

cd('Results');
load('MP_shocksign79_results.mat'); % Load results
cd(oldFolder);

cd('Figures');

for ii = 1:ni
    
    figure;
    h1 = plot(0:opt.H,meanlb(:,ii),'color','k','LineStyle','--');
    hold on;
    plot(0:opt.H,meanub(:,ii),'color','k','LineStyle','--');
    h2 = plot(0:opt.H,credlb(:,ii),'-k','LineWidth',2);
    plot(0:opt.H,credub(:,ii),'-k','LineWidth',2);
    h3 = plot(0:opt.H,rSinglePriorMean(:,ii),'ko','MarkerFaceColor','k');
    h4 = plot(0:opt.H,hpdlb(:,ii),'--k','LineWidth',2);
    plot(0:opt.H,hpdub(:,ii),'--k','LineWidth',2);

    ylim(ylims(ii,:));
    
    if irfUnits(opt.ivar(ii)) == 0
        ylabel('%');
    elseif irfUnits(opt.ivar(ii)) == 1
        ylabel('ppt');
    elseif irfUnits(opt.ivar(ii)) == 2
        ylabel('bps');
    end
    
    title(sprintf('%s',varnames{opt.ivar(ii)}));
    xlabel('Horizon (months)');
    xticks(0:12:60);
    
    for hh = 0:opt.H
        line([hh hh],[meanlb(hh+1,ii) meanub(hh+1,ii)],'color','k');
    end

    line([0 opt.H],[0 0],'color','black','LineStyle',':');
    
    Ax = gca;
    Ax.FontSize = 14;
    
    print(sprintf('%s_shocksign79',varnames{opt.ivar(ii)}),'-depsc');
    print(sprintf('%s_shocksign79',varnames{opt.ivar(ii)}),'-dpng');
    
end

cd(oldFolder);

%% Sign + shock-sign + HD in October 1979

cd('Results');
load('MP_HD79_results.mat'); % Load results
cd(oldFolder);

cd('Figures');

for ii = 1:ni
    
    figure;
    h1 = plot(0:opt.H,meanlb(:,ii),'color','k','LineStyle','--');
    hold on;
    plot(0:opt.H,meanub(:,ii),'color','k','LineStyle','--');
    h2 = plot(0:opt.H,credlb(:,ii),'-k','LineWidth',2);
    plot(0:opt.H,credub(:,ii),'-k','LineWidth',2);
    h3 = plot(0:opt.H,rSinglePriorMean(:,ii),'ko','MarkerFaceColor','k');
    h4 = plot(0:opt.H,hpdlb(:,ii),'--k','LineWidth',2);
    plot(0:opt.H,hpdub(:,ii),'--k','LineWidth',2);

    ylim(ylims(ii,:));
    
    if irfUnits(opt.ivar(ii)) == 0
        ylabel('%');
    elseif irfUnits(opt.ivar(ii)) == 1
        ylabel('ppt');
    elseif irfUnits(opt.ivar(ii)) == 2
        ylabel('bps');
    end
    
    title(sprintf('%s',varnames{opt.ivar(ii)}));
    xlabel('Horizon (months)');
    xticks(0:12:60);
    
    for hh = 0:opt.H
        line([hh hh],[meanlb(hh+1,ii) meanub(hh+1,ii)],'color','k');
    end

    line([0 opt.H],[0 0],'color','black','LineStyle',':');
    
    Ax = gca;
    Ax.FontSize = 14;
    
    print(sprintf('%s_HD79',varnames{opt.ivar(ii)}),'-depsc');
    print(sprintf('%s_HD79',varnames{opt.ivar(ii)}),'-dpng');
    
end

cd(oldFolder);

%% Sign + shock-sign for extended set of dates

cd('Results');
load('MP_shocksignExt_results.mat'); % Load results
cd(oldFolder);

cd('Figures');

for ii = 1:ni
    
    figure;
    h1 = plot(0:opt.H,meanlb(:,ii),'color','k','LineStyle','--');
    hold on;
    plot(0:opt.H,meanub(:,ii),'color','k','LineStyle','--');
    h2 = plot(0:opt.H,credlb(:,ii),'-k','LineWidth',2);
    plot(0:opt.H,credub(:,ii),'-k','LineWidth',2);
    h3 = plot(0:opt.H,rSinglePriorMean(:,ii),'ko','MarkerFaceColor','k');
    h4 = plot(0:opt.H,hpdlb(:,ii),'--k','LineWidth',2);
    plot(0:opt.H,hpdub(:,ii),'--k','LineWidth',2);

    ylim(ylims(ii,:));
    
    if irfUnits(opt.ivar(ii)) == 0
        ylabel('%');
    elseif irfUnits(opt.ivar(ii)) == 1
        ylabel('ppt');
    elseif irfUnits(opt.ivar(ii)) == 2
        ylabel('bps');
    end
    
    title(sprintf('%s',varnames{opt.ivar(ii)}));
    xlabel('Horizon (months)');
    xticks(0:12:60);
    
    for hh = 0:opt.H
        line([hh hh],[meanlb(hh+1,ii) meanub(hh+1,ii)],'color','k');
    end

    line([0 opt.H],[0 0],'color','black','LineStyle',':');
    
    Ax = gca;
    Ax.FontSize = 14;
    
    print(sprintf('%s_shocksignExt',varnames{opt.ivar(ii)}),'-depsc');
    print(sprintf('%s_shocksignExt',varnames{opt.ivar(ii)}),'-dpng');
    
end

cd(oldFolder);

%% Sign + shock-sign + HD for extended set of dates

cd('Results');
load('MP_HDExt_results.mat'); % Load results
cd(oldFolder);

cd('Figures');

for ii = 1:ni
    
    figure;
    h1 = plot(0:opt.H,meanlb(:,ii),'color','k','LineStyle','--');
    hold on;
    plot(0:opt.H,meanub(:,ii),'color','k','LineStyle','--');
    h2 = plot(0:opt.H,credlb(:,ii),'-k','LineWidth',2);
    plot(0:opt.H,credub(:,ii),'-k','LineWidth',2);
    h3 = plot(0:opt.H,rSinglePriorMean(:,ii),'ko','MarkerFaceColor','k');
    h4 = plot(0:opt.H,hpdlb(:,ii),'--k','LineWidth',2);
    plot(0:opt.H,hpdub(:,ii),'--k','LineWidth',2);
    
    ylim(ylims(ii,:));

    if irfUnits(opt.ivar(ii)) == 0
        ylabel('%');
    elseif irfUnits(opt.ivar(ii)) == 1
        ylabel('ppt');
    elseif irfUnits(opt.ivar(ii)) == 2
        ylabel('bps');
    end
    
    title(sprintf('%s',varnames{opt.ivar(ii)}));
    xlabel('Horizon (months)');
    xticks(0:12:60);
    
    for hh = 0:opt.H
        line([hh hh],[meanlb(hh+1,ii) meanub(hh+1,ii)],'color','k');
    end

    line([0 opt.H],[0 0],'color','black','LineStyle',':');
    
    Ax = gca;
    Ax.FontSize = 14;
    
    print(sprintf('%s_HDExt',varnames{opt.ivar(ii)}),'-depsc');
    print(sprintf('%s_HDExt',varnames{opt.ivar(ii)}),'-dpng');
    
end

cd(oldFolder);