% Export graph data to Excel for plotting (for RDP version).

clear variables
close all
clc

%% Figure 1
% Illustration of likelihood and posterior for impulse response under 
% shock-sign restriction.

cd('Results');
load('ShockSignIllustration_results.mat');
cd ..

cd('Figures');
outputs = [thetaGrid, ll1, ll2];
writematrix(outputs,'GraphData.xlsx','Sheet','ShockSignLik');

EDGES = linspace(-sig11,sig11,200)';
[N1,~] = histcounts(etaDraws(:,1),EDGES,'Normalization','pdf');
edges = (EDGES(1:end-1) + EDGES(2:end))./2;
outputs = [edges, N1'];
writematrix(outputs,'GraphData.xlsx','Sheet','ShockSignPost1');
[N2,~] = histcounts(etaDraws(:,2),EDGES,'Normalization','pdf');
outputs = [edges, N2'];
writematrix(outputs,'GraphData.xlsx','Sheet','ShockSignPost2');

%% Figure 2
% Illustration of likelihood under historical-decomposition restriction.

cd ..
cd('Results');
load('HistoricalDecompositionIllustration_results.mat');
cd ..

cd('Figures');
outputs = [thetaGrid, conLik, unconLik];
writematrix(outputs,'GraphData.xlsx','Sheet','HDLik')
outputs = [thetaGrid, PrEps];
writematrix(outputs,'GraphData.xlsx','Sheet','HDPr');

%% Figure 3
% First panel - illustration of Hellinger distance under shock-sign 
% restriction.

cd ..
cd('Results');
load('ShockSignHellinger_results.mat');
cd ..

cd('Figures');
outputs = [thetaGrid, HDCsq];
writematrix(outputs,'GraphData.xlsx','Sheet','ShockSignHel');
cd ..

% Second panel - illustration of Hellinger distance under
% historical-decomposition restriction.

cd('Results');
load('HistoricalDecompositionHellinger_results.mat');
cd ..

cd('Figures');
outputs = [thetaGrid, HDCsq, thetaGrid, HDsq];
writematrix(outputs,'GraphData.xlsx','Sheet','HDHel');
cd ..

clear variables

%% Figures 4 and 5
% Impulse responses to monetary policy shock under different sets of 
% restrictions.

irfnames = {'FFR','GDP'};

% Sign restrictions only
cd('Results');
load('MP_sign_results.mat');
cd ..
cd('Figures');
for ii = 1:2

    TT1 = table((0:opt.H)',rSinglePriorMean(:,ii),hpdlb(:,ii),hpdub(:,ii),...
        meanlb(:,ii),meanub(:,ii),credlb(:,ii),credub(:,ii));
    TT1.Properties.VariableNames = {'Horizon','Mean','CREDLB','CREDUB','MEANLB','MEANUB','RCREDLB','RCREDUB'};
    writetable(TT1,'GraphData.xlsx','Sheet',strcat(irfnames{ii},'_sign'));
    
end
cd ..

% Sign + narrative restrictions - October 1979/Volcker episode
cd('Results');
load('MP_HD79_results.mat');
cd ..
cd('Figures');
for ii = 1:2

    TT1 = table((0:opt.H)',rSinglePriorMean(:,ii),hpdlb(:,ii),hpdub(:,ii),...
        meanlb(:,ii),meanub(:,ii),credlb(:,ii),credub(:,ii));
    TT1.Properties.VariableNames = {'Horizon','Mean','CREDLB','CREDUB','MEANLB','MEANUB','RCREDLB','RCREDUB'};
    writetable(TT1,'GraphData.xlsx','Sheet',strcat(irfnames{ii},'_HD79'));
    
end
cd ..

% Sign + extended set of shock-sign restrictions
cd('Results');
load('MP_shocksignExt_results.mat');
cd ..
cd('Figures');
for ii = 1:2

    TT1 = table((0:opt.H)',rSinglePriorMean(:,ii),hpdlb(:,ii),hpdub(:,ii),...
        meanlb(:,ii),meanub(:,ii),credlb(:,ii),credub(:,ii));
    TT1.Properties.VariableNames = {'Horizon','Mean','CREDLB','CREDUB','MEANLB','MEANUB','RCREDLB','RCREDUB'};
    writetable(TT1,'GraphData.xlsx','Sheet',strcat(irfnames{ii},'_shocksignExt'));
    
end
cd ..

% Sign + extended set of shock-sign and historical-decomposition
% restrictions
cd('Results');
load('MP_HDExt_results.mat');
cd ..
cd('Figures');
for ii = 1:2

    TT1 = table((0:opt.H)',rSinglePriorMean(:,ii),hpdlb(:,ii),hpdub(:,ii),...
        meanlb(:,ii),meanub(:,ii),credlb(:,ii),credub(:,ii));
    TT1.Properties.VariableNames = {'Horizon','Mean','CREDLB','CREDUB','MEANLB','MEANUB','RCREDLB','RCREDUB'};
    writetable(TT1,'GraphData.xlsx','Sheet',strcat(irfnames{ii},'_HDExt'));
    
end
cd ..
