*** SCRIPT FOR RDP2024-02 Valuing Safety and Privacy in Retail Central Bank Digital Currency
* Last update: Apr 2024

*** Install packages if not installed already
*ssc install coefplot
*ssc install outreg2
*ssc install estout

*** Set WD if didn't automatically change from opening stata project file
*** assumes .zip file is extracted in C:/Temp, users may need to change.

local filename "PUBLIC/Programs/1_data_cleaning.do"

** CHANGE THIS LOCATION TO WHERE FOLDER WAS EXTRACTED

local newdir "C:/Temp/RDP Files"
capture confirm file `filename'
if _rc == 0 {
    display "Directory is correct."
}
else {
    cd "`newdir'"
    display "Directory changed."
}

*** Import data, create DCE variables and covariates
do "PUBLIC/Programs/1_data_cleaning.do"

*** Regressions and WTP
do "PUBLIC/Programs/2_regressions.do" 

*** Data quality tests
do "PUBLIC/Programs/3_data_quality.do" 

*** Clear working data files
rm "INTERNAL_ONLY/Data/Working Data/data_1_master_clean.dta"
rm "INTERNAL_ONLY/Data/Working Data/CPS_Cash_Use_Shares.dta"
rm "INTERNAL_ONLY/Data/Working Data/attrition_test_inc_Paymentsdiary.dta"
rm "INTERNAL_ONLY/Data/Working Data/attrition_test_inc_Prediary.dta"
rm "INTERNAL_ONLY/Data/Working Data/attrition_test_inc_Recruited.dta"
rm "INTERNAL_ONLY/Data/Working Data/attrition_test_Paymentsdiary.dta"
rm "INTERNAL_ONLY/Data/Working Data/attrition_test_Prediary.dta"
rm "INTERNAL_ONLY/Data/Working Data/attrition_test_Recruited.dta"