* Import regression data
use "INTERNAL_ONLY\Data\Working Data\data_1_master_clean.dta",clear

*** Figure 1 - Estimates of Willingness to Pay for CBDC Attributes
* Model 1 - Baseline Probit
probit choosea dfee dcommercialclaim drbaonly dcommercialonly daustraconly drbaaustrac dcommercialaustrac [pweight=weight]
estimates store model1raw

* Output results in a table
outreg2 using INTERNAL_ONLY/Outputs/Model_1_2, word replace label ctitle("Baseline model") dec(2) stats(coef ci) noaster

* Add average marginal effects to the table
margins, dydx(*) post
outreg2 using INTERNAL_ONLY/Outputs/Model_1_2, word append ctitle ("Average marginal effects") label dec(2)stats(coef ci) noaster

* Generate data for Figure 1 - WTP estimates
eststo: nlcom (wtp_rbaclaim: _b[dcommercialclaim]/_b[dfee]*5) (wtp_austraconly:_b[daustraconly]/_b[dfee]*5)  ///
	(wtp_rbaonly:_b[drbaonly]/_b[dfee]*5) (wtp_commercialonly:_b[dcommercialonly]/_b[dfee]*5)  ///
	(wtp_rbaaustrac:_b[drbaaustrac]/_b[dfee]*5) (wtp_commercialaustrac:_b[dcommercialaustrac]/_b[dfee]*5), level(95) post
esttab using INTERNAL_ONLY/Outputs/Figure_1_Data.csv, ci(3) replace plain
eststo clear

*** Figure 6 - Heterogeneity by income
* Model 2 - Extension Probit with Interactions
probit choosea ///
	dfee dcommercialclaim drbaonly dcommercialonly daustraconly ///
	drbaaustrac dcommercialaustrac ///
	c.age_final_dev_abs#c.dfee c.age_final_dev_abs#c.dcommercialclaim ///
	c.age_final_dev_abs#c.drbaonly c.age_final_dev_abs#c.dcommercialonly ///
	c.age_final_dev_abs#c.daustraconly /// 
	c.age_final_dev_abs#c.drbaaustrac c.age_final_dev_abs#c.dcommercialaustrac ///
	c.hhinc_num_dev_abs#c.dfee c.hhinc_num_dev_abs#c.dcommercialclaim ///
	c.hhinc_num_dev_abs#c.drbaonly c.hhinc_num_dev_abs#c.dcommercialonly ///
	c.hhinc_num_dev_abs#c.daustraconly /// 
	c.hhinc_num_dev_abs#c.drbaaustrac c.hhinc_num_dev_abs#c.dcommercialaustrac ///
	[pweight=weight]
estimates store model2

* Append regression table with Model 2
outreg2 using INTERNAL_ONLY/Outputs/Model_1_2, word append ctitle ("Extension model") label dec(2) stats(coef ci) noaster

* Calculate average marginal effects
margins, dydx(dfee dcommercialclaim drbaonly dcommercialonly daustraconly drbaaustrac dcommercialaustrac) post
outreg2 using INTERNAL_ONLY/Outputs/Model_1_2, word append ctitle ("Average marginal effects") label stats(coef ci) noaster dec(2)

* Generate income points for Figure 6 based on $50k, $100k etc.
* note need to scale down as with underlying demographic variables.
summarize hhinc_num,detail
scalar hhinc_mean=r(mean)
display hhinc_mean

scalar hhinc_1 = (50000-hhinc_mean)/100000
scalar hhinc_2 = (100000-hhinc_mean) /100000
scalar hhinc_3 = (150000-hhinc_mean) /100000
scalar hhinc_4 = (200000-hhinc_mean) /100000
scalar hhinc_5 = (250000-hhinc_mean) /100000

** Figure 6 - WTP Heterogeneity by Income holding age at its mean
* Panel 1 - Income & Safety
estimates restore model2

eststo: nlcom (wtp_safety_inc_1:  5*( ( _b[c.dcommercialclaim] + hhinc_1*_b[c.hhinc_num_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + hhinc_1*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_safety_inc_2:  5*( ( _b[c.dcommercialclaim] + hhinc_2*_b[c.hhinc_num_dev_abs#c.dcommercialclaim] )/(_b[c.dfee] + hhinc_2*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
 (wtp_safety_inc_3:  5*( ( _b[c.dcommercialclaim] + hhinc_3*_b[c.hhinc_num_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + hhinc_3*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ) ///
(wtp_safety_inc_4:  5*( ( _b[c.dcommercialclaim] + hhinc_4*_b[c.hhinc_num_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + hhinc_4*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_safety_inc_5:  5*( ( _b[c.dcommercialclaim] + hhinc_5*_b[c.hhinc_num_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + hhinc_5*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 2 - Income & AUSTRAC Only visibility
estimates restore model2
eststo: nlcom (wtp_inc_austrac_1:  5*( ( _b[c.daustraconly] + hhinc_1*_b[c.hhinc_num_dev_abs#c.daustraconly] )/(_b[c.dfee] + hhinc_1*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_austrac_2:  5*( ( _b[c.daustraconly] + hhinc_2*_b[c.hhinc_num_dev_abs#c.daustraconly]  )/(_b[c.dfee] + hhinc_2*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
  (wtp_inc_austrac_3:  5*( ( _b[c.daustraconly] + hhinc_3*_b[c.hhinc_num_dev_abs#c.daustraconly]  )/(_b[c.dfee] + hhinc_3*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ) ///
(wtp_inc_austrac_4:  5*( ( _b[c.daustraconly] + hhinc_4*_b[c.hhinc_num_dev_abs#c.daustraconly] )/(_b[c.dfee] + hhinc_4*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_austrac_5:  5*( ( _b[c.daustraconly] + hhinc_5*_b[c.hhinc_num_dev_abs#c.daustraconly]  )/(_b[c.dfee] + hhinc_5*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 3 - Income & RBA Only visibility
estimates restore model2
eststo: nlcom (wtp_inc_rba_1:  5*( ( _b[c.drbaonly] + hhinc_1*_b[c.hhinc_num_dev_abs#c.drbaonly] )/(_b[c.dfee] + hhinc_1*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_rba_2:  5*( ( _b[c.drbaonly] + hhinc_2*_b[c.hhinc_num_dev_abs#c.drbaonly]  )/(_b[c.dfee] + hhinc_2*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
  (wtp_inc_rba_3:  5*( ( _b[c.drbaonly] + hhinc_3*_b[c.hhinc_num_dev_abs#c.drbaonly]  )/(_b[c.dfee] + hhinc_3*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ) ///
(wtp_inc_rba_4:  5*( ( _b[c.drbaonly] + hhinc_4*_b[c.hhinc_num_dev_abs#c.drbaonly] )/(_b[c.dfee] + hhinc_4*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_rba_5:  5*( ( _b[c.drbaonly] + hhinc_5*_b[c.hhinc_num_dev_abs#c.drbaonly]  )/(_b[c.dfee] + hhinc_5*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 4 - Income & commercial only visibility
estimates restore model2
eststo: nlcom (wtp_inc_bank_1:  5*( ( _b[c.dcommercialonly] + hhinc_1*_b[c.hhinc_num_dev_abs#c.dcommercialonly] )/(_b[c.dfee] + hhinc_1*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_bank_2:  5*( ( _b[c.dcommercialonly] + hhinc_2*_b[c.hhinc_num_dev_abs#c.dcommercialonly]  )/(_b[c.dfee] + hhinc_2*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
  (wtp_inc_bank_3:  5*( ( _b[c.dcommercialonly] + hhinc_3*_b[c.hhinc_num_dev_abs#c.dcommercialonly]  )/(_b[c.dfee] + hhinc_3*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ) ///
(wtp_inc_bank_4:  5*( ( _b[c.dcommercialonly] + hhinc_4*_b[c.hhinc_num_dev_abs#c.dcommercialonly] )/(_b[c.dfee] + hhinc_4*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_bank_5:  5*( ( _b[c.dcommercialonly] + hhinc_5*_b[c.hhinc_num_dev_abs#c.dcommercialonly]  )/(_b[c.dfee] + hhinc_5*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 5 - Income & RBA AUSTRAC visibility
estimates restore model2
eststo: nlcom (wtp_inc_rba_austrac_1:  5*( ( _b[c.drbaaustrac] + hhinc_1*_b[c.hhinc_num_dev_abs#c.drbaaustrac] )/(_b[c.dfee] + hhinc_1*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_rba_austrac_2:  5*( ( _b[c.drbaaustrac] + hhinc_2*_b[c.hhinc_num_dev_abs#c.drbaaustrac]  )/(_b[c.dfee] + hhinc_2*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
  (wtp_inc_rba_austrac_3:  5*( ( _b[c.drbaaustrac] + hhinc_3*_b[c.hhinc_num_dev_abs#c.drbaaustrac]  )/(_b[c.dfee] + hhinc_3*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ) ///
(wtp_inc_rba_austrac_4:  5*( ( _b[c.drbaaustrac] + hhinc_4*_b[c.hhinc_num_dev_abs#c.drbaaustrac] )/(_b[c.dfee] + hhinc_4*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_rba_austrac_5:  5*( ( _b[c.drbaaustrac] + hhinc_5*_b[c.hhinc_num_dev_abs#c.drbaaustrac]  )/(_b[c.dfee] + hhinc_5*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 6 - Income & Bank AUSTRAC visbility
estimates restore model2
eststo: nlcom (wtp_inc_bank_austrac_1:  5*( ( _b[c.dcommercialaustrac] + hhinc_1*_b[c.hhinc_num_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + hhinc_1*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_bank_austrac_2:  5*( ( _b[c.dcommercialaustrac] + hhinc_2*_b[c.hhinc_num_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + hhinc_2*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
  (wtp_inc_bank_austrac_3:  5*( ( _b[c.dcommercialaustrac] + hhinc_3*_b[c.hhinc_num_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + hhinc_3*_b[c.hhinc_num_dev_abs#c.dfee]) ) ) ///
(wtp_inc_bank_austrac_4:  5*( ( _b[c.dcommercialaustrac] + hhinc_4*_b[c.hhinc_num_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + hhinc_4*_b[c.hhinc_num_dev_abs#c.dfee] ) ) )  ///
(wtp_inc_bank_austrac_5:  5*( ( _b[c.dcommercialaustrac] + hhinc_5*_b[c.hhinc_num_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + hhinc_5*_b[c.hhinc_num_dev_abs#c.dfee] ) ) ), level(95) post

* Export data for Figure 6
esttab using INTERNAL_ONLY/Outputs/Figure_6_Data.csv, ci(3) replace plain
eststo clear

** Figure 5 - WTP Heterogeneity by age holding income at its mean

* Generate age points for Figure 5 based on 20,40,... .
* note need to scale down as with underlying demographic variables.
summarize age_final, detail
scalar agemean=r(mean)
display agemean

scalar age1 = (20-agemean)/10
scalar age2 = (40-agemean)/10
scalar age3 = (60-agemean)/10 
scalar age4 = (80-agemean)/10 
scalar age5 = (100-agemean)/10 

di age1 age2 age3 age4 age5

* Panel 1 - Age & Safety

estimates restore model2
eststo: nlcom (wtp_safety_age_1:  5*( ( _b[c.dcommercialclaim] + age1*_b[c.age_final_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + age1*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_safety_age_2:  5*( ( _b[c.dcommercialclaim] + age2*_b[c.age_final_dev_abs#c.dcommercialclaim] )/(_b[c.dfee] + age2*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
 (wtp_safety_age_3:  5*( ( _b[c.dcommercialclaim] + age3*_b[c.age_final_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + age3*_b[c.age_final_dev_abs#c.dfee] ) ) ) ///
(wtp_safety_age_4:  5*( ( _b[c.dcommercialclaim] + age4*_b[c.age_final_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + age4*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_safety_age_5:  5*( ( _b[c.dcommercialclaim] + age5*_b[c.age_final_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + age5*_b[c.age_final_dev_abs#c.dfee] ) ) ), level(95) post


* Panel 2 - Age & AUSTRAC Only visibility
estimates restore model2
eststo: nlcom (wtp_age_austrac_1:  5*( ( _b[c.daustraconly] + age1*_b[c.age_final_dev_abs#c.daustraconly] )/(_b[c.dfee] + age1*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_austrac_2:  5*( ( _b[c.daustraconly] + age2*_b[c.age_final_dev_abs#c.daustraconly]  )/(_b[c.dfee] + age2*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
  (wtp_age_austrac_3:  5*( ( _b[c.daustraconly] + age3*_b[c.age_final_dev_abs#c.daustraconly]  )/(_b[c.dfee] + age3*_b[c.age_final_dev_abs#c.dfee] ) ) ) ///
(wtp_age_austrac_4:  5*( ( _b[c.daustraconly] + age4*_b[c.age_final_dev_abs#c.daustraconly] )/(_b[c.dfee] + age4*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_austrac_5:  5*( ( _b[c.daustraconly] + age5*_b[c.age_final_dev_abs#c.daustraconly]  )/(_b[c.dfee] + age5*_b[c.age_final_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 3 - Age & RBA Only visibility
estimates restore model2
eststo: nlcom (wtp_age_rba_1:  5*( ( _b[c.drbaonly] + age1*_b[c.age_final_dev_abs#c.drbaonly] )/(_b[c.dfee] + age1*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_rba_2:  5*( ( _b[c.drbaonly] + age2*_b[c.age_final_dev_abs#c.drbaonly]  )/(_b[c.dfee] + age2*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
  (wtp_age_rba_3:  5*( ( _b[c.drbaonly] + age3*_b[c.age_final_dev_abs#c.drbaonly]  )/(_b[c.dfee] + age3*_b[c.age_final_dev_abs#c.dfee] ) ) ) ///
(wtp_age_rba_4:  5*( ( _b[c.drbaonly] + age4*_b[c.age_final_dev_abs#c.drbaonly] )/(_b[c.dfee] + age4*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_rba_5:  5*( ( _b[c.drbaonly] + age5*_b[c.age_final_dev_abs#c.drbaonly]  )/(_b[c.dfee] + age5*_b[c.age_final_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 4 - Age & commercial only visibility
estimates restore model2
eststo: nlcom (wtp_age_bank_1:  5*( ( _b[c.dcommercialonly] + age1*_b[c.age_final_dev_abs#c.dcommercialonly] )/(_b[c.dfee] + age1*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_bank_2:  5*( ( _b[c.dcommercialonly] + age2*_b[c.age_final_dev_abs#c.dcommercialonly]  )/(_b[c.dfee] + age2*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
  (wtp_age_bank_3:  5*( ( _b[c.dcommercialonly] + age3*_b[c.age_final_dev_abs#c.dcommercialonly]  )/(_b[c.dfee] + age3*_b[c.age_final_dev_abs#c.dfee] ) ) ) ///
(wtp_age_bank_4:  5*( ( _b[c.dcommercialonly] + age4*_b[c.age_final_dev_abs#c.dcommercialonly] )/(_b[c.dfee] + age4*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_bank_5:  5*( ( _b[c.dcommercialonly] + age5*_b[c.age_final_dev_abs#c.dcommercialonly]  )/(_b[c.dfee] + age5*_b[c.age_final_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 5 - Age & RBA AUSTRAC visibility
estimates restore model2
eststo: nlcom (wtp_age_rba_austrac_1:  5*( ( _b[c.drbaaustrac] + age1*_b[c.age_final_dev_abs#c.drbaaustrac] )/(_b[c.dfee] + age1*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_rba_austrac_2:  5*( ( _b[c.drbaaustrac] + age2*_b[c.age_final_dev_abs#c.drbaaustrac]  )/(_b[c.dfee] + age2*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
  (wtp_age_rba_austrac_3:  5*( ( _b[c.drbaaustrac] + age3*_b[c.age_final_dev_abs#c.drbaaustrac]  )/(_b[c.dfee] + age3*_b[c.age_final_dev_abs#c.dfee] ) ) ) ///
(wtp_age_rba_austrac_4:  5*( ( _b[c.drbaaustrac] + age4*_b[c.age_final_dev_abs#c.drbaaustrac] )/(_b[c.dfee] + age4*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_rba_austrac_5:  5*( ( _b[c.drbaaustrac] + age5*_b[c.age_final_dev_abs#c.drbaaustrac]  )/(_b[c.dfee] + age5*_b[c.age_final_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 6 - Age & Bank AUSTRAC visibility
estimates restore model2
eststo: nlcom (wtp_age_bank_austrac_1:  5*( ( _b[c.dcommercialaustrac] + age1*_b[c.age_final_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + age1*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_bank_austrac_2:  5*( ( _b[c.dcommercialaustrac] + age2*_b[c.age_final_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + age2*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
  (wtp_age_bank_austrac_3:  5*( ( _b[c.dcommercialaustrac] + age3*_b[c.age_final_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + age3*_b[c.age_final_dev_abs#c.dfee]) ) ) ///
(wtp_age_bank_austrac_4:  5*( ( _b[c.dcommercialaustrac] + age4*_b[c.age_final_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + age4*_b[c.age_final_dev_abs#c.dfee] ) ) )  ///
(wtp_age_bank_austrac_5:  5*( ( _b[c.dcommercialaustrac] + age5*_b[c.age_final_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + age5*_b[c.age_final_dev_abs#c.dfee] ) ) ), level(95) post

* Export data for Figure 5
esttab using INTERNAL_ONLY/Outputs/Figure_5_Data.csv, ci(3) replace plain
eststo clear

*** Quartile model for Online Appendix
probit choosea ///
	dfee drbaclaim drbaonly dcommercialonly ///
	daustraconly drbaaustrac dcommercialaustrac ///
	i.age_quartile#c.dfee i.age_quartile#c.drbaclaim ///
	i.age_quartile#c.drbaonly i.age_quartile#c.dcommercialonly ///
	i.age_quartile#c.daustraconly /// 
	i.age_quartile#c.drbaaustrac i.age_quartile#c.dcommercialaustrac ///
	i.hhincq_final#c.dfee i.hhincq_final#c.drbaclaim ///
	i.hhincq_final#c.drbaonly i.hhincq_final#c.dcommercialonly ///
	i.hhincq_final#c.daustraconly /// 
	i.hhincq_final#c.drbaaustrac i.hhincq_final#c.dcommercialaustrac ///
	[pweight=weight]

* Output results to a table
outreg2 using INTERNAL_ONLY/Outputs/Model_Appendix, word replace label ctitle("Quartile model") dec(2) stats(coef ci) noaster


** Figure 7 - WTP Heterogeneity by cash use
* Model 4 - Extension Probit with Interactions
probit choosea ///
	dfee dcommercialclaim drbaonly dcommercialonly daustraconly ///
	drbaaustrac dcommercialaustrac ///
	c.cash_share_dev_abs#c.dfee c.cash_share_dev_abs#c.dcommercialclaim ///
	c.cash_share_dev_abs#c.drbaonly c.cash_share_dev_abs#c.dcommercialonly ///
	c.cash_share_dev_abs#c.daustraconly /// 
	c.cash_share_dev_abs#c.drbaaustrac c.cash_share_dev_abs#c.dcommercialaustrac ///
	[pweight=weight]
estimates store model4

* Append regression table with new table
outreg2 using INTERNAL_ONLY/Outputs/Model_1_4, word replace ctitle ("Cash use model") label dec(5) stats(coef ci) noaster

* Calculate average marginal effects
margins, dydx(dfee dcommercialclaim drbaonly dcommercialonly daustraconly drbaaustrac dcommercialaustrac) post
outreg2 using INTERNAL_ONLY/Outputs/Model_1_4, word append ctitle ("Average marginal effects") label stats(coef ci) noaster dec(2)

* Generate cash use points for graph 
summarize cash_payments_share_number, detail
scalar cashmean=r(mean)
display cashmean

scalar cash1 = (0-cashmean)
scalar cash2 = (25-cashmean)
scalar cash3 = (50-cashmean)
scalar cash4 = (75-cashmean)
scalar cash5 = (100-cashmean) 

di cash1 
di cash2 
di cash3
di cash4
di cash5

* Panel 1 - Cash Use & Safety

estimates restore model4
eststo: nlcom (wtp_cash_safety_1:  5*( ( _b[c.dcommercialclaim] + cash1*_b[c.cash_share_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + cash1*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_safety_2:  5*( ( _b[c.dcommercialclaim] + cash2*_b[c.cash_share_dev_abs#c.dcommercialclaim] )/(_b[c.dfee] + cash2*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
 (wtp_cash_safety_3:  5*( ( _b[c.dcommercialclaim] + cash3*_b[c.cash_share_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + cash3*_b[c.cash_share_dev_abs#c.dfee] ) ) ) ///
(wtp_cash_safety_4:  5*( ( _b[c.dcommercialclaim] + cash4*_b[c.cash_share_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + cash4*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_safety_5:  5*( ( _b[c.dcommercialclaim] + cash5*_b[c.cash_share_dev_abs#c.dcommercialclaim]  )/(_b[c.dfee] + cash5*_b[c.cash_share_dev_abs#c.dfee] ) ) ), level(95) post


* Panel 2 - Cash Use & AUSTRAC Only visibility
estimates restore model4
eststo: nlcom (wtp_cash_austrac_1:  5*( ( _b[c.daustraconly] + cash1*_b[c.cash_share_dev_abs#c.daustraconly] )/(_b[c.dfee] + cash1*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_austrac_2:  5*( ( _b[c.daustraconly] + cash2*_b[c.cash_share_dev_abs#c.daustraconly]  )/(_b[c.dfee] + cash2*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
  (wtp_cash_austrac_3:  5*( ( _b[c.daustraconly] + cash3*_b[c.cash_share_dev_abs#c.daustraconly]  )/(_b[c.dfee] + cash3*_b[c.cash_share_dev_abs#c.dfee] ) ) ) ///
(wtp_cash_austrac_4:  5*( ( _b[c.daustraconly] + cash4*_b[c.cash_share_dev_abs#c.daustraconly] )/(_b[c.dfee] + cash4*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_austrac_5:  5*( ( _b[c.daustraconly] + cash5*_b[c.cash_share_dev_abs#c.daustraconly]  )/(_b[c.dfee] + cash5*_b[c.cash_share_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 3 - Cash Use & RBA Only visibility
estimates restore model4
eststo: nlcom (wtp_cash_rba_1:  5*( ( _b[c.drbaonly] + cash1*_b[c.cash_share_dev_abs#c.drbaonly] )/(_b[c.dfee] + cash1*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_rba_2:  5*( ( _b[c.drbaonly] + cash2*_b[c.cash_share_dev_abs#c.drbaonly]  )/(_b[c.dfee] + cash2*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
  (wtp_cash_rba_3:  5*( ( _b[c.drbaonly] + cash3*_b[c.cash_share_dev_abs#c.drbaonly]  )/(_b[c.dfee] + cash3*_b[c.cash_share_dev_abs#c.dfee] ) ) ) ///
(wtp_cash_rba_4:  5*( ( _b[c.drbaonly] + cash4*_b[c.cash_share_dev_abs#c.drbaonly] )/(_b[c.dfee] + cash4*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_rba_5:  5*( ( _b[c.drbaonly] + cash5*_b[c.cash_share_dev_abs#c.drbaonly]  )/(_b[c.dfee] + cash5*_b[c.cash_share_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 4 - Cash Use & commercial only visibility
estimates restore model4
eststo: nlcom (wtp_cash_bank_1:  5*( ( _b[c.dcommercialonly] + cash1*_b[c.cash_share_dev_abs#c.dcommercialonly] )/(_b[c.dfee] + cash1*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_bank_2:  5*( ( _b[c.dcommercialonly] + cash2*_b[c.cash_share_dev_abs#c.dcommercialonly]  )/(_b[c.dfee] + cash2*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
  (wtp_cash_bank_3:  5*( ( _b[c.dcommercialonly] + cash3*_b[c.cash_share_dev_abs#c.dcommercialonly]  )/(_b[c.dfee] + cash3*_b[c.cash_share_dev_abs#c.dfee] ) ) ) ///
(wtp_cash_bank_4:  5*( ( _b[c.dcommercialonly] + cash4*_b[c.cash_share_dev_abs#c.dcommercialonly] )/(_b[c.dfee] + cash4*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_bank_5:  5*( ( _b[c.dcommercialonly] + cash5*_b[c.cash_share_dev_abs#c.dcommercialonly]  )/(_b[c.dfee] + cash5*_b[c.cash_share_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 5 - Cash Use & RBA AUSTRAC visibility
estimates restore model4
eststo: nlcom (wtp_cash_rba_austrac_1:  5*( ( _b[c.drbaaustrac] + cash1*_b[c.cash_share_dev_abs#c.drbaaustrac] )/(_b[c.dfee] + cash1*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_rba_austrac_2:  5*( ( _b[c.drbaaustrac] + cash2*_b[c.cash_share_dev_abs#c.drbaaustrac]  )/(_b[c.dfee] + cash2*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
  (wtp_cash_rba_austrac_3:  5*( ( _b[c.drbaaustrac] + cash3*_b[c.cash_share_dev_abs#c.drbaaustrac]  )/(_b[c.dfee] + cash3*_b[c.cash_share_dev_abs#c.dfee] ) ) ) ///
(wtp_cash_rba_austrac_4:  5*( ( _b[c.drbaaustrac] + cash4*_b[c.cash_share_dev_abs#c.drbaaustrac] )/(_b[c.dfee] + cash4*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_rba_austrac_5:  5*( ( _b[c.drbaaustrac] + cash5*_b[c.cash_share_dev_abs#c.drbaaustrac]  )/(_b[c.dfee] + cash5*_b[c.cash_share_dev_abs#c.dfee] ) ) ), level(95) post

* Panel 6 - Cash Use & Bank AUSTRAC visibility
estimates restore model4
eststo: nlcom (wtp_cash_bank_austrac_1:  5*( ( _b[c.dcommercialaustrac] + cash1*_b[c.cash_share_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + cash1*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_bank_austrac_2:  5*( ( _b[c.dcommercialaustrac] + cash2*_b[c.cash_share_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + cash2*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
  (wtp_cash_bank_austrac_3:  5*( ( _b[c.dcommercialaustrac] + cash3*_b[c.cash_share_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + cash3*_b[c.cash_share_dev_abs#c.dfee]) ) ) ///
(wtp_cash_bank_austrac_4:  5*( ( _b[c.dcommercialaustrac] + cash4*_b[c.cash_share_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + cash4*_b[c.cash_share_dev_abs#c.dfee] ) ) )  ///
(wtp_cash_bank_austrac_5:  5*( ( _b[c.dcommercialaustrac] + cash5*_b[c.cash_share_dev_abs#c.dcommercialaustrac]  )/(_b[c.dfee] + cash5*_b[c.cash_share_dev_abs#c.dfee] ) ) ), level(95) post

* Export data for Figure 7
esttab using INTERNAL_ONLY/Outputs/Figure_7_Data.csv, ci(3) replace plain
eststo clear

