/*
# RDP : Demand in the Repo Market: Indirect Perspectives from Open Market Operations from 2006 to 2020
#
# Chris Becker, Anny Francis, Calebe de Roure and Brendan Wilson
#
*/

* 1 - Calculating cut-off rates
*-------------------------------------------------------------------------------
clear

*import data (deleted)

*aggregate all bids by spread_to_ois in a given day
collapse(sum) cash_approach cash_dealt, by (date term spread_to_ois)

*sort
gsort date term -spread_to_ois

*sum bids and amount dealt for each date and term
by date term: gen cum_bid   = sum(cash_approach)  
by date term: gen cum_dealt = sum(cash_dealt)
by date term: egen max_dealt = max(cum_dealt)

*drop unfilled bids
drop if cash_dealt == 0
drop if cum_dealt != max_dealt

gen qtr = qofd(date)
format %tq qtr

*Creates time series of cut-off rates
collapse(mean) spread_to_ois, by(qtr)


* 2 -  Estimatng elasticity by quarter
*-------------------------------------------------------------------------------
clear

*import data (deleted)

*aggregate all bids by spread_to_ois in a given day
collapse(sum) cash_approach cash_dealt, by(yield spread_to_ois date term)
		
*sort date term yield       
gsort date term -yield        
bysort date term: gen cbf=sum(cash_approach)  
bysort date term: gen cum_cash_dealt=sum(cash_dealt)   
        
gen quantity=ln(cbf*1000000)

*insert the dates for relevant time period here
preserve
drop if date>td(31mar2020)
drop if date<td(1jan2020)
sum cbf spread quant

reghdfe quantity spread_to_ois, absorb(date term) vce(cluster date) 
restore

*Note: to calculate elasticity at the mean cut-off rate, multiply the regression coefficient with the mean cut-off rate for the period.

