*-----------------------------------------------------------------------------------------------------*
*LEVEL APPROACH: 1/estimate coefficient, 2/use 'corrected' revenue share to back out markup by i
*correction is based on estimate of measurement error, /epsilon in our framework.
*VALUE ADDED PF FRAMEWORK: implies that markup is computed of beta_l 
*----------------------------------------------------------------------------------------------------*




program DLW, rclass
	syntax varlist(numeric min=1 max=1) [if] [in], phi(varlist numeric min=1) phi_lag(varlist numeric min=1) /*
	*/ endo_var(varlist numeric min=1) endo_var_lag(varlist numeric min=1) instr(varlist numeric min=1) /*
	*/ start(numlist) [ exits(varlist numeric) ]
	
	display "`varlist'"
	display "`phi'"
	display "`phi_lag'"
	display "`endo_var'"
	display "`endo_var_lag'"
	display "`instr'"
	display "`start'"
	display "`exits'"
	


		
	
	foreach x in `start' {
		matrix B = (nullmat(B), `x')
	}
	
		
	
	matrix list B
	
	global DEP `varlist'
	global PHI `phi'
	global PHI_LAG `phi_lag'
	global ENDO `endo_var'
	global ENDO_LAG `endo_var_lag'
	global INSTR `instr'
	global START `start'
	global PR_HAT `exits'
	
	
	if "`exits'" == ""{
	display "NO"
		global PR_HAT "NONE"
		}
 
 
display "$PR_HAT"
	
	
	
	clear mata

	preserve 
	sort firmid fyear
	mata: DLW()
	
	matrix drop B
	macro drop DEP PHI PHI_LAG ENDO ENDO_LAG INSTR START PR_HAT
	end



*-------------------------------------BEGIN MATA PROGRAM--------------------------------------------*
mata:
void GMM_DLW(todo,betas,crit,g,H)
{
	PHI=st_data(.,st_global("PHI"))
    PHI_LAG=st_data(.,st_global("PHI_LAG"))
    Z=st_data(.,st_global("INSTR"))
    X=st_data(.,st_global("ENDO"))
    X_lag=st_data(.,st_global("ENDO_LAG"))
    Y=st_data(.,st_global("DEP"))
    C=st_data(.,("const"))

	W = invsym(Z'Z)/(rows(Z))
	
	OMEGA=PHI-X*betas'
	OMEGA_lag=PHI_LAG-X_lag*betas'

	OMEGA_lag_2 = OMEGA_lag:*OMEGA_lag
	OMEGA_lag_3 = OMEGA_lag_2:*OMEGA_lag
	
	if (st_global("PR_HAT") == "NONE"){

		OMEGA_lag_pol=(C,OMEGA_lag, OMEGA_lag_2, OMEGA_lag_3)
/*
		OMEGA_lag_pol=(C,OMEGA_lag)
*/	
}
	else {
		PR_HAT = st_data(.,st_global("PR_HAT"))
		PR_HAT2 = PR_HAT:*PR_HAT
		PR_HAT3 = PR_HAT2:*PR_HAT
		OMEGA_lag_pol=(C,OMEGA_lag, OMEGA_lag_2, OMEGA_lag_3, PR_HAT, PR_HAT2, PR_HAT3)
		}
		
	g_b = invsym(OMEGA_lag_pol'OMEGA_lag_pol)*OMEGA_lag_pol'OMEGA
	XI=OMEGA-OMEGA_lag_pol*g_b
/*
	crit=(Z'XI)'(Z'XI)
*/
	
	crit=(Z'XI)'*W*(Z'XI)

}
;


void DLW()
	{
	delta = 0.05, 0.05, 0.05
S=optimize_init()
optimize_init_evaluator(S, &GMM_DLW())
optimize_init_evaluatortype(S,"d0")
optimize_init_technique(S, "nm")
optimize_init_nmsimplexdeltas(S, delta)
optimize_init_which(S,"min")
optimize_init_params(S,(st_matrix("B")))
p=optimize(S) 
p 
st_matrix("beta_dlw",p) 
}

end
*-----------------------------------------END MATA PROGRAM---------------------------------------*

*------------------------------------------------------------------------------------------------*
