function [EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_fc(data,sample,learn_vars,bound,estim_sample_end)

% Prepare data
dates = data.date;
var_names = data.Properties.VariableNames(2:end);
data_mat = data{:,2:end};

% Sample indices
sample_start = find(dates == sample(1));
sample_end = find(dates == sample(end));
i_sample = sample_start:sample_end;

i_estim_end = find(dates == estim_sample_end) - sample_start + 1;

dummy_start = -4 + find(dates(i_sample) == "31-Dec-2008");

% Get consumer and RBA expectations
Y = data_mat(i_sample, strcmp(var_names, "cons_exp")) - 2.5;
Y = [Y, data_mat(i_sample, strcmp(var_names, "rba_exp")) - 2.5];

% Get learners' variables
for i_learn = 1:length(learn_vars)
    learn_var = learn_vars{i_learn};
    Y_learn = data_mat(i_sample, strcmp(var_names, learn_var));
    if learn_var == "CPI" % Could just demean as well? Unsure whether it should matter
        Y_learn = Y_learn - 2.5;
    elseif (learn_var ~= "IR") && (learn_var ~= "housing_lending")
        Y_learn = Y_learn - mean(Y_learn(4:end-1));
    end
    Y = [Y, Y_learn];
end

% Set up initial values and bounds for parameters
theta0 = [0.2,0.1/length(learn_vars)*ones(1,length(learn_vars)),mean(Y(1:end-1,1), "omitmissing"),0,0.3,0.1];
%theta0 = theta0 / sqrt(sum(theta0.^2));
if bound
    lb = [zeros(1, 1+length(learn_vars)), -inf, -inf, 0, 0];
    ub = [ones(1, 1+length(learn_vars)), inf, inf, inf, inf];
else
    lb = [-inf*ones(1, 1+length(learn_vars)), -inf, -inf, 0, 0];
    ub = inf * ones(1, 5+length(learn_vars));
end

Y_init = Y(1:4,:);
mdl = ssm(@(theta) ParamFun_constparam_gfcdummy(theta,Y(5:end,:),Y_init,dummy_start));
Options = optimoptions(@fminunc, 'FiniteDifferenceType', 'central', 'OptimalityTolerance', 1e-6);
[EstMdl,estParams,EstParamCov,logL,Output] = estimate(mdl, ...
    Y(5:i_estim_end,1), ...
    theta0, ...
    'lb', lb, ...
    'ub', ub, ...
    'CovMethod', 'sandwich');

% [EstMdl,estParams,EstParamCov,logL,Output] = estimate(mdl, ...
%     Y(5:end-9,1), ...
%     theta0, ...
%     'lb', lb, ...
%     'ub', ub, ...
%     'CovMethod', 'sandwich');

end