
**************************** 1. SET UP *********************************
**************************** DATE: OCTOBER 2024 ********************************
**************************** AUTHORS: Anthony Brassil, Yahdullah Haidari, Jonathan Hambur, Gulnara Nolan and Callum Ryan *******************************

* Housekeeping
clear all
set more off

global data ""
use "$data\Unit data (not for release)\dataMI Unit Record Data Raw.dta"

*The codes below rename some of the relevant questions and create the variables of interest 

* Renaming questions 
rename Q13d postcode
rename Q1 gender
rename Q2 age1
rename Q2x age2 //age question changed from April 2020
rename Q4 educ
rename Q5 vote
rename Q7 homeown
rename Q9a emp_cond
rename Q11 hincome
rename Q3 occupation
rename Q1a cfinance
rename Q2a ffinance
rename Q3a ecocond12m
rename Q4a ecocond5y
rename Q5a buyingintent
rename Q1c1 buydwelling


egen age = rowmax(age1 age2) //combining the two age questions 


* Set up dataset as survey data to use weights
svyset [pw=Weight]

*create an ID variable for quarterly frequency 

gen qr=.
replace qr=1 if month==1 | month==2 | month==3
replace qr=2 if month==4 | month==5 | month==6
replace qr=3 if month==7 | month==8 | month==9
replace qr=4 if month==10 | month==11 | month==12


drop ID 
tostring year qr, replace
tostring month, format(%02.0f) replace
gen ID=year+qr
destring year qr ID, replace 

* Creating year-ahead inflation expectation variable (exp)

gen exp = .
*Positives
replace exp = Q11a1 if Q10a == 1
replace exp = . 	if Q10a == 1 & Q11a1 == 0
replace exp = . 	if Q10a == 1 & Q11a1 == .
replace exp = . 	if Q10a == 1 & Q11a1 == -1
*Negatives
replace exp = -Q11a2 	if Q10a == 2
replace exp = . 		if Q10a == 2 & Q11a2 == 0
replace exp = . 		if Q10a == 2 & Q11a2 == .
replace exp = . 		if Q10a == 2 & Q11a2 == -1
*Zeros
replace exp = 0 		if Q10a == 3 


* Inflation perceptions (infp)
//for question from oct 2000 onward
gen infp1 = . 
*Positives
replace infp1 = Q2ienn  if Q1ie == 1
replace infp1 = . 	if Q1ie == 1 & Q2ienn == 0 
replace infp1 = . 	if Q1ie == 1 & Q2ienn == . 
replace infp1 = . 	if Q1ie == 1 & Q2ienn <= -1
*Negatives
replace infp1 = -Q3ienn 	if Q1ie == 2
replace infp1 = . 		if Q1ie == 2 & Q3ienn == 0
replace infp1 = . 		if Q1ie == 2 & Q3ienn == .
replace infp1 = . 		if Q1ie == 2 & Q3ienn <= -1
*Zeros
replace infp1 = 0 		if Q1ie == 3 

//for question before oct 2000
gen infp2=. 
replace infp2 = Q2ien if Q1ie == 1 
replace infp2 = . 	if Q1ie == 1 & Q2ien == 0
replace infp2 = . 	if Q1ie == 1 & Q2ien == .
replace infp2 = . 	if Q1ie == 1 & Q2ien <= -1

replace infp2 = -Q3ien 	if Q1ie == 2
replace infp2 = . 		if Q1ie == 2 & Q3ien == 0
replace infp2 = . 		if Q1ie == 2 & Q3ien == .
replace infp2 = . 		if Q1ie == 2 & Q3ien <= -1
*Zeros
replace infp2 = 0 		if Q1ie == 3 

egen infp = rowmax(infp1 infp2) //combining the two inflation perceptions questions 


* Creating wages expectations variable (wexp)
gen wexp = .
*Positives
replace wexp = Q13a1 if Q12a == 1
replace wexp = . 	if Q12a == 1 & Q13a1 == 0
replace wexp = . 	if Q12a == 1 & Q13a1 == .
*Negatives
replace wexp = -Q13a1 	if Q12a == 2
replace wexp = . 		if Q12a == 2 & Q13a1 == 0
replace wexp = . 		if Q12a == 2 & Q13a1 == .
*Zeros
replace wexp = 0 		if Q12a == 3 


* Clean up rogue responses
replace Weight = . if Weight == -1
replace occupation = . if occupation == -1


* Create ID numbers for cross-sections
gen flag = 1
egen obs = total(flag), by (ID)
egen IDN = group(ID)
drop flag


* replacing responses below -50 and above 50
replace exp = . if exp>50
replace exp = . if exp<-50
replace wexp = . if wexp>50
replace wexp = . if wexp<-50
replace infp = . if infp>50
replace infp = . if infp<-50

* creating inflation expectations variable excluding round responses 

gen exp_uncertain = exp if inlist(exp,-50,-45,-40,-35,-30,-25,-20,-15,-10,-5,5,10,15,20,25,30,35,40,45,50) 

gen exp_certain=exp if exp_uncertain==.


* Creating wages expectations variable exluding zero responses 
gen wexz = wexp
replace wexz =. if wexp==0


******************************************
*		DUMMY VARIABLES FOR DEMOGRAPHICS
******************************************
*Generate zero values for dummies
gen dum_male = 0
gen dum_female = 0
gen dum_18_24 = 0
gen dum_25_34 = 0
gen dum_35_44 = 0
gen dum_45_54 = 0
gen dum_55_64 = 0
gen dum_over65 = 0
gen dum_18_34 = 0
gen dum_45_64 = 0

gen dum_primary = 0
gen dum_year10 = 0
gen dum_secondary = 0
gen dum_cert = 0
gen dum_trade = 0
gen dum_tertiary = 0
gen dum_postgrad = 0
gen dum_nonsecondary = 0
gen dum_vocation = 0
gen dum_uni = 0

gen dum_20K = 0
gen dum_21K_30K = 0
gen dum_31K_40K = 0
gen dum_41K_50K = 0
gen dum_51K_60K = 0
gen dum_61K_70K = 0
gen dum_71K_80K = 0
gen dum_81K_90K = 0
gen dum_91K_100K = 0
gen dum_100K = 0
gen dum_incref = 0
gen dum_30K = 0
gen dum_31K_70K = 0
gen dum_71K_100K = 0
gen dum_31K_80K = 0
gen dum_81K_100K = 0

gen dum_lib = 0
gen dum_alp = 0
gen dum_nat = 0
gen dum_grn = 0
gen dum_ind = 0
gen dum_swing = 0
gen dum_rent = 0
gen dum_mortgage = 0
gen dum_outright = 0
gen dum_homeother = 0

gen dum_city = 0
gen dum_regional = 0

gen dum_managers = 0
gen dum_prof = 0
gen dum_paraprof = 0
gen dum_trades = 0
gen dum_clerks = 0
gen dum_salespersons = 0
gen dum_plants = 0
gen dum_labourers =0 
gen dum_retired =0
gen dum_unemploymed = 0
gen dum_community = 0
gen dum_occrefused = 0 

gen dum_unempmore  = 0
gen dum_unempsame = 0
gen dum_unempless = 0
gen dum_unempdontknow = 0 

gen dum_cfbetter = 0 
gen dum_cfsame = 0
gen dum_cfworse = 0
gen dum_cfuncertain = 0

gen dum_ffbetter =0 
gen dum_ffsame =0
gen dum_ffworse =0
gen dum_ffuncertain =0

gen dum_eco12mgood = 0 
gen dum_eco12mmix = 0
gen dum_eco12mbad = 0
gen dum_eco12muncertain = 0

gen dum_eco5ygood = 0 
gen dum_eco5ymix = 0
gen dum_eco5ybad = 0
gen dum_eco5yuncertain = 0

gen dum_buytimegood = 0
gen dum_buytimemix =0
gen dum_buytimebad =0
gen dum_buytimeuncertain =0



* Replace zero with missing data if non-response
replace dum_male = . if gender == .
replace dum_female = . if gender == .
replace dum_18_24 = . if age == .
replace dum_25_34 = . if age == .
replace dum_35_44 = . if age == .
replace dum_45_54 = . if age == .
replace dum_55_64 = . if age == .
replace dum_over65 = . if age == .
replace dum_18_34 = . if age == .
*replace dum_35_44 = . if age == .
replace dum_45_64 = . if age == .
replace dum_primary = . if educ == .
replace dum_year10 = . if educ == .
replace dum_secondary = . if educ == .
replace dum_cert = . if educ == .
replace dum_trade = . if educ == .
replace dum_tertiary = . if educ == .
replace dum_postgrad = . if educ == .
replace dum_nonsecondary = . if educ == .
replace dum_vocation = . if educ == .
replace dum_uni = . if educ == .
replace dum_20K = . if hincome == .
replace dum_21K_30K = . if hincome == .
replace dum_31K_40K = . if hincome == .
replace dum_41K_50K = . if hincome == .
replace dum_51K_60K = . if hincome == .
replace dum_61K_70K = . if hincome == .
replace dum_71K_80K = . if hincome == .
replace dum_81K_90K = . if hincome == .
replace dum_91K_100K = . if hincome == .
replace dum_100K = . if hincome == .
replace dum_incref = . if hincome == .
replace dum_30K = . if hincome == .
replace dum_31K_70K = . if hincome == .
replace dum_71K_100K = . if hincome == .
replace dum_31K_80K = . if hincome == .
replace dum_81K_100K = . if hincome == .
replace dum_lib = . if vote == .
replace dum_alp = . if vote == .
replace dum_nat = . if vote == .
replace dum_grn = . if vote == .
replace dum_ind = . if vote == .
replace dum_swing = . if vote == .
replace dum_rent = . if homeown == .
replace dum_mortgage = . if homeown == .
replace dum_outright = . if homeown == .
replace dum_homeother = . if homeown == .
replace dum_city = . if postcode == .
replace dum_regional = . if postcode == .


replace dum_unempmore  = . if emp_cond == . 
replace dum_unempsame = . if emp_cond == . 
replace dum_unempless = . if emp_cond == . 
replace dum_unempdontknow = . if emp_cond == . 

*occupation 
replace dum_managers = . if occupation == . 
replace dum_prof = . if occupation == . 
replace dum_paraprof = . if occupation == . 
replace dum_trades = . if occupation == . 
replace dum_clerks = . if occupation == . 
replace dum_salespersons = . if occupation == . 
replace dum_plants = . if occupation == . 
replace dum_labourers = . if occupation == . 
replace dum_retired = . if occupation == . 
replace dum_unemploymed =  . if occupation == . 
replace dum_community = . if occupation == . 
replace dum_occrefused = . if occupation == . 

replace dum_cfbetter = . if  cfinance == . //cf stands for current financial situation
replace dum_cfsame = . if  cfinance == .
replace dum_cfworse = . if  cfinance == .
replace dum_cfuncertain = . if  cfinance == .

replace dum_ffbetter = . if ffinance == . //ff stands for future financial situation 
replace dum_ffsame = . if ffinance == .
replace dum_ffworse = . if ffinance == .
replace dum_ffuncertain = . if ffinance == .

replace dum_eco12mgood = . if ecocond12m == . //expect good economic conditions in the next 12 months 
replace dum_eco12mmix = . if ecocond12m == .
replace dum_eco12mbad = . if ecocond12m == .
replace dum_eco12muncertain = . if ecocond12m == .

replace dum_eco5ygood = . if ecocond5y ==. //expects continous good economic conditions for the next 5 years
replace dum_eco5ymix = . if ecocond5y ==.
replace dum_eco5ybad = . if ecocond5y ==.
replace dum_eco5yuncertain = . if ecocond5y ==.

replace dum_buytimegood = . if buyingintent ==. 
replace dum_buytimemix = . if buyingintent ==. 
replace dum_buytimebad = . if buyingintent ==. 
replace dum_buytimeuncertain = . if buyingintent ==. 


* Apply ONES for relevant groups
*Gender
replace dum_male = 1 if gender == 1
replace dum_female = 1 if gender == 2
*Age
replace dum_18_24 = 1 if age == 1
replace dum_25_34 = 1 if age == 2
replace dum_35_44 = 1 if age == 3
replace dum_45_54 = 1 if age == 4 | age == 5
replace dum_55_64 = 1 if age == 6
replace dum_over65 = 1 if age == 7 | age ==8
replace dum_18_34 = 1 if age == 1 | age == 2
*replace dum_35_44 = 1 if age == 3 
replace dum_45_64 = 1 if age == 4 | age == 5 | age == 6
*Education
replace dum_primary = 1 if educ == 1
replace dum_year10 = 1 if educ == 2 & ID_m<20209
replace dum_year10 = 1 if educ == 3 & ID_m>=20209
replace dum_secondary = 1 if educ == 3 & ID_m<20209
replace dum_secondary = 1 if educ == 4 & ID_m>=20209

replace dum_cert = 1 if educ == 4 & ID_m<20209
replace dum_cert = 1 if educ == 5 & ID_m>=20209

replace dum_trade = 1 if  educ == 5 & ID_m<20209
replace dum_trade = 1 if educ == 6 & ID_m >=20209

replace dum_tertiary = 1 if educ == 7
replace dum_postgrad = 1 if educ == 8
replace dum_postgrad = 1 if educ == 9 & ID_m >=20209 

replace dum_nonsecondary = 1 if educ == 1 | educ == 2
replace dum_nonsecondary = 1 if educ == 3 & ID_m>=20209
replace dum_vocation = 1 if educ == 4 | educ == 5 & ID_m<20209
replace dum_vocation = 1 if educ == 5 | educ == 6 & ID_m>=20209
replace dum_uni = 1 if educ == 7 | educ == 8
replace dum_uni = 1 if educ == 9 & ID_m >=20209
*Household income
replace dum_20K = 1 if hincome == 1
replace dum_21K_30K = 1 if hincome == 2
replace dum_31K_40K = 1 if hincome == 3
replace dum_41K_50K = 1 if hincome == 4
replace dum_51K_60K = 1 if hincome == 5
replace dum_61K_70K = 1 if hincome == 6
replace dum_71K_80K = 1 if hincome == 7
replace dum_81K_90K = 1 if hincome == 8
replace dum_91K_100K = 1 if hincome == 9
replace dum_100K = 1 if hincome == 10 
replace dum_100K = 1 if ID_m >=20213 & hincome == 11 |  hincome == 12 |  hincome == 13 |  hincome == 14 | hincome == 15 
replace dum_incref = 1 if hincome == 11 & ID_m <20213
replace dum_incref = 1 if hincome == 16 & ID_m >=20213
replace dum_30K = 1 if hincome == 1 | hincome == 2
replace dum_31K_70K = 1 if hincome == 3 | hincome == 4 | hincome == 5 | hincome == 6
replace dum_71K_100K = 1 if hincome == 7 | hincome == 8 | hincome == 9
replace dum_31K_80K = 1 if hincome == 3 | hincome == 4 | hincome == 5 | hincome == 6 | hincome == 7
replace dum_81K_100K = 1 if hincome == 8 | hincome == 9
*Vote
replace dum_lib = 1 if vote == 1
replace dum_alp = 1 if vote == 2
replace dum_nat = 1 if vote == 4
replace dum_grn = 1 if vote == 5
replace dum_ind = 1 if vote == 6
replace dum_swing = 1 if vote == 3 | vote ==7 | vote ==8
*Home ownership
replace dum_rent = 1 if homeown == 1
replace dum_mortgage = 1 if homeown == 2
replace dum_outright = 1 if homeown == 3
replace dum_homeother = 1 if homeown == 4
*Employment conditions
replace dum_unempmore  = 1 if emp_cond == 1
replace dum_unempsame = 1 if emp_cond == 2 
replace dum_unempless = 1 if emp_cond == 3 
replace dum_unempdontknow = 1 if emp_cond == 4 

*occupation 
replace dum_managers = 1 if occupation == 1 
replace dum_prof = 1 if occupation == 2
replace dum_paraprof = 1 if occupation == 3 & ID_m<20215
replace dum_community = 1 if occupation == 3 & ID_m>=20216 
replace dum_trades = 1 if occupation == 4
replace dum_clerks = 1 if occupation == 5 
replace dum_salespersons = 1 if occupation == 6 
replace dum_plants = 1 if occupation == 7
replace dum_labourers = 1 if occupation == 8 
replace dum_retired = 1 if occupation == 9 
replace dum_unemploymed =  1 if occupation == 10 
replace dum_occrefused = 1 if occupation == 11  

*family finance vs a year agp
replace dum_cfbetter = 1 if  cfinance == 1 
replace dum_cfsame = 1 if  cfinance == 2
replace dum_cfworse = 1 if  cfinance == 3
replace dum_cfuncertain = 1 if  cfinance == 4

*family finance next 12 months
replace dum_ffbetter = 1 if ffinance == 1 
replace dum_ffsame = 1 if ffinance == 2
replace dum_ffworse = 1 if ffinance == 3
replace dum_ffuncertain = 1 if ffinance == 4

*economic conditions next 12 months
replace dum_eco12mgood = 1 if ecocond12m == 1 | ecocond12m == 2 //expect good economic conditions in the next 12 months
replace dum_eco12mmix = 1 if ecocond12m == 3
replace dum_eco12mbad = 1 if ecocond12m == 4 | ecocond12m == 5
replace dum_eco12muncertain = 1 if ecocond12m == 6
*economic conditions next 5 years
replace dum_eco5ygood = 1 if ecocond5y == 1 | ecocond5y ==2 //expects cotinous good economic conditions for the next 5 years
replace dum_eco5ymix = 1 if ecocond5y ==3
replace dum_eco5ybad = 1 if ecocond5y ==4 | ecocond5y ==5
replace dum_eco5yuncertain = 1 if ecocond5y ==6
*time to buy a major household item 
replace dum_buytimegood = 1 if buyingintent == 1
replace dum_buytimemix = 1 if buyingintent == 2
replace dum_buytimebad = 1 if buyingintent ==3
replace dum_buytimeuncertain = 1 if buyingintent ==4

*Greater capital city and regional areas
replace dum_city = 1 if postcode >= 0800 & postcode <= 0820
replace dum_city = 1 if postcode >= 0828 & postcode <= 0838
replace dum_city = 1 if postcode >= 2000 & postcode <= 2263
replace dum_city = 1 if postcode >= 2555 & postcode <= 2574
replace dum_city = 1 if postcode >= 2600 & postcode <= 2617
replace dum_city = 1 if postcode >= 2745 & postcode <= 2786
replace dum_city = 1 if postcode >= 2900 & postcode <= 2914
replace dum_city = 1 if postcode >= 3000 & postcode <= 3211
replace dum_city = 1 if postcode >= 3335 & postcode <= 3340
replace dum_city = 1 if postcode >= 3427 & postcode <= 3441
replace dum_city = 1 if postcode >= 3750 & postcode <= 3763
replace dum_city = 1 if postcode >= 3765 & postcode <= 3777
replace dum_city = 1 if postcode >= 3781 & postcode <= 3815
replace dum_city = 1 if postcode >= 3910 & postcode <= 3920
replace dum_city = 1 if postcode >= 3926 & postcode <= 3944
replace dum_city = 1 if postcode >= 3975 & postcode <= 3981
replace dum_city = 1 if postcode >= 4000 & postcode <= 4207
replace dum_city = 1 if postcode >= 4280 & postcode <= 4342
replace dum_city = 1 if postcode >= 4500 & postcode <= 4516
replace dum_city = 1 if postcode >= 4520 & postcode <= 4521
replace dum_city = 1 if postcode >= 5000 & postcode <= 5201
replace dum_city = 1 if postcode >= 5231 & postcode <= 5234
replace dum_city = 1 if postcode >= 5240 & postcode <= 5252
replace dum_city = 1 if postcode >= 5950 & postcode <= 5960
replace dum_city = 1 if postcode >= 6000 & postcode <= 6037
replace dum_city = 1 if postcode >= 6050 & postcode <= 6211
replace dum_city = 1 if postcode >= 6556 & postcode <= 6558
replace dum_city = 1 if postcode >= 7000 & postcode <= 7025
replace dum_city = 1 if postcode >= 7030 & postcode <= 7055
replace dum_city = 1 if postcode >= 7170 & postcode <= 7177
replace dum_city = 1 if postcode == 5501
replace dum_city = 1 if postcode == 6907
replace dum_regional = 1 if dum_city == 0
replace dum_regional = 0 if postcode >= 0000 & postcode <= 0199
replace dum_regional = 0 if postcode >= 0300 & postcode <= 0799

******************************************
*		Split exp by Sentiment Groups
******************************************

*Employment conditions 
gen exp_unempmore  = exp if emp_cond == 1
gen exp_unempsame = exp if emp_cond == 2 
gen exp_unempless = exp if emp_cond == 3 
gen exp_unempdontknow = exp if emp_cond == 4


*famil finance vs a year ago
gen exp_cfbetter = exp if  cfinance == 1 
gen exp_cfsame = exp if  cfinance == 2
gen exp_cfworse = exp if  cfinance == 3
gen exp_cfuncertain = exp if  cfinance == 4

*family next 12 months
gen exp_ffbetter = exp if ffinance == 1 
gen exp_ffsame = exp if ffinance == 2
gen exp_ffworse = exp if ffinance == 3
gen exp_ffuncertain = exp if ffinance == 4

*economic conditions next 12 months
gen exp_eco12mgood = exp if ecocond12m == 1 | ecocond12m == 2 //expect good economic conditions in the next 12 months
gen exp_eco12mmix = exp if ecocond12m == 3
gen exp_eco12mbad = exp if ecocond12m == 4 | ecocond12m == 5
gen exp_eco12muncertain = exp if ecocond12m == 6

*economic conditions next 5 years
gen exp_eco5ygood = exp if ecocond5y == 1 | ecocond5y ==2 //expects continous good economic conditions for the next 5 years
gen exp_eco5ymix = exp if ecocond5y ==3
gen exp_eco5ybad = exp if ecocond5y ==4 | ecocond5y ==5
gen exp_eco5yuncertain = exp if ecocond5y ==6

*time to buy a major household item 
gen exp_buytimegood = exp if buyingintent == 1
gen exp_buytimemix = exp if buyingintent == 2
gen exp_buytimebad = exp if buyingintent ==3
gen exp_buytimeuncertain = exp if buyingintent ==4


******************************************
*		Split wexp by Sentiment Groups
******************************************

*Employment conditions 
gen wexp_unempmore  = wexp if emp_cond == 1
gen wexp_unempsame = wexp if emp_cond == 2 
gen wexp_unempless = wexp if emp_cond == 3 
gen wexp_unempdontknow = wexp if emp_cond == 4

*famil finance vs a year agp
gen wexp_cfbetter = wexp if  cfinance == 1 
gen wexp_cfsame = wexp if  cfinance == 2
gen wexp_cfworse = wexp if  cfinance == 3
gen wexp_cfuncertain = wexp if  cfinance == 4

*family next 12 months
gen wexp_ffbetter = wexp if ffinance == 1  
gen wexp_ffsame = wexp if ffinance == 2
gen wexp_ffworse = wexp if ffinance == 3
gen wexp_ffuncertain = wexp if ffinance == 4

*economic conditions next 12 months
gen wexp_eco12mgood = wexp if ecocond12m == 1 | ecocond12m == 2 
gen wexp_eco12mmix = wexp if ecocond12m == 3
gen wexp_eco12mbad = wexp if ecocond12m == 4 | ecocond12m == 5
gen wexp_eco12muncertain = wexp if ecocond12m == 6

*economic conditions next 5 years
gen wexp_eco5ygood = wexp if ecocond5y == 1 | ecocond5y ==2 
gen wexp_eco5ymix = wexp if ecocond5y ==3
gen wexp_eco5ybad = wexp if ecocond5y ==4 | ecocond5y ==5
gen wexp_eco5yuncertain = wexp if ecocond5y ==6

*time to buy a major household item 
gen wexp_buytimegood = wexp if buyingintent == 1
gen wexp_buytimemix = wexp if buyingintent == 2
gen wexp_buytimebad = wexp if buyingintent ==3
gen wexp_buytimeuncertain = wexp if buyingintent ==4

save "$data\Unit data (not for release)\MI Unit Record Data.dta", replace
