

**************************** 2. TABLES & GRAPHS *********************************
**************************** DATE: OCTOBER 2024 ********************************
**************************** AUTHORS: Anthony Brassil, Yahdullah Haidari, Jonathan Hambur, Gulnara Nolan and Callum Ryan *******************************

** The following codes are for table 1 to 3 and graphs 1 to 7. 

global data ""

**************************************************************
************************** TABLES ****************************
**************************************************************

use "$data\Unit data (not for release)\MI Unit Record Data.dta", clear

*********** Table 1: Summary Statistics **********************

tabstat exp exp_certain wexp wexz [aweight=Weight], stat(count mean median sd) columns (stat) 


********** Table 2: Inflation Expectations and Conditions **************

** Full sample
reg exp dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID , vce (robust) 

outreg2 using Regression_results, excel stats(coef) sideway ctitle(fullsample) replace

* Excluding round responses 

reg exp_certain dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID , vce (robust) 

outreg2 using Regression_results, excel stats(coef ) sideway ctitle(exrounded) append 

** 18_34 yo
reg exp_certain dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID if dum_18_34 ==1, vce (robust) 

outreg2 using Regression_results, excel stats(coef ) sideway ctitle(18-34) append

** 45-64 yo 
reg exp_certain dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID if dum_45_64 ==1, vce (robust) 

outreg2 using Regression_results, excel stats(coef) sideway ctitle(45-64) append 

** 65+  
reg exp_certain dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID if dum_over65  ==1, vce (robust) 

outreg2 using Regression_results, excel stats(coef) sideway ctitle(65+) append 

** High income 

reg exp_certain dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID if dum_81K_100K  ==1 | dum_100K == 1, vce (robust) 

outreg2 using Regression_results, excel stats(coef) sideway ctitle(highincome) append 



********** Table 3: Wage Expectations and Conditions **************

** Full model 
reg wexp exp dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID , vce (robust) 

outreg2 using Regression_results_wages, excel stats(coef) sideway ctitle(fullsample) append 

* Excluding zeros

reg wexz exp dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID , vce (robust) 

outreg2 using Regression_results_wages, excel stats(coef ) sideway ctitle(exzeros) append 

** 18_34 yo
reg wexz exp dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID if dum_18_34 ==1, vce (robust) 

outreg2 using Regression_results_wages, excel stats(coef ) sideway ctitle(18-34) append 

** 45-64 yo 
reg wexz exp dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID if dum_45_64 ==1, vce (robust) 

outreg2 using Regression_results_wages, excel stats(coef) sideway ctitle(45-64) append 

** 65+  
reg wexz exp dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID if dum_over65  ==1, vce (robust) 

outreg2 using Regression_results_wages, excel stats(coef) sideway ctitle(65+) append 

** High income 

reg wexz exp dum_female dum_18_34 dum_45_64  dum_over65 dum_managers dum_prof dum_clerks dum_salespersons dum_plants dum_labourers dum_retired dum_unemploymed  dum_occrefused dum_nonsecondary dum_secondary dum_tertiary dum_postgrad  ///
dum_30K dum_81K_100K dum_100K dum_lib dum_nat dum_grn dum_ind dum_swing dum_rent dum_outright dum_homeother dum_regional ///
dum_unempmore dum_unempless dum_unempdontknow dum_eco12mgood dum_eco12mbad dum_eco12muncertain dum_eco5ygood dum_eco5ybad dum_eco5yuncertain dum_cfbetter dum_cfworse dum_cfuncertain dum_ffbetter dum_ffworse dum_ffuncertain dum_buytimegood dum_buytimebad dum_buytimeuncertain i.ID if dum_81K_100K  ==1 | dum_100K == 1, vce (robust) 

outreg2 using Regression_results_wages, excel stats(coef) sideway ctitle(highincome) append 



**************************************************************
************************** GRAPHS ****************************
**************************************************************

* GRAPH 1

tabstat exp exp_certain wexp wexz [aweight=Weight], by(ID) stat(mean) nototal 

* GRAPH 2

tabstat exp_unempmore exp_unempsame exp_unempless exp_ffbetter exp_ffsame exp_ffworse  exp_eco12mgood exp_eco12mmix exp_eco12mbad [aweight=Weight], by(ID) stat (mean) nototal 

* GRAPH 3

* creating new variables to rank sentiment responses (for Graphs 3 and 5)
gen emp_new = . 
replace emp_new = . if emp_cond == . 
replace emp_new = -1 if emp_cond == 1
replace emp_new = 0 if emp_cond == 2
replace emp_new = 1 if emp_cond == 3
replace emp_new = . if emp_cond == 4

gen cf_new = .
replace cf_new = . if cfinance == . 
replace cf_new = 1 if cfinance == 1
replace cf_new = 0 if cfinance == 2
replace cf_new = -1 if cfinance == 3
replace cf_new = . if cfinance == 4

gen ff_new = .
replace ff_new = . if ffinance == . 
replace ff_new = 1 if ffinance == 1
replace ff_new = 0 if ffinance == 2
replace ff_new = -1 if ffinance == 3
replace ff_new = . if ffinance == 4

gen eco12_new = .
replace eco12_new = . if ecocond12m == . 
replace eco12_new = 1 if ecocond12m == 1 | ecocond12m == 2
replace eco12_new = 0 if ecocond12m == 3
replace eco12_new = -1 if ecocond12m == 4 | ecocond12m == 5
replace eco12_new = . if ecocond12m == 6

gen eco5y_new = .
replace eco5y_new = . if ecocond5y == . 
replace eco5y_new = 1 if ecocond5y == 1 | ecocond5y == 2
replace eco5y_new = 0 if ecocond5y== 3
replace eco5y_new = -1 if ecocond5y == 4 | ecocond5y == 5
replace eco5y_new = . if ecocond5y == 6

gen buy_new = .
replace buy_new = . if buyingintent == . 
replace buy_new = 1 if buyingintent == 1
replace buy_new = 0 if buyingintent == 2
replace buy_new = -1 if buyingintent == 3
replace buy_new = . if buyingintent== 4

gen dwelling = .
replace dwelling = . if buydwelling == . 
replace dwelling = 1 if buydwelling == 1
replace dwelling = 0 if buydwelling == 2
replace dwelling = -1 if buydwelling == 3
replace dwelling = . if buydwelling == 4

* binscatter plots 
binscatter emp_new exp [aweight=Weight], nquantiles (100) absorb (ID) savegraph(emp_new.png) savedata(emp_new) replace 
binscatter cf_new exp [aweight=Weight], nquantiles (100) absorb (ID) savegraph(cf_new.png) savedata(cf_new) replace 
binscatter ff_new exp [aweight=Weight], nquantiles (100) absorb (ID) savegraph(ff_new.png) savedata(ff_new) replace 
binscatter eco12_new exp [aweight=Weight], nquantiles (100) absorb (ID) savegraph(eco12_new.png) savedata(eco12_new) replace 
binscatter eco5y_new exp [aweight=Weight], nquantiles (100) absorb (ID)  savegraph(eco5y_new.png) savedata(eco5y_new) replace 
binscatter buy_new exp [aweight=Weight], nquantiles (100) absorb (ID) savegraph(buy_new.png) savedata(buy_new) replace 


* GRAPH 4 

tabstat wexp_unempmore wexp_unempless wexp_buytimegood wexp_buytimebad wexp_cfbetter wexp_cfworse wexp_ffbetter wexp_ffworse  wexp_eco12mgood wexp_eco12mbad wexp_eco5ygood wexp_eco5ybad [aweight=Weight] , by(ID) stat (mean) nototal

* GRAPH 5 

binscatter emp_new wexp if inrange(wexp,-20,20) [aweight=Weight], nquantiles (100) absorb (ID) reportreg savegraph(emp.png) savedata(emp) replace 

binscatter cf_new  wexp if inrange(wexp,-20,20) [aweight=Weight], nquantiles (100) absorb (ID) reportreg savegraph(cf.png) savedata(cf) replace

binscatter ff_new  wexp if inrange(wexp,-20,20) [aweight=Weight], nquantiles (100) absorb (ID) reportreg savegraph(ff.png) savedata(ff) replace

binscatter eco12_new  wexp if inrange(wexp,-20,20) [aweight=Weight], nquantiles (100) absorb (ID) reportreg savegraph(eco12m.png) savedata(eco12m) replace

binscatter eco5y_new  wexp if inrange(wexp,-20,20) [aweight=Weight], nquantiles (100) absorb (ID) reportreg savegraph(eco5y.png) savedata(eco5y) replace

binscatter dwelling  wexp if inrange(wexp,-20,20) [aweight=Weight], nquantiles (100) absorb (ID) reportreg savegraph(buydwelling.png)  savedata(buydwelling) replace


** GRAPH 6

tabstat exp wexp infp [aweight=Weight], by(ID) stat(mean) nototal 


** GRAPH 7 
 
binscatter  wexp exp if  exp!=0 & inrange(exp, -20,30) & wexp!=0 [aweight=Weight], nquantiles (100) absorb (ID) reportreg savedata(exp2) replace 
 
binscatter  wexp infp if  infp!=0 & inrange(infp, -20,30) & wexp!=0 [aweight=Weight], nquantiles (100) absorb (ID) reportreg savedata(infp2) replace 










