
**************************************************************************************************************************************************
******************* Code for 'How Do Households Form Inflation and Wage Expectations' *******************
***********************************************************************************************************************

**************************************************DATE: 16 Sep 2024 ******************************************************************************
**************************************************** AUTHOR: Anthony Brassil, Yahdullah Haidari, Jonathan Hambur, Gulnara Nolan and Callum Ryan *******************************************************************
*********************************************************************************************************************************************
*** Code strcuture
*01. Monetary policy shock effects on inflation expectations
*02. Monetary policy shock effects on wage expectations
*03. Oil shock effects on inflation and wage expectations

global data ""
global results ""


*01. Monetary policy shock effects on inflation expectations
* Figure 8
clear all

set more off

cd "$results"
adopath + ""


use "$data\Unit data (not for release)\MI Unit Record Data.dta", clear



svyset [pw=weight]

*change data to quarterly 
gen qr=.
replace qr=1 if month==1 | month==2 | month==3
replace qr=2 if month==4 | month==5 | month==6
replace qr=3 if month==7 | month==8 | month==9
replace qr=4 if month==10 | month==11 | month==12


**creating expectation variables with including/excluding round numbers

gen exp_zero = exp if exp==0

gen exp_uncertain5 = exp if inlist(exp,-95,-85,-75,-65,-55,-45,-35,-25,-15,-5,5,15,25,35,45,55,65,75,85,95)

gen exp_uncertain10 = exp if inlist(exp,-100,-90,-80,-70,-60,-50,-40,-30,-20,-10,10,20,30,40,50,60,70,80,90,100)

egen exp_uncertain1 = rowmax(exp_zero exp_uncertain5 exp_uncertain10) // includes zeros 

gen exp_certain1=exp if exp_uncertain1==.

*creating new certainty variable to include those who report zeroes
egen exp_uncertain = rowmax(exp_uncertain5 exp_uncertain10) //excludes zeros

gen exp_certain=exp if exp_uncertain==. //inlcudes zeros



*gen testtt=exp if exp!=exp_uncertain1

gen InfExp=exp_certain

replace exp=.  if exp>50 | exp<-50
drop if exp==.


gen lowinc=(hincome==1 | hincome==2 | hincome==3 )
gen midinc=(hincome==4 | hincome==5 | hincome==6 | hincome==7 | hincome==8 | hincome==9)
gen highinc=(hincome==10 | hincome==11 | hincome==12 | hincome==13 | hincome==14 | hincome==15)

sort year month


**creating cohort for pseudo panel
egen groupid=group(age gender hincome)



g income_lvl = 1 if lowinc==1
replace income_lvl = 2 if midinc==1
replace income_lvl = 3 if highinc == 1


egen groupid1=group(age gender hincome state)

drop if exp_certain==.

merge m:1 month year state using "${data}\Macro data for local projections.dta", keep(match)





** Aggregate quarterly.
preserve
collapse(mean) exp  exp_certain wexp ur cpi cpi_q gdp ret_q_nom ret_q_real cr_targ BT beckers beckers_aug  (sum) level path tp [aw=weight], by(year qr)

g period = 4*year + qr

tsset period

g f0_exp = exp_certain
forvalues i = 1/8 {
	g f`i'_exp = f`i'.exp_certain
}
eststo clear

local names
foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_exp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.exp_certain l2.exp_certain, a(qr) vce(cluster period)
	local names `names' `shock'_`i'
	}
}
	*esttab using "$outputsh\aggr.csv", replace nostar
set level 90
esttab using "$results\aggr2_exp.csv", replace ci stats(r2 N)
	
restore


****aggregate with 4 lags 

preserve
collapse(mean) exp  exp_certain wexp ur cpi cpi_q gdp ret_q_nom ret_q_real cr_targ BT beckers beckers_aug  (sum) level path tp [aw=weight], by(year qr)

g period = 4*year + qr

tsset period

g f0_exp = exp_certain
forvalues i = 1/8 {
	g f`i'_exp = f`i'.exp_certain
}
eststo clear

local names
foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_exp `shock'  l(1/4).`shock' l(1/4).gdp l(1/4).cpi_q  l(1/4).ur  l(1/4).exp_certain , a(qr) vce(cluster period)
	local names `names' `shock'_`i'
	}
}
	*esttab using "$outputsh\aggr.csv", replace nostar
set level 90
esttab using "$results\aggr2_exp_4lags.csv", replace ci stats(r2 N)
	
restore


** State quarterly.
preserve
collapse(mean) exp  exp_certain sur scpi scpi_q sgdp sret_q_nom sret_q_real cr_targ BT beckers beckers_aug  (sum)level path tp (rawsum) weight [aw=weight], by(year qr state)

g period = 4*year + qr
encode state, g(state_no)
xtset state_no period

g f0_exp = exp_certain
forvalues i = 1/8 {
	g f`i'_exp = f`i'.exp_certain
}
local names
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_exp  `shock'  l.`shock' l.sgdp l.scpi_q l2.`shock' l2.sgdp l2.scpi_q   l.sur l2.sur l1.exp_certain l2.exp_certain [aw=weight], a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
	*esttab using "$outputsh\state.csv", replace nostar
set level 90
esttab using "$results\state.csv", replace ci stats(r2 N)
restore


** national income.
preserve
collapse(mean) exp  exp_certain  ur cpi cpi_q gdp ret_q_nom ret_q_real cr_targ BT beckers beckers_aug hincome  (sum)level path tp (rawsum)  weight [aw=weight], by(year qr income_lvl)

g period = 4*year + qr


xtset income_lvl period

g f0_exp = exp_certain
forvalues i = 1/8 {
	g f`i'_exp = f`i'.exp_certain
}


local names

** low income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_exp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.exp_certain l2.exp_certain  if income_lvl==1, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}

	*esttab using "$outputsh\panel_low_nat.csv", replace nostar
set level 90
esttab using "$results\panel_low_nat.csv", replace ci stats(r2 N) 


local names

** middle income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_exp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.exp_certain l2.exp_certain  if income_lvl==2, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
	*esttab using "$outputsh\panel_mid_nat.csv", replace nostar
set level 90
esttab using "$results\panel_mid_nat.csv", replace ci stats(r2 N)

local names

** high income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_exp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.exp_certain l2.exp_certain  if income_lvl==3, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
	*esttab using "$outputsh\panel_high_nat.csv", replace nostar
set level 90
esttab using "$results\panel_high_nat.csv", replace ci stats(r2 N)
restore

** national home own.
preserve
collapse(mean) exp exp_certain ur cpi cpi_q gdp ret_q_nom ret_q_real cr_targ BT beckers beckers_aug hincome  (sum)level path tp (rawsum)  weight [aw=weight], by(year qr homeown)

g period = 4*year + qr

xtset homeown period

g f0_exp = exp_certain
forvalues i = 1/8 {
	g f`i'_exp = f`i'.exp_certain
}


local names

** low income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_exp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.exp_certain l2.exp_certain  if homeown==1, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
	*esttab using "$outputsh\panel_home1_nat.csv", replace nostar
set level 90
esttab using "$results\panel_home1_nat.csv", replace ci stats(r2 N)


local names

** middle income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_exp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.exp_certain l2.exp_certain  if homeown==2, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
	*esttab using "$outputsh\panel_home2_nat.csv", replace nostar
set level 90
esttab using "$results\panel_home2_nat.csv", replace ci stats(r2 N)

local names
eststo clear

** high income cohort
foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_exp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.exp_certain l2.exp_certain  if homeown==3, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
	*esttab using "$outputsh\panel_home3_nat.csv", replace nostar
set level 90
esttab using "$outputsh\panel_home3_nat.csv", replace ci stats(r2 N)
restore







*02. Monetary policy shock effects on wage expectations

***MP regressions
*Figure 9

clear all 

use "$data\Unit data (not for release)\MI Unit Record Data Wexp Demographics.dta"

gen wexz = wexp
replace wexz =. if wexp==0

drop if wexz==.
drop if wexz>50 | wexz<-50

gen wexp2=wexp
drop wexp
gen wexp=wexz


gen wexp_zero = wexp if wexp==0

gen wexp_uncertain5 = wexp if inlist(exp,-95,-85,-75,-65,-55,-45,-35,-25,-15,-5,5,15,25,35,45,55,65,75,85,95)

gen wexp_uncertain10 = wexp if inlist(exp,-100,-90,-80,-70,-60,-50,-40,-30,-20,-10,10,20,30,40,50,60,70,80,90,100)

egen wexp_uncertain1 = rowmax(wexp_zero wexp_uncertain5 wexp_uncertain10) // includes zeros 

gen wexp_certain1=exp if wexp_uncertain1==.

*creating new certainty variable to include those who report zeroes
egen wexp_uncertain = rowmax(wexp_uncertain5 wexp_uncertain10) //excludes zeros

gen wexp_certain=exp if wexp_uncertain==. //inlcudes zeros









egen groupid=group(age gender hincome)

gen lowinc=(hincome==1 | hincome==2 | hincome==3 )
gen midinc=(hincome==4 | hincome==5 | hincome==6 | hincome==7 | hincome==8 | hincome==9)
gen highinc=(hincome==10 | hincome==11 | hincome==12 | hincome==13 | hincome==14 | hincome==15)



g income_lvl = 1 if lowinc==1
replace income_lvl = 2 if midinc==1
replace income_lvl = 3 if highinc == 1


egen groupid1=group(age gender hincome state)



gen wexp_certain=wexp

merge m:1 month year state using "$data\Macro data for local projections.dta", keep(match)

** Aggregate quarterly.
preserve
collapse(mean) exp  wexp_certain wexp  ur cpi cpi_q gdp ret_q_nom ret_q_real cr_targ BT beckers beckers_aug  (sum) level path tp [aw=Weight], by(year qr)

g period = 4*year + qr

tsset period

g f0_wexp = wexp_certain
forvalues i = 1/8 {
	g f`i'_wexp = f`i'.wexp_certain
}
eststo clear

local names
foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_wexp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.wexp_certain l2.wexp_certain, a(qr) vce(cluster period)
	local names `names' `shock'_`i'
	}
}
	*esttab using "$outputsh\aggr.csv", replace nostar
set level 90
esttab using "$results\aggr2.csv", replace ci stats(r2 N)
	
restore

** national home own.
preserve
collapse(mean) exp  wexp_certain wexp ur cpi cpi_q gdp ret_q_nom ret_q_real cr_targ BT beckers beckers_aug hincome  (sum)level path tp (rawsum)  Weight [aw=Weight], by(year qr homeown)

g period = 4*year + qr

xtset homeown period

g f0_wexp = wexp_certain
forvalues i = 1/8 {
	g f`i'_wexp = f`i'.wexp_certain
}


local names

** low income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_wexp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.wexp_certain l2.wexp_certain  if homeown==1, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
set level 90
esttab using "$results\panel_home1_nat.csv", replace ci stats(r2 N)


local names

** middle income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_wexp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.wexp_certain l2.wexp_certain  if homeown==2, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
set level 90
esttab using "$results\panel_home2_nat.csv", replace ci stats(r2 N)

local names
eststo clear

** high income cohort
foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_wexp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.wexp_certain l2.wexp_certain  if homeown==3, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
set level 90
esttab using "$results\panel_home3_nat.csv", replace ci stats(r2 N)
restore


** State quarterly.
preserve
collapse(mean) exp  wexp_certain wexp sur scpi scpi_q sgdp sret_q_nom sret_q_real cr_targ BT beckers beckers_aug  (sum)level path tp (rawsum) Weight [aw=Weight], by(year qr state)

g period = 4*year + qr
encode state, g(state_no)
xtset state_no period

g f0_wexp = wexp_certain
forvalues i = 1/8 {
	g f`i'_wexp = f`i'.wexp_certain
}
local names
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_wexp  `shock'  l.`shock' l.sgdp l.scpi_q l2.`shock' l2.sgdp l2.scpi_q l.sur l2.sur l1.wexp_certain l2.wexp_certain [aw=Weight], a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
set level 90
esttab using "$results\state.csv", replace ci stats(r2 N)
restore


** national income.
preserve
collapse(mean) exp  wexp_certain wexp ur cpi cpi_q gdp ret_q_nom ret_q_real cr_targ BT beckers beckers_aug hincome  (sum)level path tp (rawsum)  Weight [aw=Weight], by(year qr income_lvl)

g period = 4*year + qr


xtset income_lvl period

g f0_wexp = wexp_certain
forvalues i = 1/8 {
	g f`i'_wexp = f`i'.wexp_certain
}


local names

** low income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_wexp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.wexp_certain l2.wexp_certain if income_lvl==1, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}

set level 90
esttab using "$outputsh\panel_low_nat.csv", replace ci stats(r2 N) 


local names

** middle income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_wexp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.wexp_certain l2.wexp_certain if income_lvl==2, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
set level 90
esttab using "$results\panel_mid_nat.csv", replace ci stats(r2 N)

local names

** high income cohort
eststo clear

foreach shock in beckers beckers_aug BT level path tp cr_targ {
	forvalues i = 0/8 {
	eststo: areg f`i'_wexp `shock'  l.`shock' l.gdp l.cpi_q l2.`shock' l2.gdp l2.cpi_q l.ur l2.ur l1.wexp_certain l2.wexp_certain if income_lvl==3, a(qr) vce(cluster period)
		local names `names' `shock'_`i'

	}
}
	*esttab using "$outputsh\panel_high_nat.csv", replace nostar
set level 90
esttab using "$results\panel_high_nat.csv", replace ci stats(r2 N)
restore



*03. Oil shock effects on inflation and wage expectations
*** Figure 10

global data "${data}\MI_data"


clear all

set more off

cd "$results"
sysdir set PLUS "${data}\ado\plus"
global outputsh "$results\oil shock"




use "$data\Unit data (not for release)\MI Unit Record Data Wexp Demographics.dta"



svyset [pw=weight]

*change data to quarterly 
gen qr=.
replace qr=1 if month==1 | month==2 | month==3
replace qr=2 if month==4 | month==5 | month==6
replace qr=3 if month==7 | month==8 | month==9
replace qr=4 if month==10 | month==11 | month==12


**creating expectation variables with including/excluding round numbers
replace exp=.  if exp>50 | exp<-50

gen exp_zero = exp if exp==0

gen exp_uncertain5 = exp if inlist(exp,-95,-85,-75,-65,-55,-45,-35,-25,-15,-5,5,15,25,35,45,55,65,75,85,95)

gen exp_uncertain10 = exp if inlist(exp,-100,-90,-80,-70,-60,-50,-40,-30,-20,-10,10,20,30,40,50,60,70,80,90,100)

egen exp_uncertain1 = rowmax(exp_zero exp_uncertain5 exp_uncertain10) // includes zeros 

gen exp_certain1=exp if exp_uncertain1==.

*creating new certainty variable to include those who report zeroes
egen exp_uncertain = rowmax(exp_uncertain5 exp_uncertain10) //excludes zeros

gen exp_certain=exp if exp_uncertain==. //inlcudes zeros

*gen testtt=exp if exp!=exp_uncertain1

gen InfExp=exp_certain

gen lowinc=(hincome==1 | hincome==2 | hincome==3 )
gen midinc=(hincome==4 | hincome==5 | hincome==6 | hincome==7 | hincome==8 | hincome==9)
gen highinc=(hincome==10 | hincome==11 | hincome==12 | hincome==13 | hincome==14 | hincome==15)

sort year month


**creating cohort for pseudo panel
egen groupid=group(age gender hincome)



g income_lvl = 1 if lowinc==1
replace income_lvl = 2 if midinc==1
replace income_lvl = 3 if highinc == 1


egen groupid1=group(age gender hincome state)

replace wexp=.  if wexp>50 | wexp<-50
replace wexp=. if wexp==0
replace exp=.  if exp>50 | exp<-50

gen wexp_zero = wexp if wexp==0

gen wexp_uncertain5 = wexp if inlist(wexp,-95,-85,-75,-65,-55,-45,-35,-25,-15,-5,5,15,25,35,45,55,65,75,85,95)

gen wexp_uncertain10 = wexp if inlist(wexp,-100,-90,-80,-70,-60,-50,-40,-30,-20,-10,10,20,30,40,50,60,70,80,90,100)

egen wexp_uncertain1 = rowmax(wexp_zero wexp_uncertain5 wexp_uncertain10) // includes zeros 

gen wexp_certain1=exp if wexp_uncertain1==.

*creating new certainty variable to include those who report zeroes
egen wexp_uncertain = rowmax(wexp_uncertain5 wexp_uncertain10) //excludes zeros

gen wexp_certain=exp if wexp_uncertain==. //inlcudes zeros
replace wexp_certain =. if wexp_certain==0


g rwage = wexp-exp
g rwage_certain = wexp_certain-exp_certain

replace rwage=. if rwage>50 & rwage<-50
replace rwage_certain=. if rwage_certain>50 & rwage_certain<-50


collapse(mean) exp  exp_certain wexp wexp_certain rwage rwage_certain  [aw=weight], by(year qr)

g time = yq(year, qr)
format time %tq

merge 1:1 time using "G:\Research\GulnaraN\inflation expectations\RDP supplementary docs\code_internal\data\AllQData.dta"
 keep if _m==3
drop _m

tsset time
set level 90

** vars transformation
g cpi = log(valueCPI)*100
g gdp = log(valueGDP)*100
g urate = valueUNEMP
g fuel = log(valueFuel)*100
g cpiexvol = log(cpi_exvol)*100
g durables = log(cpi_durables)*100
g goods = log(cpi_goods)*100
g services = log(cpi_services)*100
g transport = log(valueTransport)*100
g core = log(valueTrim)*100
g wpi = log(wpi_value)*100
g ulc = log(ulc_value)*100
g cpinl = log(cpin)*100
g cpiexfuel = log(cpi_exfuel)*100

** convert to AUD + deflate wti and tapis
foreach x in wti tapis{
	g `x'_aud = `x'*audusd
	g `x'_real = `x'_aud/valueCPI*100
}

g ye_infl = cpi-l4.cpi
g ye_wpi = wpi-l4.wpi

foreach var in wexp wexp_certain exp exp_certain ye_infl ye_wpi rwage rwage_certain {
	g f0_`var' = `var'
	forvalues i = 1/8 {
		g f`i'_`var' = f`i'.`var'
	}
}


eststo clear 

local shock Oilsupplynewsshock_q
foreach var in wexp wexp_certain exp exp_certain rwage rwage_certain {
quietly {
forvalues i = 0/8 {
	eststo: ivregress 2sls f`i'_`var' (fuel=`shock')  l(1/2).`shock' l(1/2).fuel l(1/2).cpi  l(1/2).urate l(1/2).gdp  l(1/2).`var' i.qr if year<2020,  vce(hac nwest)
	}
}
esttab, keep(fuel)
esttab using "$results\oil shock\oil_`var'.csv", replace ci stats(r2 N) keep(fuel)
eststo clearfuel
}

eststo clear 

local shock Oilsupplynewsshock_q
foreach var in wexp wexp_certain exp exp_certain rwage rwage_certain {
quietly {
forvalues i = 0/8 {
eststo: ivregress 2sls f`i'_`var' (fuel=`shock')  l(1/4).`shock' l(1/4).fuel l(1/4).cpi  l(1/4).urate l(1/4).gdp  l(1/4).`var' i.qr if year<2020 ,  vce(hac nwest)
	}
}
esttab, keep(fuel)
esttab using "$results\oil shock\oil_`var'_4lag.csv", replace ci stats(r2 N) keep(fuel)

eststo clear
}




local shock Oilsupplynewsshock_q
foreach var in ye_infl ye_wpi {
quietly {
forvalues i = 0/8 {
eststo: ivregress 2sls f`i'_`var' (fuel=`shock')  l(1/2).`shock' l(1/2).fuel l(1/2).cpi  l(1/2).urate l(1/2).gdp  l(1/2).`var' i.qr if year<2020,  vce(hac nwest)
	}
}
esttab, keep(fuel)
esttab using "$results\oil shock\oil_`var'.csv", replace ci stats(r2 N) keep(fuel)

eststo clear
}




