
%% Load data

load_data;

% Learned variables only enter with a lag, but if last period is NaN then
% code gives an error. So fill period after end of data with some large
% value (shouldn't have any effect on estimation other than letting code
% run).
data{end,2:end} = 1e10;

addpath("..\functions")

%% MAIN RESULTS - reported in paper

%% Table 4

%% Baseline model

sample = dates(187:304); % Set sample period
mdl_data = data; % Data for estimation
mdl_data.cons_exp = expect_nonrounded.all; % Add a series for LHS variable
mdl_data.rba_exp = rba_exp.inflexp; % Add a series for RBA expectations
learn_vars = {"CPI"}; % Select which variables learners learn from
bound = 1; % Bound parameters? (e.g. g>=0)

[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

% Get predicted values (will also plot the data).
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));
% Note: First four observations in estimation sample are used to initialise Kalman filter.
% So model starts in period 5 (this matters because it has time-varying parameters).

%% Model with rounded responses

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI"};
bound = 1;

mdl_data.cons_exp = expect_raw.all;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));

%% Model with inflation perceptions

sample = dates(206:304); % Shorter sample because perceptions data starts later
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;

mdl_data.cons_exp = expect_nonrounded.all;
learn_vars = {"perc_nonrounded_qavg"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(210:end), sample(5:end));

%% By subgroup

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI"};
bound = 1;

subgroup_names = expect_nonrounded.Properties.VariableNames(2:end);

% Set up results_tbl for storing results
param_names = {'Lambda'; 'CPI'; 'c'; 'GFC'; 'eps'; 'eta'};
stats_names = [repmat({'est'}, [length(param_names) 1]); repmat({'se'}, [length(param_names) 1]); repmat({'tstat'}, [length(param_names) 1])];
results_tbl = table(repmat(param_names, [3,1]), stats_names, 'VariableNames', {'Param', 'Stat'});

% Loop over variables in expect_nonrounded
for ii = 1:length(subgroup_names)

    subgroup_names{ii}

    % Set LHS variable to expectation for that subgroup
    mdl_data.cons_exp = expect_nonrounded{:,1+ii};

    [EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

    se = sqrt(diag(EstParamCov));
    tstats = estParams'./se;

    results_tbl.(subgroup_names{ii}) = [estParams'; se; tstats];

end

% Look in results_tbl for results.

%% Sample from 2004 (to align with wage exp sample)

sample = dates(225:304);
mdl_data = data; % Data for estimation
mdl_data.cons_exp = expect_nonrounded.all; % Add a series for LHS variable
mdl_data.rba_exp = rba_exp.inflexp; % Add a series for RBA expectations
learn_vars = {"CPI"}; % Select which variables learners learn from
bound = 1; % Bound parameters? (e.g. g>=0)

[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

%% Break model

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI"};
bound = 0; % Don't bound because the change in lambda/g could be negative. But check to make sure estimates for baseline lambda/g still sensible (i.e. not negative).
break_date = dates(293); % Start of inflation, Sep 2021

mdl_data.cons_exp = expect_nonrounded.all;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_21break_gfcdummy(mdl_data,sample,learn_vars,bound,break_date);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));

%% Figure 11 - requires latest forecast data, which is not published externally

% Construct extended dataset including CPI forecasts for out-of-sample
% projection
dates_fc = [dates; rba_latest_fc.date(3:end)];
CPI_fc = [data.CPI(1:end-1); rba_latest_fc.CPI(2:end)];
rba_exp_fc = [rba_exp.inflexp; rba_latest_fc.CPI(7:end); NaN(4,1)];

cons_exp_fc = [expect_nonrounded.all; NaN(10,1)];

fc_data = table(dates_fc, CPI_fc, cons_exp_fc, rba_exp_fc, 'VariableNames', {'date', 'CPI', 'cons_exp', 'rba_exp'});

sample = dates_fc(187:310); % Up to last period where we have RBA exp
estim_sample_end = dates(304); % Last period we have consumer exp
learn_vars = {"CPI"};
bound = 1;

% Baseline model
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy_fc(fc_data,sample,learn_vars,bound,estim_sample_end);
% Get predicted values (will also plot the data).
plot_data = plot_fit(EstMdl, fc_data.cons_exp(191:310), sample(5:end));
baseline_predicted = plot_data.predicted;
% Note: First four observations in estimation sample are used to initialise Kalman filter.
% So model starts in period 5 (this matters because it has time-varying parameters).

% Break model
bound = 0;
break_date = dates(293); % Start of inflation, Sep 2021
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_21break_gfcdummy_fc(fc_data,sample,learn_vars,bound,estim_sample_end,break_date);
plot_data = plot_fit(EstMdl, fc_data.cons_exp(191:310), sample(5:end));
break_predicted = plot_data.predicted;

%% OTHER RESULTS - not reported in paper
                                            
%% Non-rounded vs all vs trimmed vs just rounded

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI"};
bound = 1;

% Baseline - avg excl rounded resp - baseline equiv
mdl_data.cons_exp = expect_nonrounded.all;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));

% Baseline - avg all resp - reported robustness
mdl_data.cons_exp = expect_raw.all;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));

% Baseline - 30% trimmed mean - not reported
mdl_data.cons_exp = expect_raw.trim;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));

% Baseline - rounded only  - not reported
mdl_data.cons_exp = expect_raw.rounds;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));

%% Excl GST - non-reported robustness

% This just excludes the LHS exp data over the period in which the GST
% introduction is within the forecast horizon. It still allows the GST to
% affect learners' expectations via headline inflation.

% To exclude the latter, could try estimating model with GST-adjusted
% inflation series instead of headline CPI.

sample = dates(187:304);
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;
learn_vars = {"CPI"};
bound = 1;

% Baseline - avg excl rounded resp
mdl_data.cons_exp = expect_nonrounded.all;
mdl_data.cons_exp(205:208) = NaN;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));

% Baseline - avg all resp
mdl_data.cons_exp = expect_raw.all;
mdl_data.cons_exp(205:208) = NaN;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));

% Baseline - 30% trimmed mean
mdl_data.cons_exp = expect_raw.trim;
mdl_data.cons_exp(205:208) = NaN;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(191:end), sample(5:end));

%% Infl perceptions as learned variable

sample = dates(206:304); % Shorter sample because perceptions data starts later
mdl_data = data;
mdl_data.rba_exp = rba_exp.inflexp;

% Nonrounded expectations on LHS 
mdl_data.cons_exp = expect_nonrounded.all;

learn_vars = {"CPI"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(210:end), sample(5:end));

%
learn_vars = {"perc_nonrounded_qavg"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(210:end), sample(5:end));

learn_vars = {"CPI","perc_nonrounded_qavg"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

% Raw expectations on LHS
mdl_data.cons_exp = expect_raw.all;

learn_vars = {"CPI"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(210:end), sample(5:end));

learn_vars = {"perc_raw_qavg"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(210:end), sample(5:end));

learn_vars = {"CPI","perc_raw_qavg"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);