
%% Load data

load_data;

% Learned variables only enter with a lag, but if last period is NaN then
% code gives an error. So fill period after end of data with some large
% value (shouldn't have any effect on estimation other than letting code
% run).
data{end,2:end} = 1e10;

addpath("..\functions")

%% MAIN RESULTS - reported in paper

%% Table 5

%% Baseline model

sample = dates(225:304); % Short sample because RBA forecasts start in 2004 and we don't have up-to-date adjusted series.

mdl_data = data;
mdl_data.cons_exp = expect_raw.wages_nozero;
mdl_data.rba_exp = rba_exp.wexp;
bound = 1;

learn_vars = {"WPI"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data = plot_fit(EstMdl, mdl_data.cons_exp(229:end), sample(5:end));

%% Model with zero responses

sample = dates(225:304); % Short sample because RBA forecasts start in 2004 and we don't have up-to-date adjusted series.

mdl_data = data;
mdl_data.cons_exp = expect_raw.wages;
mdl_data.rba_exp = rba_exp.wexp;
bound = 1;

learn_vars = {"WPI"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
%plot_data_zero = plot_fit(EstMdl, mdl_data.cons_exp(229:end), sample(5:end));

%% Model with wage growth perceptions

sample = dates(225:304); % Short sample because RBA forecasts start in 2004 and we don't have up-to-date adjusted series.

mdl_data = data;
mdl_data.cons_exp = expect_raw.wages_nozero;
mdl_data.rba_exp = rba_exp.wexp;
bound = 1;

learn_vars = {"wperc_nozero_qavg"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);

%% Figure 12

sample = dates(225:304); % Short sample because RBA forecasts start in 2004 and we don't have up-to-date adjusted series.
mdl_data = data;
mdl_data.rba_exp = rba_exp.wexp;
bound = 1;

learn_vars = {"WPI"};

mdl_data.cons_exp = expect_raw.wages_nozero;
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
plot_data_nozero = plot_fit(EstMdl, mdl_data.cons_exp(229:end), sample(5:end));

mdl_data.cons_exp = expect_raw.wages; 
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);
plot_data_withzero = plot_fit(EstMdl, mdl_data.cons_exp(229:end), sample(5:end));

%% OTHER RESULTS - not reported in paper

%% With trimming - not reported

sample = dates(225:304); % Short sample because RBA forecasts start in 2004 and we don't have up-to-date adjusted series.

mdl_data = data;
mdl_data.cons_exp = expect_raw.wages_trim; % LHS variable; adjusted trimmed quarterly avg measure
mdl_data.rba_exp = rba_exp.wexp;
bound = 1;

learn_vars = {"WPI"};
[EstMdl,estParams,EstParamCov,logL,Output] = estimate_constparam_gfcdummy(mdl_data,sample,learn_vars,bound);


