function [A,B,C,D,Mean0,Cov0] = ParamFun(theta, Y, Y_init, dummy_start)

n_learn = size(Y,2)-2;
Y_reg = Y(:,2:end);

lambda = theta(1);
g = theta(2:1+n_learn);
g = g(:)';
c = theta(end-3);
gfc = theta(end-2);
sig_eps = theta(end-1);
sig_eta = theta(end);

% Back out initial values for omega based on expectations and RBA
% expectations in the first four periods
omega_init = flip(1/(1-lambda) * (Y_init(:,1)-lambda*Y_init(:,2) - c));
Mean0 = [1, omega_init', Y_init(end,2), Y_init(end,3:end)];

Cov0 = zeros(length(Mean0));

A = cell(size(Y,1),1);
C = cell(size(Y,1),1);
A_othercol = [zeros(1,5+n_learn);
               0, 0, 0, 1-sum(g), 0, g;
               eye(3), zeros(3,2+n_learn);
               zeros(1+n_learn,5+n_learn)];

for t = 1:size(Y,1)

    A_firstcol = [1;
                  zeros(4,1);
                  Y_reg(t,:)'];

    A{t} = [A_firstcol, A_othercol];

    if t < dummy_start
        C{t} = [c,1-lambda,0,0,0,lambda,zeros(1,n_learn)];
    else
        C{t} = [c+gfc,1-lambda,0,0,0,lambda,zeros(1,n_learn)];
    end

end

B = [0;
     sig_eta;
     zeros(4+n_learn,1)];
D = sig_eps;

end