Bcoef <- function(x){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'var()'.\n")
  }
  y.names <- colnames(x$datamat[, c(1 : x$K)])
  Z <- x$datamat[, -c(1 : x$K)]
  B <- matrix(0, nrow = x$K, ncol = ncol(Z))
  if(is.null(x$restriction)){
    for(i in 1 : x$K){
      B[i, ] <- coef(x$varresult[[i]])
    }
  }else if(!(is.null(x$restriction))){
    for(i in 1 : x$K){
      restrictions <- x$restrictions
      restrictions[i, restrictions[i, ] == TRUE] <- coef(x$varresult[[i]])
      temp <- restrictions[i, ]
      B[i, ] <- temp
    }
  }
  colnames(B) <- colnames(Z)
  rownames(B) <- y.names
  return(B)
}
B <- function(x){
  .Deprecated("Bcoef", package = "vars", msg = "Function 'B' is deprecated; use 'Acoef' instead.\nSee help(\"vars-deprecated\") and help(\"B-deprecated\") for more information.")
  Bcoef(x = x)
}

.fecov <-
  function(x, n.ahead) {
    n.par<-sapply(x$varresult, function(x) summary(x)$df[2])
    n.par[1:length(n.par)] <- min(n.par)
    sigma.u <- crossprod(resid(x))/n.par
    Sigma.yh <- array(NA, dim = c(x$K, x$K, n.ahead))
    Sigma.yh[, , 1] <- sigma.u
    Phi <- vars::Phi(x, nstep = n.ahead)
    if (n.ahead > 1) {
      for (i in 2:n.ahead) {
        temp <- matrix(0, nrow = x$K, ncol = x$K)
        for (j in 2:i) {
          temp <- temp + Phi[, , j] %*% sigma.u %*% t(Phi[, , j])
        }
        Sigma.yh[, , i] <- temp + Sigma.yh[, , 1]
      }
    }
    return(Sigma.yh)
  }

run_fevd <- function(x, n.ahead=10, ...){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'VAR()'.\n")
  }
  n.ahead <- abs(as.integer(n.ahead))
  K <- x$K
  p <- x$p
  ynames <- colnames(x$datamat[, 1 : K])
  msey <- .fecov(x, n.ahead = n.ahead)
  Psi <- vars::Psi(x, nstep = n.ahead)
  mse <- matrix(NA, nrow = n.ahead, ncol = K)
  Omega <- array(0, dim = c(n.ahead, K, K))
  for(i in 1 : n.ahead){
    mse[i, ] <- diag(msey[, , i])
    temp <- matrix(0, K, K)
    for(l in 1 : K){
      for(m in 1 : K){
        for(j in 1 : i){
          temp[l, m] <- temp[l, m] + Psi[l , m, j]^2
        }
      }
    }
    temp <- temp / mse[i, ]
    for(j in 1 : K){
      Omega[i, ,j] <- temp[j, ]
    }
  }
  result <- list()
  for(i in 1 : K){
    result[[i]] <- matrix(Omega[, , i], nrow = n.ahead, ncol = K)
    colnames(result[[i]]) <- ynames
  }
  names(result) <- ynames
  class(result) <- "varfevd"
  return(result)
}

sum_foreign <- function(x) {
  x <- x %>% 
    mutate(foreign = activity_factor + prices_factor + financial_factor) %>%
    dplyr::select(foreign)
}

bootstrap_fevd <- function(x, n.ahead, runs, ortho, cumulative, impulse, response, ci, seed, y.names, f_block=4, input_resmat, foreign_indices=3){
  if(!(is.null(seed))) set.seed(abs(as.integer(seed)))
  if(class(x) == "varest"){
    VAR <- eval.parent(x)
  }else if(class(x) == "svarest"){
    VAR <- eval.parent(x$var)
  } else {
    stop("Bootstrap not implemented for this class.\n")
  }
  p <- VAR$p
  K <- VAR$K
  obs <- VAR$obs
  total <- VAR$totobs
  type <- VAR$type
  B <- Bcoef(VAR)
  BOOT <- vector("list", runs)
  ysampled <- matrix(0, nrow = total, ncol = K)
  colnames(ysampled) <- colnames(VAR$y)
  Zdet <- NULL
  if(ncol(VAR$datamat) > (K * (p+1))){
    Zdet <- as.matrix(VAR$datamat[, (K * (p + 1) + 1):ncol(VAR$datamat)])
  }
  resorig <- scale(resid(VAR), scale = FALSE)
  B <- Bcoef(VAR)
  for(i in 1:runs){
    booted <- sample(c(1 : obs), replace=TRUE)
    resid <- resorig[booted, ]
    lasty <- c(t(VAR$y[p : 1, ]))
    ysampled[c(1 : p), ] <- VAR$y[c(1 : p), ]
    for(j in 1 : obs){
      lasty <- lasty[1 : (K * p)]
      Z <- c(lasty, Zdet[j, ])
      ysampled[j + p, ] <- B %*% Z + resid[j, ]
      lasty <- c(ysampled[j + p, ], lasty)
    }
    varboot <- stats::update(VAR, y = ysampled)
    varboot <- vars::restrict(varboot, method="manual", resmat=input_resmat)
    if(class(x) == "svarest"){
      varboot <- stats::update(x, x = varboot)
      varboot <- vars::restrict(varboot, method="manual", resmat=input_resmat)
    }
    BOOT[[i]] <- run_fevd(x = varboot, n.ahead = n.ahead)
  }
  
  BOOT_foreign <- c()
  for (z in 1 : runs) {
    for (x in 1 : length(BOOT[[1]])){
      BOOT[[z]][x] <- as.list(as.data.frame(BOOT[[z]][x]) %>% mutate(foreign = !!parse_expr(paste0(".[[",paste(unlist(1:foreign_indices), collapse="]]+.[["),"]]"))) %>%
                                dplyr::select(foreign) %>%
                                rename_with(.fn = ~paste0(names(BOOT[[z]][x]), '.', .), .cols = foreign))
    } 
    BOOT_foreign[[z]] <- do.call(cbind, BOOT[[z]])
  }
  
  lower <- ci / 2
  upper <- 1 - ci / 2
  
  BOOT_lower <- matrix(0, nrow(BOOT_foreign[[1]]), ncol(BOOT_foreign[[1]]))
  BOOT_upper <- matrix(0, nrow(BOOT_foreign[[1]]), ncol(BOOT_foreign[[1]]))
  BOOT_mean <- matrix(0, nrow(BOOT_foreign[[1]]), ncol(BOOT_foreign[[1]]))
  BOOT_median <- matrix(0, nrow(BOOT_foreign[[1]]), ncol(BOOT_foreign[[1]]))
  for (y in 1 : ncol(BOOT_foreign[[1]])) {
    for (w in 1 : nrow(BOOT_foreign[[1]])) {
      BOOT_lower[w, y] <- quantile(unlist(lapply(BOOT_foreign, function(x) x[w, y])), lower, na.rm=T)
      BOOT_upper[w, y] <- quantile(unlist(lapply(BOOT_foreign, function(x) x[w, y])), upper, na.rm=T)
      BOOT_median[w, y] <- quantile(unlist(lapply(BOOT_foreign, function(x) x[w, y])), 0.5, na.rm=T)
      BOOT_mean[w, y] <- mean(unlist(lapply(BOOT_foreign, function(x) x[w, y])))
    }
  }

  result <- list(Lower = BOOT_lower, Upper = BOOT_upper, Median = BOOT_median, Mean = BOOT_mean)
  return(result)
}
