## --- Prepare Data --- 
## Load data and segment by category
## Author: P Hendy

# Source processed data for FAVAR
df_global_qtr_stationary <- read.csv(paste0(data_input_folder, 'df_graph_stationary.csv'))
df_graph_stationary <- df_global_qtr_stationary %>% # stationary global data panel
  pivot_longer(!Date, names_to="variable")
df_aus_stationary <- read.csv(paste0(data_input_folder, 'df_aus_stationary.csv')) %>% # stationary Australian data panel
  mutate(Date = as.Date(Date)) %>%
  dplyr::select(-X)
df_small_scale <- read.csv(paste0(data_input_folder, 'df_small_scale.csv')) %>% # stationary US data panel
  mutate(Date = as.Date(Date)) %>%
  dplyr::select(-X)
df_fmg_stationary <- read.csv(paste0(data_input_folder, 'df_fmg_stationary.csv')) %>% # stationary Australian financial data panel
  mutate(Date = as.Date(Date)) %>%
  dplyr::select(-X)

## Segment into separate datasets for each factor
activity_variables <- c("Date", "DE_AIP_IX", "FR_AIP_IX", "IN_AIP_IX", "KR_AIP_IX", "MX_AIP_IX", "RU_AIP_IX", "US_AIP_IX", "NZLPROINDQISMEI", "canada_ip", "uk_ip", "italy_ip", "japan_ip", "china_ip",
                        "CA_NC_R_SA_XDC", "DE_NC_R_SA_XDC", "FR_NC_R_SA_XDC", "IN_NC_R_SA_XDC", "IT_NC_R_SA_XDC", "KR_NC_R_SA_XDC", "MX_NC_R_SA_XDC", "NZ_NC_R_SA_XDC", "RU_NC_R_SA_XDC", "US_NC_R_SA_XDC", "uk_consumption", "japan_consumption",
                        "CA_NFID_R_SA_XDC", "JP_NFID_R_SA_XDC", "NZ_NFID_R_SA_XDC", "US_NFID_R_SA_XDC", "uk_gfcf", "german_gfcf",
                        "CA_NGDP_R_SA_XDC", "DE_NGDP_R_SA_XDC", "FR_NGDP_R_SA_XDC", "GB_NGDP_R_SA_XDC", "IN_NGDP_R_SA_XDC", "IT_NGDP_R_SA_XDC", "KR_NGDP_R_SA_XDC", "MX_NGDP_R_SA_XDC", "NZ_NGDP_R_SA_XDC", "RU_NGDP_R_SA_XDC", "US_NGDP_R_SA_XDC", "japan_rgdp",
                        "CA_NX_R_SA_XDC", "DE_NX_R_SA_XDC", "FR_NX_R_SA_XDC", "GB_NX_R_SA_XDC", "IN_NX_R_SA_XDC", "IT_NX_R_SA_XDC", "KR_NX_R_SA_XDC", "MX_NX_R_SA_XDC", "NZ_NX_R_SA_XDC", "RU_NX_R_SA_XDC", "US_NX_R_SA_XDC", "japan_exports",
                        "CA_LUR_PT", "IT_LUR_PT", "JP_LUR_PT", "KR_LUR_PT", "MX_LUR_PT", "german_unemployment", "uk_unemployment", "nz_unemployment", "us_unemployment", "RU_LUR_PT", "FR_LUR_PT", "china_unemployment"
)
# "KR_NFID_R_SA_XDC",
prices_variables <- c("Date", "CA_PCPI_IX", "CN_PCPI_IX", "DE_PCPI_IX", "FR_PCPI_IX", "GB_PCPI_IX", "IN_PCPI_IX", "IT_PCPI_IX", "JP_PCPI_IX", "KR_PCPI_IX", "MX_PCPI_IX", "RU_PCPI_IX", "US_PCPI_IX", "NZ_PCPI_IX",
                      "DE_PMP_IX", "FR_PMP_IX", "IT_PMP_IX", "JP_PMP_IX", "KR_PMP_IX", "NZ_PMP_IX", "uk_import_prx", "mexico_import_px", "us_import_px", 
                      "DE_PPPI_IX", "GB_PPPI_IX", "KR_PPPI_IX", "US_PPPI_IX", "NZ_PPPI_IX", "china_ppi", "france_ppi", "russia_ppi", "canada_ppi", "india_ppi", "japan_ppi", "mexico_ppi", "italy_ppi",
                      "CA_NGDP_D_SA_IX", "DE_NGDP_D_SA_IX", "FR_NGDP_D_SA_IX", "GB_NGDP_D_SA_IX", "IN_NGDP_D_SA_IX", "IT_NGDP_D_SA_IX", "JP_NGDP_D_SA_IX", "KR_NGDP_D_SA_IX", "MX_NGDP_D_SA_IX", "NZ_NGDP_D_SA_IX", "RU_NGDP_D_SA_IX", "US_NGDP_D_SA_IX"
)
interest_rate_variables <- c("Date", "KR_FPOLM_PA", "MX_FPOLM_PA", "NZ_FPOLM_PA", "US_FPOLM_PA", "RU_FPOLM_PA", "canada_policy_rate", "india_policy_rate", "uk_policy_rate", "china_rrr", "japan_policy_rate", 
                             "IR3TCD01USM156N", "IR3TCD01JPM156N", "IR3TIB01FRM156N", "IR3TIB01DEM156N", "IR3TIB01ITM156N", "IR3TCD01KRM156N", "IR3TIB01CAM156N", "IR3TIB01GBM156N", "IR3TBB01NZM156N", "IR3TIB01MXM156N", "China_10y", "Italy_10y", "INDIRLTLT01STM", 
                             "IRLTLT01USM156N", "IRLTLT01JPM156N", "IRLTLT01FRM156N", "IRLTLT01DEM156N", "IRLTLT01ITM156N", "IRLTLT01KRM156N", "IRLTLT01CAM156N", "IRLTLT01GBM156N", "IRLTLT01NZM156N", "IRLTLT01MXM156N", "IRLTLT01RUM156N", "China_90day", "INDIR3TIB01STM"
)
financial_variables <- c("Date", "SPASTT01USM661N", "SPASTT01JPM661N", "SPASTT01FRM661N", "SPASTT01DEM661N", "SPASTT01ITM661N", "SPASTT01KRM661N", "SPASTT01CAM661N", "SPASTT01GBM661N", "SPASTT01NZM661N", "SPASTT01INM661N", "SPASTT01MXM661N", "China (shanghai composite)",
                         "EXCHUS", "EXJPUS", "EXKOUS", "EXCAUS", "EXUSUK", "EXUSNZ", "EXINUS", "EXMXUS", "eur",
                         "US BAA 10Y spread", "Euro OAS spread", "US corporate HY OAS", "Asian corporate spread to benchmark", "VIX", "JP Morgan EM vol index", "Eurostoxx vix", "Global FX Volatility index"
)

commodity_variables <- c("Date", "WTISPLC", "POILBREUSDM", "GRCPBCUSD", "GRCPBMUSD", "GRCPRCUSD")

# by geography
us_variables <- c("IRLTLT01USM156N", "IR3TCD01USM156N", "US BAA 10Y spread", "US corporate HY OAS", "US_FPOLM_PA", "us_unemployment", "VIX", "SPASTT01USM661N", "US_AIP_IX", "us_import_px", "US_NC_R_SA_XDC", "US_NFID_R_SA_XDC", "US_NGDP_D_SA_IX", "US_NGDP_R_SA_XDC", "US_NX_R_SA_XDC", "US_PCPI_IX", "US_PPPI_IX")
china_variables <- c("China_10y", "China_90day", "china_rrr", "china_unemployment", "China..shanghai.composite.", "china_ip", "china_ppi", "CN_PCPI_IX", "EXCHUS") 
other_ae_variables <- c("CA_LUR_PT", "canada_policy_rate", "Euro OAS spread", "Eurostoxx vix", "FR_LUR_PT", "german_unemployment", "IR3TBB01NZM156N", "IR3TCD01JPM156N", "IR3TCD01KRM156N", "IR3TIB01CAM156N", "IR3TIB01DEM156N", "IR3TIB01FRM156N", "IR3TIB01GBM156N", "IR3TIB01ITM156N", "IRLTLT01CAM156N", "IRLTLT01DEM156N", "IRLTLT01FRM156N", "IRLTLT01GBM156N", "IRLTLT01ITM156N", "IRLTLT01JPM156N", "IRLTLT01KRM156N", "IRLTLT01NZM156N", "IT_LUR_PT", "Italy_10y", "japan_policy_rate", "JP_LUR_PT", "Korea (interbank money market rate)", "KR_FPOLM_PA", "KR_LUR_PT", "NZ_FPOLM_PA", "nz_unemployment", "uk_policy_rate", "uk_unemployment", "CA_NC_R_SA_XDC", "CA_NFID_R_SA_XDC", "CA_NGDP_D_SA_IX", "CA_NGDP_R_SA_XDC", "CA_NX_R_SA_XDC", "CA_PCPI_IX", "canada_ip", "canada_ppi", "DE_AIP_IX", "DE_NC_R_SA_XDC", "DE_NGDP_D_SA_IX", "DE_NGDP_R_SA_XDC", "DE_NX_R_SA_XDC", "DE_PCPI_IX", "DE_PMP_IX", "DE_PPPI_IX", "eur", "EXCAUS", "EXINUS", "EXJPUS", "EXKOUS", "EXUSNZ", "EXUSUK", "FR_AIP_IX", "FR_NC_R_SA_XDC", "FR_NGDP_D_SA_IX", "FR_NGDP_R_SA_XDC", "FR_NX_R_SA_XDC", "FR_PCPI_IX", "FR_PMP_IX", "france_ppi", "GB_NGDP_D_SA_IX", "GB_NGDP_R_SA_XDC", "GB_NX_R_SA_XDC", "GB_PCPI_IX", "GB_PPPI_IX", "german_gfcf", "IT_NC_R_SA_XDC", "IT_NGDP_D_SA_IX", "IT_NGDP_R_SA_XDC", "IT_NX_R_SA_XDC", "IT_PCPI_IX", "IT_PMP_IX", "italy_ip", "italy_ppi", "japan_consumption", "japan_exports", "japan_ip", "japan_ppi", "japan_rgdp", "JP_NFID_R_SA_XDC", "JP_NGDP_D_SA_IX", "JP_PCPI_IX", "JP_PMP_IX", "KR_AIP_IX", "KR_NC_R_SA_XDC", "KR_NFID_R_SA_XDC", "KR_NGDP_D_SA_IX", "KR_NGDP_R_SA_XDC", "KR_NX_R_SA_XDC", "KR_PCPI_IX", "KR_PMP_IX", "KR_PPPI_IX", "NZ_NC_R_SA_XDC", "NZ_NFID_R_SA_XDC", "NZ_NGDP_D_SA_IX", "NZ_NGDP_R_SA_XDC", "NZ_NX_R_SA_XDC", "NZ_PCPI_IX", "NZ_PMP_IX", "NZ_PPPI_IX", "NZLPROINDQISMEI", "SPASTT01CAM661N", "SPASTT01DEM661N", "SPASTT01FRM661N", "SPASTT01GBM661N", "SPASTT01INM661N", "SPASTT01ITM661N", "SPASTT01JPM661N", "SPASTT01KRM661N", "SPASTT01NZM661N", "uk_consumption", "uk_gfcf", "uk_import_prx", "uk_ip") 
other_em_variables <- c("india_policy_rate", "INDIR3TIB01STM", "INDIRLTLT01STM", "IR3TIB01MXM156N", "IRLTLT01MXM156N", "IRLTLT01RUM156N", "JP Morgan EM vol index", "MX_FPOLM_PA", "MX_LUR_PT", "RU_FPOLM_PA", "RU_LUR_PT", "EXMXUS", "IN_AIP_IX", "IN_NC_R_SA_XDC", "IN_NGDP_D_SA_IX", "IN_NGDP_R_SA_XDC", "IN_NX_R_SA_XDC", "IN_PCPI_IX", "india_ppi", "mexico_import_px", "mexico_ppi", "MX_AIP_IX", "MX_NC_R_SA_XDC", "MX_NGDP_D_SA_IX", "MX_NGDP_R_SA_XDC", "MX_NX_R_SA_XDC", "MX_PCPI_IX", "RU_AIP_IX", "RU_NC_R_SA_XDC", "RU_NGDP_D_SA_IX", "RU_NGDP_R_SA_XDC", "RU_NX_R_SA_XDC", "RU_PCPI_IX", "russia_ppi", "SPASTT01MXM661N") 
df_activity_qtr <- df_global_qtr_stationary %>% dplyr::select(activity_variables)
df_prices_qtr <- df_global_qtr_stationary %>% dplyr::select(prices_variables)
df_interest_rate_variables_qtr <- df_global_qtr_stationary %>% dplyr::select(interest_rate_variables)
df_financial_qtr <- df_global_qtr_stationary %>% dplyr::select(financial_variables)
df_commodity_qtr <- df_global_qtr_stationary %>% dplyr::select(commodity_variables)
