## --- Hendy & Beckers (2024) 'How Do Global Shocks Affect Australia? --- 
## --- Run model and generate graph data
## Author: P Hendy

data_input_folder <- "data/"
data_output_folder <- "output/"
code_folder <- "code/"

package_list <- c("tidyverse", "tseries", "seasonal", "zoo", "missMDA", "patchwork", "vars")
new_packages <- package_list[!(package_list %in% install.packages()[, "Package"])]
if(length(new_packages)) install.packages(new_packages)

library(tidyverse)
library(lubridate)
library(readxl)
library(seasonal)
library(tseries)
library(missMDA)
library(viridis)
library(ggrba)
library(patchwork)
library(vars)
library(stats)
library(rlang)

# Prepare data
source(paste0(code_folder, "prep_data.R"))
# Fill in missing data (EM algorithm)
source(paste0(code_folder, "em_algorithm.R"))
# Estimate factors
source(paste0(code_folder, "estimate_dfm.R"))
# Source code to run VAR estimation
source(paste0(code_folder, "bootstrap_fev.R"))
# Run FAVAR and FAVAR experiments
source(paste0(code_folder, "estimate_var.R"))

