**************************************************************************************************************************************************
******************* Code for 'Are Investment Tax Breaks Effective: Australian Evidence' *******************
***************************************************** Code for RDD charts ******************************************************************

**************************************************DATE: Jun 2024 ******************************************************************************
*********************************************************************************************************************************************

** Loop over the periods we are looking at
 foreach per in "& quarter== 1 & year==2010" "& quarter== 2 & year==2010"  "& quarter== 1 & year==2013" "& quarter== 2 & year==2013" "& quarter== 3 & year==2016" "& quarter== 4 & year==2016" "& quarter== 1 & year==2017" {

	use "$data\rdd_$ids.dta", clear

	keep if  income_l<$ubl2 & income_l>$lb2 & income> $lb2 `per' 
	capture drop treatment sales2_t sales2_2t
	** make sure we have hthe variables we need for OLS -style regs
	quietly {
		capture g treatment = 1 if sales2_c<0 & sales2_c!=.
		replace treatment = 0 if sales2_c>0 & sales2_c!=.
		capture g sales2_t =  income_l2*treatment
		
****** Linear regresssions lines either side of the break
**REmove industry
reg lcapex i.industry if income_l2>-400000+$lb2 & income_l2<400000+$lb2
predict resid, residuals

** no controls for idnsutry
*above
reg lcapex treatment income_l2 sales2_t if income_l2>-400000+$lb2 & income_l2<400000+$lb2 & treatment ==0

g cons0 = _b[_cons]
g t_coef0 = _b[treatment]
g sales_coef0 = _b[income_l2]
g sales_coef_t0 = _b[sales2_t]
g r2_0 = `e(r2)'
* below
reg lcapex treatment income_l2 sales2_t if income_l2>-400000+$lb2 & income_l2<400000+$lb2 & treatment ==1

g cons1 = _b[_cons]
g t_coef1 = _b[treatment]
g sales_coef1 = _b[income_l2]
g sales_coef_t1 = _b[sales2_t]
g r2_1 = `e(r2)'


* with constrols for industry
*above
reg resid treatment  income_l2 sales2_t if income_l2>-400000+$lb2 & income_l2<400000+$lb2 & treatment ==0

g cons_contr0 = _b[_cons]
g t_coef_contr0 = _b[treatment]
g sales_coef_contr0 = _b[income_l2]
g sales_coef_t_contr0 = _b[sales2_t]
g r2_contr_0 = `e(r2)'

* below
reg resid treatment   income_l2 sales2_t if income_l2>-400000+$lb2 & income_l2<400000+$lb2 & treatment ==1

g cons_contr1 = _b[_cons]
g t_coef_contr1 = _b[treatment]
g sales_coef_contr1 = _b[income_l2]
g sales_coef_t_contr1 = _b[sales2_t]
g r2_contr_1 = `e(r2)'


*****Collapase down to required buckets for linear and dots
preserve

*Set bins
local bin = 20000

g sales2_round = `bin'*floor(income_l2/`bin') if income_l2>-400000+$lb2 & income_l2<400000+$lb2 // allocate firms to bins
drop if sales2_round == .
g abs_resid = abs(resid)

** Collapse down the linear and the actuals
collapse(mean) resid lcapex cons* t_coe* sales_co* r2* (sum) abs_resid (max) max_abs_resid = abs_resid max_lcapex=lcapex (count) obs=firmid,  by(sales2_round)

** Refit the data to the coefficeints
g fitted_sep = sales_coef0*sales2_round+cons0+sales_coef_t0*sales2_round+t_coef0
replace  fitted_sep = sales_coef1*sales2_round+cons1+sales_coef_t1*sales2_round+t_coef1 if sales2_round<2000000

g r2 = r2_0
replace r2 = r2_1 if  sales2_round<2000000

g fitted_contr_sep = sales_coef_contr0*sales2_round+cons_contr0+sales_coef_t_contr0*sales2_round+t_coef_contr0
replace  fitted_contr_sep = sales_coef_contr1*sales2_round+cons_contr1+sales_coef_t_contr1*sales2_round+t_coef_contr1 if sales2_round<2000000


g r2_contr = r2_contr_0
replace r2_contr = r2_contr_1 if  sales2_round<2000000


keep resid abs_resid lcapex fitted_* max_abs_resid max_lcapex obs  sales2_round r2 r2_contr
export excel using "$savefile\RDD_charts_`ids'.xlsx", sheetreplace firstrow(variables) sheet("l_`per'")
restore

****Construct polynomial fit 
preserve
local bin = 2000
g sales2_round = `bin'*floor(income_l2/`bin') if income_l2>-400000+$lb2 & income_l2<400000+$lb2
drop if sales2_round == .

** Polynominal fir above
lpoly lcapex income_l2 if income_l2>$lb2 & income_l2<400000+$lb2  , degree(2) generate(smooth_grid_high2 smooth_high2) at(sales2_round) bw(50000)
replace smooth_high2=. if income_l2<$lb2
** Polynominal fir below
lpoly lcapex income_l2 if income_l2>-400000+$lb2 & income_l2<$lb2 , degree(2) generate(smooth_grid_low2 smooth_low2) at(sales2_round) bw(50000)
replace smooth_low2=. if income_l2>$lb2

** Versions applied to removed industry
lpoly resid income_l2 if income_l2>$lb2 & income_l2<400000+$lb2  , degree(2) generate(smooth_grid_high_res2 smooth_high_res2) at(sales2_round) bw(50000)
replace smooth_high_res2=. if income_l2<$lb2

lpoly resid income_l2 if income_l2>-400000+$lb2 & income_l2<$lb2  & treatment == 1, degree(2) generate(smooth_grid_low_res2 smooth_low_res2) at(sales2_round) bw(50000)
replace smooth_low_res2=. if income_l2>$lb2

** collapse and output
collapse(mean) smooth_grid_high2 smooth_high2 smooth_grid_low2 smooth_low2 smooth_grid_high_res2 smooth_high_res2 smooth_grid_low_res2 smooth_low_res2, by(sales2_round)
export excel using "$savefile\RDD_charts.xlsx", sheetreplace firstrow(variables) sheet("p_`per'")
restore

	}
 }

 
 
 

 foreach per in  "& quarter== 1 & year==2017"  "& quarter== 2 & year==2017" {

	use "$data\rdd_`ids'.dta", clear

	keep if  income_l<$ubl10 & income_l>$lb10 & income> $lb10 `per' 
	capture drop treatment 
	capture drop sales10_t 
	capture drop sales10_2t
	
		capture g treatment = 1 if sales10_c<0 & sales10_c!=.
		replace treatment = 0 if sales10_c>0 & sales10_c!=.
		capture g sales10_t =  income_l2*treatment
		

**Get coefficients for linear regression
reg lcapex i.industry if income_l2>-2000000+$lb10 & income_l2<2000000+$lb10
predict resid, residuals

** no controls
*high
reg lcapex treatment income_l2 sales10_t if income_l2>-2000000+$lb10 & income_l2<2000000+$lb10 & treatment ==0

g cons0 = _b[_cons]
g t_coef0 = _b[treatment]
g sales_coef0 = _b[income_l2]
g sales_coef_t0 = _b[sales10_t]
g r2_0 = `e(r2)'

* low
reg lcapex treatment income_l2 sales10_t if income_l2>-2000000+$lb10 & income_l2<2000000+$lb10 & treatment ==1

g cons1 = _b[_cons]
g t_coef1 = _b[treatment]
g sales_coef1 = _b[income_l2]
g sales_coef_t1 = _b[sales10_t]
g r2_1 = `e(r2)'


* controls
*high
reg resid treatment  income_l2 sales10_t if income_l2>-2000000+$lb10 & income_l2<2000000+$lb10 & treatment ==0

g cons_contr0 = _b[_cons]
g t_coef_contr0 = _b[treatment]
g sales_coef_contr0 = _b[income_l2]
g sales_coef_t_contr0 = _b[sales10_t]
g r2_contr_0 = `e(r2)'

* low
reg resid treatment   income_l2 sales10_t if income_l2>-2000000+$lb10 & income_l2<2000000+$lb10 & treatment ==1

g cons_contr1 = _b[_cons]
g t_coef_contr1 = _b[treatment]
g sales_coef_contr1 = _b[income_l2]
g sales_coef_t_contr1 = _b[sales10_t]
g r2_contr_1 = `e(r2)'




*** Construct linear and average for buckets
*Collapase down to required buckets for linear and dots
preserve

*Set bins
local bin = 100000

g sales10_round = `bin'*floor(income_l2/`bin') if income_l2>-2000000+$lb10 & income_l2<2000000+$lb10
drop if sales10_round == .
g abs_resid = abs(resid)

collapse(mean) resid lcapex cons* t_coe* sales_co* r2* (sum) abs_resid (max) max_abs_resid = abs_resid max_lcapex=lcapex (count) obs=firmid,  by(sales10_round)


g fitted_sep = sales_coef0*sales10_round+cons0+sales_coef_t0*sales10_round+t_coef0
replace  fitted_sep = sales_coef1*sales10_round+cons1+sales_coef_t1*sales10_round+t_coef1 if sales10_round<10000000

g r2= r2_0 
replace r2 = r2_1 if sales10_round<10000000


g fitted_contr_sep = sales_coef_contr0*sales10_round+cons_contr0+sales_coef_t_contr0*sales10_round+t_coef_contr0
replace  fitted_contr_sep = sales_coef_contr1*sales10_round+cons_contr1+sales_coef_t_contr1*sales10_round+t_coef_contr1 if sales10_round<10000000

g r2_contr= r2_contr_0 
replace r2_contr = r2_contr_1 if sales10_round<10000000

keep resid abs_resid lcapex fitted_* max_abs_resid max_lcapex obs sales10_round r2 r2_contr
export excel using "$savefile\RDD_charts_`ids'.xlsx", sheetreplace firstrow(variables) sheet("l_`per'_10")
restore


preserve
local bin = 10000
g sales10_round = `bin'*floor(income_l2/`bin') if income_l2>-2000000+$lb10 & income_l2<2000000+$lb10
drop if sales10_round == .


*Construct polynomial fit 

lpoly lcapex income_l2 if income_l2>$lb10 & income_l2<2000000+$lb10  , degree(2) generate(smooth_grid_high10 smooth_high10) at(sales10_round) bw(250000)
replace smooth_high10=. if income_l2<$lb10
lpoly lcapex income_l2 if income_l2>-2000000+$lb10 & income_l2<$lb10 , degree(2) generate(smooth_grid_low10 smooth_low10) at(sales10_round) bw(250000)
replace smooth_low10=. if income_l2>$lb10

lpoly resid income_l2 if income_l2>$lb10 & income_l2<2000000+$lb10 , degree(2) generate(smooth_grid_high_res10 smooth_high_res10) at(sales10_round) bw(250000)
replace smooth_high_res10=. if income_l2<$lb2

lpoly resid income_l2 if income_l2>-2000000+$lb10 & income_l2<$lb10  & treatment == 1, degree(2) generate(smooth_grid_low_res10 smooth_low_res10) at(sales10_round) bw(50000)
replace smooth_low_res10=. if income_l2>$lb10

collapse(mean) smooth_grid_high10 smooth_high10 smooth_grid_low10 smooth_low10 smooth_grid_high_res10 smooth_high_res10 smooth_grid_low_res10 smooth_low_res10, by(sales10_round)
export excel using "$savefile\RDD_charts.xlsx", sheetreplace firstrow(variables) sheet("p_`per'_10")
restore

 }
